/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.uri;

import io.helidon.builder.api.Option;
import io.helidon.builder.api.Prototype;
import io.helidon.common.uri.UriBuilderSupport;
import io.helidon.common.uri.UriFragment;
import io.helidon.common.uri.UriPath;
import io.helidon.common.uri.UriQuery;
import java.net.URI;
import java.net.URISyntaxException;

@Prototype.Blueprint(decorator=UriBuilderSupport.UriInfoInterceptor.class)
@Prototype.CustomMethods(value=UriBuilderSupport.UriInfoCustomMethods.class)
interface UriInfoBlueprint {
    @Option.Default(value={"http"})
    public String scheme();

    @Option.Default(value={"localhost"})
    public String host();

    public int port();

    default public String authority() {
        return this.host() + ":" + this.port();
    }

    @Option.Default(value={"root()"})
    public UriPath path();

    @Option.Default(value={"empty()"})
    public UriQuery query();

    @Option.Default(value={"empty()"})
    public UriFragment fragment();

    default public URI toUri() {
        try {
            return new URI(this.scheme(), this.authority(), this.path().path(), this.query().isEmpty() ? null : this.query().value(), this.fragment().hasValue() ? this.fragment().value() : null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("UriInfo cannot be used to create a URI: " + String.valueOf(this), e);
        }
    }
}

