/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.cors;

import io.helidon.common.config.Config;
import io.helidon.common.uri.UriInfo;
import io.helidon.cors.Aggregator;
import io.helidon.cors.CorsRequestAdapter;
import io.helidon.cors.CorsResponseAdapter;
import io.helidon.cors.CrossOriginConfig;
import io.helidon.cors.LogHelper;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNames;
import io.helidon.http.Method;
import io.helidon.http.Status;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.logging.Logger;

public class CorsSupportHelper<Q, R> {
    static final int SUCCESS_RANGE = 300;
    static final String ORIGIN_DENIED = "CORS origin is denied";
    static final String ORIGIN_NOT_IN_ALLOWED_LIST = "CORS origin is not in allowed list";
    static final String METHOD_NOT_IN_ALLOWED_LIST = "CORS method is not in allowed list";
    static final String HEADERS_NOT_IN_ALLOWED_LIST = "CORS headers not in allowed list";
    static final Logger LOGGER = Logger.getLogger(CorsSupportHelper.class.getName());
    static final String OPAQUE_ORIGIN = "null";
    private static final Supplier<Optional<CrossOriginConfig>> EMPTY_SECONDARY_SUPPLIER = Optional::empty;
    private final String name;
    private final Aggregator aggregator;
    private final Supplier<Optional<CrossOriginConfig>> secondaryCrossOriginLookup;

    public static String normalize(String path) {
        int length = path.length();
        if (length == 0) {
            return path;
        }
        int beginIndex = path.charAt(0) == '/' ? 1 : 0;
        int endIndex = path.charAt(length - 1) == '/' ? length - 1 : length;
        return endIndex <= beginIndex ? "" : path.substring(beginIndex, endIndex);
    }

    public static Set<String> parseHeader(String header) {
        if (header == null) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(header, ",");
        while (tokenizer.hasMoreTokens()) {
            String value = tokenizer.nextToken().trim();
            if (value.length() <= 0) continue;
            result.add(value);
        }
        return result;
    }

    public static Set<String> parseHeader(List<String> headers) {
        if (headers == null) {
            return Collections.emptySet();
        }
        return CorsSupportHelper.parseHeader(headers.stream().reduce("", (a, b) -> a + "," + b));
    }

    private CorsSupportHelper(Builder<Q, R> builder) {
        this.name = builder.name;
        this.aggregator = builder.aggregatorBuilder.build();
        this.secondaryCrossOriginLookup = builder.secondaryCrossOriginLookup;
    }

    static <Q, R> Builder<Q, R> builder() {
        return new Builder();
    }

    public boolean isActive() {
        return this.aggregator.isEnabled();
    }

    public Optional<R> processRequest(CorsRequestAdapter<Q> requestAdapter, CorsResponseAdapter<R> responseAdapter) {
        if (!this.isActive()) {
            this.decisionLog(() -> String.format("CORS ignoring request %s; processing is inactive", requestAdapter));
            requestAdapter.next();
            return Optional.empty();
        }
        RequestType requestType = this.requestType(requestAdapter);
        if (requestType == RequestType.NORMAL) {
            this.decisionLog("passing normal request through unchanged");
            return Optional.empty();
        }
        switch (requestType.ordinal()) {
            case 2: {
                return Optional.of(this.processCorsPreFlightRequest(requestAdapter, responseAdapter));
            }
            case 1: {
                return this.processCorsRequest(requestAdapter, responseAdapter);
            }
        }
        throw new IllegalArgumentException("Unexpected value for enum RequestType");
    }

    public String toString() {
        return String.format("CorsSupportHelper{name='%s', isActive=%s, crossOriginConfigs=%s, secondaryCrossOriginLookup=%s}", this.name, this.isActive(), this.aggregator, this.secondaryCrossOriginLookup == EMPTY_SECONDARY_SUPPLIER ? "(not set)" : "(set)");
    }

    public void prepareResponse(CorsRequestAdapter<Q> requestAdapter, CorsResponseAdapter<R> responseAdapter) {
        if (!this.isActive()) {
            this.decisionLog(() -> String.format("CORS ignoring request %s; CORS processing is inactive", requestAdapter));
            return;
        }
        RequestType requestType = this.requestType(requestAdapter, true);
        if (requestType == RequestType.CORS) {
            CrossOriginConfig crossOrigin = responseAdapter.status() == Status.NOT_FOUND_404.code() ? CrossOriginConfig.builder().allowOrigins(requestAdapter.firstHeader(HeaderNames.ORIGIN).orElse("*")).allowMethods(requestAdapter.method()).build() : this.aggregator.lookupCrossOrigin(requestAdapter.path(), requestAdapter.method(), this.secondaryCrossOriginLookup).orElseThrow(() -> new IllegalArgumentException("Could not locate expected CORS information while preparing response to request " + String.valueOf(requestAdapter)));
            this.addCorsHeadersToResponse(crossOrigin, requestAdapter, responseAdapter);
        }
    }

    RequestType requestType(CorsRequestAdapter<Q> requestAdapter, boolean silent) {
        if (CorsSupportHelper.isRequestTypeNormal(requestAdapter, silent)) {
            return RequestType.NORMAL;
        }
        return this.inferCORSRequestType(requestAdapter, silent);
    }

    RequestType requestType(CorsRequestAdapter<Q> requestAdapter) {
        return this.requestType(requestAdapter, false);
    }

    public Aggregator aggregator() {
        return this.aggregator;
    }

    static RequestTypeInfo requestType(String originHeader, UriInfo requestedHostUri) {
        return RequestTypeInfo.create(originHeader, requestedHostUri);
    }

    private static boolean isRequestTypeNormal(CorsRequestAdapter<?> requestAdapter, boolean silent) {
        Optional<String> originOpt = requestAdapter.firstHeader(HeaderNames.ORIGIN);
        if (originOpt.isEmpty()) {
            LogHelper.logIsRequestTypeNormalNoOrigin(silent, requestAdapter);
            return true;
        }
        if (CorsSupportHelper.isOriginOpaque(originOpt.get())) {
            LogHelper.logOpaqueOrigin(silent, requestAdapter);
        }
        RequestTypeInfo result = CorsSupportHelper.requestType(originOpt.get(), requestAdapter.requestedUri());
        LogHelper.logIsRequestTypeNormal(result.isNormal, silent, requestAdapter, originOpt, result.originLocation, result.hostLocation);
        return result.isNormal;
    }

    static boolean isOriginOpaque(String origin) {
        return origin.equals(OPAQUE_ORIGIN);
    }

    private static String originLocation(String origin) {
        int originLastColon;
        int originEndOfScheme = origin.indexOf(58);
        return origin + (String)(originEndOfScheme == (originLastColon = origin.lastIndexOf(58)) && originEndOfScheme >= 0 ? ":" + CorsSupportHelper.portForScheme(origin.substring(0, originEndOfScheme)) : "");
    }

    private static String hostLocation(UriInfo requestedUri) {
        return requestedUri.scheme() + "://" + requestedUri.host() + ":" + requestedUri.port();
    }

    private static String portForScheme(String origin) {
        return origin.startsWith("https") ? "443" : "80";
    }

    private RequestType inferCORSRequestType(CorsRequestAdapter<Q> requestAdapter, boolean silent) {
        String methodName = requestAdapter.method();
        boolean isMethodOPTION = methodName.equalsIgnoreCase(Method.OPTIONS.text());
        boolean requestContainsAccessControlRequestMethodHeader = requestAdapter.headerContainsKey(HeaderNames.ACCESS_CONTROL_REQUEST_METHOD);
        RequestType result = isMethodOPTION && requestContainsAccessControlRequestMethodHeader ? RequestType.PREFLIGHT : RequestType.CORS;
        LogHelper.logInferRequestType(result, silent, requestAdapter, methodName, requestContainsAccessControlRequestMethodHeader);
        return result;
    }

    Optional<R> processCorsRequest(CorsRequestAdapter<Q> requestAdapter, CorsResponseAdapter<R> responseAdapter) {
        Optional<CrossOriginConfig> crossOriginOpt = this.aggregator.lookupCrossOrigin(requestAdapter.path(), requestAdapter.method(), this.secondaryCrossOriginLookup);
        if (crossOriginOpt.isEmpty()) {
            return Optional.of(this.forbid(requestAdapter, responseAdapter, ORIGIN_DENIED, () -> "no matching CORS configuration for path " + requestAdapter.path()));
        }
        CrossOriginConfig crossOriginConfig = crossOriginOpt.get();
        List<String> allowedOrigins = Arrays.asList(crossOriginConfig.allowOrigins());
        Optional<String> originOpt = requestAdapter.firstHeader(HeaderNames.ORIGIN);
        if (!allowedOrigins.contains("*") && !CorsSupportHelper.contains(originOpt, allowedOrigins, CorsSupportHelper::compareOrigins)) {
            return Optional.of(this.forbid(requestAdapter, responseAdapter, ORIGIN_NOT_IN_ALLOWED_LIST, () -> String.format("actual: %s, allowed: %s", originOpt.orElse("(MISSING)"), allowedOrigins)));
        }
        return Optional.empty();
    }

    void addCorsHeadersToResponse(CrossOriginConfig crossOrigin, CorsRequestAdapter<Q> requestAdapter, CorsResponseAdapter<R> responseAdapter) {
        String origin = requestAdapter.firstHeader(HeaderNames.ORIGIN).orElseThrow(CorsSupportHelper.noRequiredHeaderExcFactory(HeaderNames.ORIGIN));
        if (crossOrigin.allowCredentials()) {
            new LogHelper.Headers().add(HeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS, "true").add(HeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, origin).add(HeaderNames.VARY, HeaderNames.ORIGIN).setAndLog(responseAdapter::header, "allow-credentials was set in CORS config");
        } else {
            List<String> allowedOrigins = Arrays.asList(crossOrigin.allowOrigins());
            new LogHelper.Headers().add(HeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, allowedOrigins.contains("*") ? "*" : origin).add(HeaderNames.VARY, HeaderNames.ORIGIN).setAndLog(responseAdapter::header, "allow-credentials was not set in CORS config");
        }
        LogHelper.Headers headers = new LogHelper.Headers();
        CorsSupportHelper.formatHeader(crossOrigin.exposeHeaders()).ifPresent(h -> headers.add(HeaderNames.ACCESS_CONTROL_EXPOSE_HEADERS, h));
        headers.setAndLog(responseAdapter::header, "expose-headers was set in CORS config");
    }

    R processCorsPreFlightRequest(CorsRequestAdapter<Q> requestAdapter, CorsResponseAdapter<R> responseAdapter) {
        Optional<String> originOpt = requestAdapter.firstHeader(HeaderNames.ORIGIN);
        if (originOpt.isEmpty()) {
            return this.forbid(requestAdapter, responseAdapter, CorsSupportHelper.noRequiredHeader(HeaderNames.ORIGIN));
        }
        String requestedMethod = requestAdapter.firstHeader(HeaderNames.ACCESS_CONTROL_REQUEST_METHOD).get();
        Optional<CrossOriginConfig> crossOriginOpt = this.aggregator.lookupCrossOrigin(requestAdapter.path(), requestedMethod, this.secondaryCrossOriginLookup);
        if (crossOriginOpt.isEmpty()) {
            return this.forbid(requestAdapter, responseAdapter, ORIGIN_DENIED, () -> String.format("no matching CORS configuration for path %s and requested method %s", requestAdapter.path(), requestedMethod));
        }
        CrossOriginConfig crossOrigin = crossOriginOpt.get();
        List<String> allowedOrigins = Arrays.asList(crossOrigin.allowOrigins());
        if (!allowedOrigins.contains("*") && !CorsSupportHelper.contains(originOpt, allowedOrigins, CorsSupportHelper::compareOrigins)) {
            return this.forbid(requestAdapter, responseAdapter, ORIGIN_NOT_IN_ALLOWED_LIST, () -> "actual origin: " + (String)originOpt.get() + ", allowedOrigins: " + String.valueOf(allowedOrigins));
        }
        List<String> allowedMethods = Arrays.asList(crossOrigin.allowMethods());
        if (!allowedMethods.contains("*") && !CorsSupportHelper.contains(requestedMethod, allowedMethods, String::equalsIgnoreCase)) {
            return this.forbid(requestAdapter, responseAdapter, METHOD_NOT_IN_ALLOWED_LIST, () -> String.format("header %s requested method %s but allowedMethods is %s", HeaderNames.ACCESS_CONTROL_REQUEST_METHOD, requestedMethod, allowedMethods));
        }
        Set<String> requestHeaders = CorsSupportHelper.parseHeader(requestAdapter.allHeaders(HeaderNames.ACCESS_CONTROL_REQUEST_HEADERS));
        List<String> allowedHeaders = Arrays.asList(crossOrigin.allowHeaders());
        if (!allowedHeaders.contains("*") && !CorsSupportHelper.contains(requestHeaders, allowedHeaders)) {
            return this.forbid(requestAdapter, responseAdapter, HEADERS_NOT_IN_ALLOWED_LIST, () -> String.format("requested headers %s incompatible with allowed headers %s", requestHeaders, allowedHeaders));
        }
        LogHelper.Headers headers = new LogHelper.Headers().add(HeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, originOpt.get());
        if (crossOrigin.allowCredentials()) {
            headers.add(HeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS, "true", "allowCredentials config was set");
        }
        headers.add(HeaderNames.ACCESS_CONTROL_ALLOW_METHODS, requestedMethod);
        CorsSupportHelper.formatHeader(requestHeaders.toArray()).ifPresent(h -> headers.add(HeaderNames.ACCESS_CONTROL_ALLOW_HEADERS, h));
        long maxAgeSeconds = crossOrigin.maxAgeSeconds();
        if (maxAgeSeconds > 0L) {
            headers.add(HeaderNames.ACCESS_CONTROL_MAX_AGE, maxAgeSeconds, "maxAgeSeconds > 0");
        }
        headers.setAndLog(responseAdapter::header, "headers set on preflight request");
        return responseAdapter.ok();
    }

    static <T> Optional<String> formatHeader(T[] array) {
        if (array == null || array.length == 0) {
            return Optional.empty();
        }
        int i = 0;
        StringBuilder builder = new StringBuilder();
        while (true) {
            builder.append(array[i++].toString());
            if (i == array.length) break;
            builder.append(", ");
        }
        return Optional.of(builder.toString());
    }

    static boolean contains(Optional<String> item, Collection<String> collection, BiFunction<String, String, Boolean> eq) {
        return item.isPresent() && CorsSupportHelper.contains(item.get(), collection, eq);
    }

    static boolean contains(String item, Collection<String> collection, BiFunction<String, String, Boolean> eq) {
        for (String s : collection) {
            if (!eq.apply(item, s).booleanValue()) continue;
            return true;
        }
        return false;
    }

    static char charAt(String s, int n, int length) {
        return n < length ? s.charAt(n) : (char)'/';
    }

    static int checkDefaultPort(String url, int k, int length, boolean isHttps) {
        if (isHttps) {
            if (url.charAt(k + 1) != '4' || url.charAt(k + 2) != '4' || url.charAt(k + 3) != '3' || Character.isDigit(CorsSupportHelper.charAt(url, k + 4, length))) {
                return -1;
            }
            return 3;
        }
        if (url.charAt(k + 1) != '8' || url.charAt(k + 2) != '0' || Character.isDigit(CorsSupportHelper.charAt(url, k + 3, length))) {
            return -1;
        }
        return 2;
    }

    static Boolean compareOrigins(String url1, String url2) {
        boolean isHttps = false;
        int length1 = url1.length();
        int length2 = url2.length();
        CompareState state = CompareState.PROTOCOL;
        try {
            int i = 0;
            block7: for (int j = 0; i < length1 || j < length2; ++i, ++j) {
                char c1 = CorsSupportHelper.charAt(url1, i, length1);
                char c2 = CorsSupportHelper.charAt(url2, j, length2);
                switch (state.ordinal()) {
                    case 0: {
                        if (c1 != c2) {
                            return false;
                        }
                        if (c1 != ':') continue block7;
                        boolean bl = isHttps = i == 5;
                        if (url1.charAt(i + 1) != '/' || url1.charAt(i + 2) != '/' || url2.charAt(j + 1) != '/' || url2.charAt(j + 2) != '/') {
                            return false;
                        }
                        i += 2;
                        j += 2;
                        state = CompareState.HOST;
                        continue block7;
                    }
                    case 1: {
                        int n;
                        if (c1 == ':') {
                            if (c2 == ':') continue block7;
                            n = CorsSupportHelper.checkDefaultPort(url1, i, length1, isHttps);
                            if (n < 0) {
                                return false;
                            }
                            i += n;
                            state = CompareState.TRAILING;
                            continue block7;
                        }
                        if (c2 == ':') {
                            n = CorsSupportHelper.checkDefaultPort(url2, j, length2, isHttps);
                            if (n < 0) {
                                return false;
                            }
                            j += n;
                            state = CompareState.TRAILING;
                            continue block7;
                        }
                        if (c1 != c2) {
                            return false;
                        }
                        if (c1 != '/' && (i != length1 - 1 || j != length2 - 1)) continue block7;
                        state = CompareState.TRAILING;
                        continue block7;
                    }
                    case 2: {
                        continue block7;
                    }
                    default: {
                        throw new IllegalStateException("Unknown state");
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
        return state == CompareState.TRAILING;
    }

    static boolean contains(Collection<String> left, Collection<String> right) {
        for (String s : left) {
            if (CorsSupportHelper.contains(s, right, String::equalsIgnoreCase)) continue;
            return false;
        }
        return true;
    }

    private static Supplier<IllegalArgumentException> noRequiredHeaderExcFactory(HeaderName header) {
        return () -> new IllegalArgumentException(CorsSupportHelper.noRequiredHeader(header));
    }

    private static String noRequiredHeader(HeaderName header) {
        return "CORS request does not have required header " + header.defaultCase();
    }

    private R forbid(CorsRequestAdapter<Q> requestAdapter, CorsResponseAdapter<R> responseAdapter, String reason) {
        return this.forbid(requestAdapter, responseAdapter, reason, null);
    }

    private R forbid(CorsRequestAdapter<Q> requestAdapter, CorsResponseAdapter<R> responseAdapter, String publicReason, Supplier<String> privateExplanation) {
        this.decisionLog(() -> String.format("CORS denying request %s: %s", requestAdapter, publicReason + (String)(privateExplanation == null ? "" : "; " + (String)privateExplanation.get())));
        return responseAdapter.forbidden(publicReason);
    }

    private void decisionLog(Supplier<String> messageSupplier) {
        if (LOGGER.isLoggable(LogHelper.DECISION_LEVEL)) {
            this.decisionLog(messageSupplier.get());
        }
    }

    private void decisionLog(String message) {
        LOGGER.log(LogHelper.DECISION_LEVEL, () -> String.format("CORS:%s %s", this.name, message));
    }

    public static class Builder<Q, R>
    implements io.helidon.common.Builder<Builder<Q, R>, CorsSupportHelper<Q, R>> {
        private Supplier<Optional<CrossOriginConfig>> secondaryCrossOriginLookup = EMPTY_SECONDARY_SUPPLIER;
        private final Aggregator.Builder aggregatorBuilder = Aggregator.builder();
        private String name;
        private boolean requestDefaultBehaviorIfNone;

        public Builder<Q, R> secondaryLookupSupplier(Supplier<Optional<CrossOriginConfig>> secondaryLookup) {
            this.secondaryCrossOriginLookup = secondaryLookup;
            return this;
        }

        public Builder<Q, R> config(Config config) {
            this.aggregatorBuilder.config(config);
            return this;
        }

        public Builder<Q, R> mappedConfig(Config config) {
            this.aggregatorBuilder.mappedConfig(config);
            return this;
        }

        public Builder<Q, R> name(String name) {
            Objects.requireNonNull(name, "CORS support name is optional but cannot be null");
            this.name = name;
            return this;
        }

        Builder<Q, R> requestDefaultBehaviorIfNone() {
            this.requestDefaultBehaviorIfNone = true;
            return this;
        }

        private boolean shouldRequestDefaultBehavior() {
            return this.requestDefaultBehaviorIfNone && (this.secondaryCrossOriginLookup == null || this.secondaryCrossOriginLookup == EMPTY_SECONDARY_SUPPLIER);
        }

        public CorsSupportHelper<Q, R> build() {
            if (this.shouldRequestDefaultBehavior()) {
                this.aggregatorBuilder.requestDefaultBehaviorIfNone();
            }
            CorsSupportHelper result = new CorsSupportHelper(this);
            LOGGER.config(() -> String.format("CorsSupportHelper configured as: %s", result.toString()));
            return result;
        }

        Aggregator.Builder aggregatorBuilder() {
            return this.aggregatorBuilder;
        }
    }

    public static enum RequestType {
        NORMAL,
        CORS,
        PREFLIGHT;

    }

    record RequestTypeInfo(String originLocation, String hostLocation, boolean isNormal) {
        static RequestTypeInfo create(String originHeader, UriInfo requestedHostUri) {
            String hostLocation;
            String originLocation;
            return new RequestTypeInfo(originLocation, hostLocation, (originLocation = CorsSupportHelper.originLocation(originHeader)).equals(hostLocation = CorsSupportHelper.hostLocation(requestedHostUri)) || originLocation.equals(CorsSupportHelper.OPAQUE_ORIGIN));
        }
    }

    static enum CompareState {
        PROTOCOL,
        HOST,
        TRAILING;

    }
}

