/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.inject.api;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.types.TypeName;
import io.helidon.inject.api.DependenciesInfoBlueprint;
import io.helidon.inject.api.DependencyInfo;
import io.helidon.inject.api.ServiceInfoCriteria;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;

@Generated(value="io.helidon.builder.processor.BlueprintProcessor", trigger="io.helidon.inject.api.DependenciesInfoBlueprint")
public interface DependenciesInfo
extends DependenciesInfoBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DependenciesInfo instance) {
        return (Builder)DependenciesInfo.builder().from(instance);
    }

    public static DependenciesInfo create() {
        return DependenciesInfo.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, DependenciesInfo>
    implements io.helidon.common.Builder<Builder, DependenciesInfo> {
        private Builder() {
        }

        public DependenciesInfo buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.DependenciesInfoImpl(this);
        }

        public DependenciesInfo build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends DependenciesInfo>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private final Map<ServiceInfoCriteria, Set<DependencyInfo>> serviceInfoDependencies = new LinkedHashMap<ServiceInfoCriteria, Set<DependencyInfo>>();
        private TypeName fromServiceTypeName;

        protected BuilderBase() {
        }

        public BUILDER from(DependenciesInfo prototype) {
            this.addServiceInfoDependencies(prototype.serviceInfoDependencies());
            this.fromServiceTypeName(prototype.fromServiceTypeName());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.addServiceInfoDependencies(builder.serviceInfoDependencies());
            builder.fromServiceTypeName().ifPresent(this::fromServiceTypeName);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER serviceInfoDependencies(Map<? extends ServiceInfoCriteria, Set<DependencyInfo>> serviceInfoDependencies) {
            Objects.requireNonNull(serviceInfoDependencies);
            this.serviceInfoDependencies.clear();
            this.serviceInfoDependencies.putAll(serviceInfoDependencies);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addServiceInfoDependencies(Map<? extends ServiceInfoCriteria, Set<DependencyInfo>> serviceInfoDependencies) {
            Objects.requireNonNull(serviceInfoDependencies);
            this.serviceInfoDependencies.putAll(serviceInfoDependencies);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addServiceInfoDependency(ServiceInfoCriteria key, DependencyInfo serviceInfoDependency) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(serviceInfoDependency);
            this.serviceInfoDependencies.compute(key, (k, v) -> {
                v = v == null ? new LinkedHashSet<DependencyInfo>() : new LinkedHashSet(v);
                v.add(serviceInfoDependency);
                return v;
            });
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addServiceInfoDependencies(ServiceInfoCriteria key, Set<DependencyInfo> serviceInfoDependencies) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(serviceInfoDependencies);
            this.serviceInfoDependencies.compute(key, (k, v) -> {
                v = v == null ? new LinkedHashSet() : new LinkedHashSet(v);
                v.addAll(serviceInfoDependencies);
                return v;
            });
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER putServiceInfoDependency(ServiceInfoCriteria key, Set<DependencyInfo> serviceInfoDependency) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(serviceInfoDependency);
            this.serviceInfoDependencies.put(key, Set.copyOf(serviceInfoDependency));
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearFromServiceTypeName() {
            this.fromServiceTypeName = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER fromServiceTypeName(TypeName fromServiceTypeName) {
            Objects.requireNonNull(fromServiceTypeName);
            this.fromServiceTypeName = fromServiceTypeName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER fromServiceTypeName(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.fromServiceTypeName(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public Map<ServiceInfoCriteria, Set<DependencyInfo>> serviceInfoDependencies() {
            return this.serviceInfoDependencies;
        }

        public Optional<TypeName> fromServiceTypeName() {
            return Optional.ofNullable(this.fromServiceTypeName);
        }

        public String toString() {
            return "DependenciesInfoBuilder{serviceInfoDependencies=" + String.valueOf(this.serviceInfoDependencies) + ",fromServiceTypeName=" + String.valueOf(this.fromServiceTypeName) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        BUILDER fromServiceTypeName(Optional<? extends TypeName> fromServiceTypeName) {
            Objects.requireNonNull(fromServiceTypeName);
            this.fromServiceTypeName = fromServiceTypeName.map(TypeName.class::cast).orElse(this.fromServiceTypeName);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class DependenciesInfoImpl
        implements DependenciesInfo {
            private final Map<ServiceInfoCriteria, Set<DependencyInfo>> serviceInfoDependencies;
            private final Optional<TypeName> fromServiceTypeName;

            protected DependenciesInfoImpl(BuilderBase<?, ?> builder) {
                this.serviceInfoDependencies = Collections.unmodifiableMap(new LinkedHashMap<ServiceInfoCriteria, Set<DependencyInfo>>(builder.serviceInfoDependencies()));
                this.fromServiceTypeName = builder.fromServiceTypeName();
            }

            @Override
            public Map<ServiceInfoCriteria, Set<DependencyInfo>> serviceInfoDependencies() {
                return this.serviceInfoDependencies;
            }

            @Override
            public Optional<TypeName> fromServiceTypeName() {
                return this.fromServiceTypeName;
            }

            public String toString() {
                return "DependenciesInfo{serviceInfoDependencies=" + String.valueOf(this.serviceInfoDependencies) + ",fromServiceTypeName=" + String.valueOf(this.fromServiceTypeName) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DependenciesInfo)) {
                    return false;
                }
                DependenciesInfo other = (DependenciesInfo)o;
                return Objects.equals(this.serviceInfoDependencies, other.serviceInfoDependencies()) && Objects.equals(this.fromServiceTypeName, other.fromServiceTypeName());
            }

            public int hashCode() {
                return Objects.hash(this.serviceInfoDependencies, this.fromServiceTypeName);
            }
        }
    }
}

