/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.inject.api;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.TypeName;
import io.helidon.inject.api.ElementInfoBlueprint;
import io.helidon.inject.api.ElementKind;
import io.helidon.inject.api.Qualifier;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.processor.BlueprintProcessor", trigger="io.helidon.inject.api.ElementInfoBlueprint")
public interface ElementInfo
extends ElementInfoBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ElementInfo instance) {
        return (Builder)ElementInfo.builder().from(instance);
    }

    public static ElementInfo create() {
        return ElementInfo.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, ElementInfo>
    implements io.helidon.common.Builder<Builder, ElementInfo> {
        private Builder() {
        }

        public ElementInfo buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.ElementInfoImpl(this);
        }

        public ElementInfo build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends ElementInfo>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private final Set<Qualifier> qualifiers = new LinkedHashSet<Qualifier>();
        private final Set<Annotation> annotations = new LinkedHashSet<Annotation>();
        private AccessModifier access;
        private boolean staticDeclaration = false;
        private ElementKind elementKind;
        private Integer elementArgs;
        private Integer elementOffset;
        private String elementName;
        private TypeName elementTypeName;
        private TypeName serviceTypeName;

        protected BuilderBase() {
        }

        public BUILDER from(ElementInfo prototype) {
            this.elementKind(prototype.elementKind());
            this.access(prototype.access());
            this.elementTypeName(prototype.elementTypeName());
            this.elementName(prototype.elementName());
            this.elementOffset(prototype.elementOffset());
            this.elementArgs(prototype.elementArgs());
            this.staticDeclaration(prototype.staticDeclaration());
            this.serviceTypeName(prototype.serviceTypeName());
            this.addAnnotations(prototype.annotations());
            this.addQualifiers(prototype.qualifiers());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.elementKind().ifPresent(this::elementKind);
            builder.access().ifPresent(this::access);
            builder.elementTypeName().ifPresent(this::elementTypeName);
            builder.elementName().ifPresent(this::elementName);
            builder.elementOffset().ifPresent(this::elementOffset);
            builder.elementArgs().ifPresent(this::elementArgs);
            this.staticDeclaration(builder.staticDeclaration());
            builder.serviceTypeName().ifPresent(this::serviceTypeName);
            this.addAnnotations(builder.annotations());
            this.addQualifiers(builder.qualifiers());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER elementKind(ElementKind elementKind) {
            Objects.requireNonNull(elementKind);
            this.elementKind = elementKind;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER access(AccessModifier access) {
            Objects.requireNonNull(access);
            this.access = access;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER elementTypeName(TypeName elementTypeName) {
            Objects.requireNonNull(elementTypeName);
            this.elementTypeName = elementTypeName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER elementTypeName(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.elementTypeName(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER elementTypeName(Supplier<? extends TypeName> supplier) {
            Objects.requireNonNull(supplier);
            this.elementTypeName(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER elementName(String elementName) {
            Objects.requireNonNull(elementName);
            this.elementName = elementName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearElementOffset() {
            this.elementOffset = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER elementOffset(int elementOffset) {
            Objects.requireNonNull(elementOffset);
            this.elementOffset = elementOffset;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearElementArgs() {
            this.elementArgs = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER elementArgs(int elementArgs) {
            Objects.requireNonNull(elementArgs);
            this.elementArgs = elementArgs;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER staticDeclaration(boolean staticDeclaration) {
            this.staticDeclaration = staticDeclaration;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER serviceTypeName(TypeName serviceTypeName) {
            Objects.requireNonNull(serviceTypeName);
            this.serviceTypeName = serviceTypeName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER serviceTypeName(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.serviceTypeName(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER serviceTypeName(Supplier<? extends TypeName> supplier) {
            Objects.requireNonNull(supplier);
            this.serviceTypeName(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER annotations(Set<? extends Annotation> annotations) {
            Objects.requireNonNull(annotations);
            this.annotations.clear();
            this.annotations.addAll(annotations);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addAnnotations(Set<? extends Annotation> annotations) {
            Objects.requireNonNull(annotations);
            this.annotations.addAll(annotations);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addAnnotation(Annotation annotation) {
            Objects.requireNonNull(annotation);
            this.annotations.add(annotation);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addAnnotation(Consumer<Annotation.Builder> consumer) {
            Objects.requireNonNull(consumer);
            Annotation.Builder builder = Annotation.builder();
            consumer.accept(builder);
            this.annotations.add(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER qualifiers(Set<? extends Qualifier> qualifiers) {
            Objects.requireNonNull(qualifiers);
            this.qualifiers.clear();
            this.qualifiers.addAll(qualifiers);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addQualifiers(Set<? extends Qualifier> qualifiers) {
            Objects.requireNonNull(qualifiers);
            this.qualifiers.addAll(qualifiers);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addQualifier(Qualifier qualifier) {
            Objects.requireNonNull(qualifier);
            this.qualifiers.add(qualifier);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addQualifier(Consumer<Qualifier.Builder> consumer) {
            Objects.requireNonNull(consumer);
            Qualifier.Builder builder = Qualifier.builder();
            consumer.accept(builder);
            this.qualifiers.add(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<ElementKind> elementKind() {
            return Optional.ofNullable(this.elementKind);
        }

        public Optional<AccessModifier> access() {
            return Optional.ofNullable(this.access);
        }

        public Optional<TypeName> elementTypeName() {
            return Optional.ofNullable(this.elementTypeName);
        }

        public Optional<String> elementName() {
            return Optional.ofNullable(this.elementName);
        }

        public Optional<Integer> elementOffset() {
            return Optional.ofNullable(this.elementOffset);
        }

        public Optional<Integer> elementArgs() {
            return Optional.ofNullable(this.elementArgs);
        }

        public boolean staticDeclaration() {
            return this.staticDeclaration;
        }

        public Optional<TypeName> serviceTypeName() {
            return Optional.ofNullable(this.serviceTypeName);
        }

        public Set<Annotation> annotations() {
            return this.annotations;
        }

        public Set<Qualifier> qualifiers() {
            return this.qualifiers;
        }

        public String toString() {
            return "ElementInfoBuilder{elementKind=" + String.valueOf((Object)this.elementKind) + ",access=" + String.valueOf(this.access) + ",elementTypeName=" + String.valueOf(this.elementTypeName) + ",elementName=" + this.elementName + ",elementOffset=" + this.elementOffset + ",elementArgs=" + this.elementArgs + ",staticDeclaration=" + this.staticDeclaration + ",serviceTypeName=" + String.valueOf(this.serviceTypeName) + ",annotations=" + String.valueOf(this.annotations) + ",qualifiers=" + String.valueOf(this.qualifiers) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.elementKind == null) {
                collector.fatal(this.getClass(), "Property \"elementKind\" must not be null, but not set");
            }
            if (this.access == null) {
                collector.fatal(this.getClass(), "Property \"access\" must not be null, but not set");
            }
            if (this.elementTypeName == null) {
                collector.fatal(this.getClass(), "Property \"elementTypeName\" must not be null, but not set");
            }
            if (this.elementName == null) {
                collector.fatal(this.getClass(), "Property \"elementName\" must not be null, but not set");
            }
            if (this.serviceTypeName == null) {
                collector.fatal(this.getClass(), "Property \"serviceTypeName\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER elementOffset(Optional<Integer> elementOffset) {
            Objects.requireNonNull(elementOffset);
            this.elementOffset = elementOffset.map(Integer.class::cast).orElse(this.elementOffset);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER elementArgs(Optional<Integer> elementArgs) {
            Objects.requireNonNull(elementArgs);
            this.elementArgs = elementArgs.map(Integer.class::cast).orElse(this.elementArgs);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class ElementInfoImpl
        implements ElementInfo {
            private final AccessModifier access;
            private final boolean staticDeclaration;
            private final ElementKind elementKind;
            private final Optional<Integer> elementArgs;
            private final Optional<Integer> elementOffset;
            private final Set<Qualifier> qualifiers;
            private final Set<Annotation> annotations;
            private final String elementName;
            private final TypeName elementTypeName;
            private final TypeName serviceTypeName;

            protected ElementInfoImpl(BuilderBase<?, ?> builder) {
                this.elementKind = builder.elementKind().get();
                this.access = builder.access().get();
                this.elementTypeName = builder.elementTypeName().get();
                this.elementName = builder.elementName().get();
                this.elementOffset = builder.elementOffset();
                this.elementArgs = builder.elementArgs();
                this.staticDeclaration = builder.staticDeclaration();
                this.serviceTypeName = builder.serviceTypeName().get();
                this.annotations = Collections.unmodifiableSet(new LinkedHashSet<Annotation>(builder.annotations()));
                this.qualifiers = Collections.unmodifiableSet(new LinkedHashSet<Qualifier>(builder.qualifiers()));
            }

            @Override
            public ElementKind elementKind() {
                return this.elementKind;
            }

            @Override
            public AccessModifier access() {
                return this.access;
            }

            @Override
            public TypeName elementTypeName() {
                return this.elementTypeName;
            }

            @Override
            public String elementName() {
                return this.elementName;
            }

            @Override
            public Optional<Integer> elementOffset() {
                return this.elementOffset;
            }

            @Override
            public Optional<Integer> elementArgs() {
                return this.elementArgs;
            }

            @Override
            public boolean staticDeclaration() {
                return this.staticDeclaration;
            }

            @Override
            public TypeName serviceTypeName() {
                return this.serviceTypeName;
            }

            @Override
            public Set<Annotation> annotations() {
                return this.annotations;
            }

            @Override
            public Set<Qualifier> qualifiers() {
                return this.qualifiers;
            }

            public String toString() {
                return "ElementInfo{elementKind=" + String.valueOf((Object)this.elementKind) + ",access=" + String.valueOf(this.access) + ",elementTypeName=" + String.valueOf(this.elementTypeName) + ",elementName=" + this.elementName + ",elementOffset=" + String.valueOf(this.elementOffset) + ",elementArgs=" + String.valueOf(this.elementArgs) + ",staticDeclaration=" + this.staticDeclaration + ",serviceTypeName=" + String.valueOf(this.serviceTypeName) + ",annotations=" + String.valueOf(this.annotations) + ",qualifiers=" + String.valueOf(this.qualifiers) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ElementInfo)) {
                    return false;
                }
                ElementInfo other = (ElementInfo)o;
                return Objects.equals((Object)this.elementKind, (Object)other.elementKind()) && Objects.equals(this.access, other.access()) && Objects.equals(this.elementTypeName, other.elementTypeName()) && Objects.equals(this.elementName, other.elementName()) && Objects.equals(this.elementOffset, other.elementOffset()) && Objects.equals(this.elementArgs, other.elementArgs()) && this.staticDeclaration == other.staticDeclaration() && Objects.equals(this.serviceTypeName, other.serviceTypeName()) && Objects.equals(this.annotations, other.annotations()) && Objects.equals(this.qualifiers, other.qualifiers());
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.elementKind, this.access, this.elementTypeName, this.elementName, this.elementOffset, this.elementArgs, this.staticDeclaration, this.serviceTypeName, this.annotations, this.qualifiers});
            }
        }
    }
}

