/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.inject.api;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.inject.api.Interceptor;
import io.helidon.inject.api.InvocationContextBlueprint;
import io.helidon.inject.api.ServiceProvider;
import jakarta.inject.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.processor.BlueprintProcessor", trigger="io.helidon.inject.api.InvocationContextBlueprint")
public interface InvocationContext
extends InvocationContextBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(InvocationContext instance) {
        return (Builder)InvocationContext.builder().from(instance);
    }

    public static InvocationContext create() {
        return InvocationContext.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, InvocationContext>
    implements io.helidon.common.Builder<Builder, InvocationContext> {
        private Builder() {
        }

        public InvocationContext buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.InvocationContextImpl(this);
        }

        public InvocationContext build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends InvocationContext>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private final List<Annotation> classAnnotations = new ArrayList<Annotation>();
        private final List<TypedElementInfo> elementArgInfo = new ArrayList<TypedElementInfo>();
        private final List<Provider<Interceptor>> interceptors = new ArrayList<Provider<Interceptor>>();
        private final Map<String, Object> contextData = new LinkedHashMap<String, Object>();
        private ServiceProvider<?> serviceProvider;
        private TypedElementInfo elementInfo;
        private TypeName serviceTypeName;

        protected BuilderBase() {
        }

        public BUILDER from(InvocationContext prototype) {
            this.serviceProvider(prototype.serviceProvider());
            this.serviceTypeName(prototype.serviceTypeName());
            this.addClassAnnotations(prototype.classAnnotations());
            this.elementInfo(prototype.elementInfo());
            this.addElementArgInfo(prototype.elementArgInfo());
            this.addInterceptors(prototype.interceptors());
            this.addContextData(prototype.contextData());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.serviceProvider().ifPresent(this::serviceProvider);
            builder.serviceTypeName().ifPresent(this::serviceTypeName);
            this.addClassAnnotations(builder.classAnnotations());
            builder.elementInfo().ifPresent(this::elementInfo);
            this.addElementArgInfo(builder.elementArgInfo());
            this.addInterceptors(builder.interceptors());
            this.addContextData(builder.contextData());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER serviceProvider(ServiceProvider<?> serviceProvider) {
            Objects.requireNonNull(serviceProvider);
            this.serviceProvider = serviceProvider;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER serviceTypeName(TypeName serviceTypeName) {
            Objects.requireNonNull(serviceTypeName);
            this.serviceTypeName = serviceTypeName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER serviceTypeName(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.serviceTypeName(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER serviceTypeName(Supplier<? extends TypeName> supplier) {
            Objects.requireNonNull(supplier);
            this.serviceTypeName(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER classAnnotations(List<? extends Annotation> classAnnotations) {
            Objects.requireNonNull(classAnnotations);
            this.classAnnotations.clear();
            this.classAnnotations.addAll(classAnnotations);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addClassAnnotations(List<? extends Annotation> classAnnotations) {
            Objects.requireNonNull(classAnnotations);
            this.classAnnotations.addAll(classAnnotations);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER elementInfo(TypedElementInfo elementInfo) {
            Objects.requireNonNull(elementInfo);
            this.elementInfo = elementInfo;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER elementInfo(Consumer<TypedElementInfo.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypedElementInfo.Builder builder = TypedElementInfo.builder();
            consumer.accept(builder);
            this.elementInfo(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER elementInfo(Supplier<? extends TypedElementInfo> supplier) {
            Objects.requireNonNull(supplier);
            this.elementInfo(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER elementArgInfo(List<? extends TypedElementInfo> elementArgInfo) {
            Objects.requireNonNull(elementArgInfo);
            this.elementArgInfo.clear();
            this.elementArgInfo.addAll(elementArgInfo);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addElementArgInfo(List<? extends TypedElementInfo> elementArgInfo) {
            Objects.requireNonNull(elementArgInfo);
            this.elementArgInfo.addAll(elementArgInfo);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER interceptors(List<Provider<Interceptor>> interceptors) {
            Objects.requireNonNull(interceptors);
            this.interceptors.clear();
            this.interceptors.addAll(interceptors);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addInterceptors(List<Provider<Interceptor>> interceptors) {
            Objects.requireNonNull(interceptors);
            this.interceptors.addAll(interceptors);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER contextData(Map<? extends String, ?> contextData) {
            Objects.requireNonNull(contextData);
            this.contextData.clear();
            this.contextData.putAll(contextData);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addContextData(Map<? extends String, ?> contextData) {
            Objects.requireNonNull(contextData);
            this.contextData.putAll(contextData);
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<ServiceProvider<?>> serviceProvider() {
            return Optional.ofNullable(this.serviceProvider);
        }

        public Optional<TypeName> serviceTypeName() {
            return Optional.ofNullable(this.serviceTypeName);
        }

        public List<Annotation> classAnnotations() {
            return this.classAnnotations;
        }

        public Optional<TypedElementInfo> elementInfo() {
            return Optional.ofNullable(this.elementInfo);
        }

        public List<TypedElementInfo> elementArgInfo() {
            return this.elementArgInfo;
        }

        public List<Provider<Interceptor>> interceptors() {
            return this.interceptors;
        }

        public Map<String, Object> contextData() {
            return this.contextData;
        }

        public String toString() {
            return "InvocationContextBuilder{serviceProvider=" + String.valueOf(this.serviceProvider) + ",serviceTypeName=" + String.valueOf(this.serviceTypeName) + ",classAnnotations=" + String.valueOf(this.classAnnotations) + ",elementInfo=" + String.valueOf(this.elementInfo) + ",elementArgInfo=" + String.valueOf(this.elementArgInfo) + ",interceptors=" + String.valueOf(this.interceptors) + ",contextData=" + String.valueOf(this.contextData) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.serviceProvider == null) {
                collector.fatal(this.getClass(), "Property \"serviceProvider\" must not be null, but not set");
            }
            if (this.serviceTypeName == null) {
                collector.fatal(this.getClass(), "Property \"serviceTypeName\" must not be null, but not set");
            }
            if (this.elementInfo == null) {
                collector.fatal(this.getClass(), "Property \"elementInfo\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        protected static class InvocationContextImpl
        implements InvocationContext {
            private final List<Annotation> classAnnotations;
            private final List<TypedElementInfo> elementArgInfo;
            private final List<Provider<Interceptor>> interceptors;
            private final Map<String, Object> contextData;
            private final ServiceProvider<?> serviceProvider;
            private final TypedElementInfo elementInfo;
            private final TypeName serviceTypeName;

            protected InvocationContextImpl(BuilderBase<?, ?> builder) {
                this.serviceProvider = builder.serviceProvider().get();
                this.serviceTypeName = builder.serviceTypeName().get();
                this.classAnnotations = List.copyOf(builder.classAnnotations());
                this.elementInfo = builder.elementInfo().get();
                this.elementArgInfo = List.copyOf(builder.elementArgInfo());
                this.interceptors = List.copyOf(builder.interceptors());
                this.contextData = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(builder.contextData()));
            }

            @Override
            public ServiceProvider<?> serviceProvider() {
                return this.serviceProvider;
            }

            @Override
            public TypeName serviceTypeName() {
                return this.serviceTypeName;
            }

            @Override
            public List<Annotation> classAnnotations() {
                return this.classAnnotations;
            }

            @Override
            public TypedElementInfo elementInfo() {
                return this.elementInfo;
            }

            @Override
            public List<TypedElementInfo> elementArgInfo() {
                return this.elementArgInfo;
            }

            @Override
            public List<Provider<Interceptor>> interceptors() {
                return this.interceptors;
            }

            @Override
            public Map<String, Object> contextData() {
                return this.contextData;
            }

            public String toString() {
                return "InvocationContext{serviceProvider=" + String.valueOf(this.serviceProvider) + ",serviceTypeName=" + String.valueOf(this.serviceTypeName) + ",classAnnotations=" + String.valueOf(this.classAnnotations) + ",elementInfo=" + String.valueOf(this.elementInfo) + ",elementArgInfo=" + String.valueOf(this.elementArgInfo) + ",interceptors=" + String.valueOf(this.interceptors) + ",contextData=" + String.valueOf(this.contextData) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof InvocationContext)) {
                    return false;
                }
                InvocationContext other = (InvocationContext)o;
                return Objects.equals(this.serviceProvider, other.serviceProvider()) && Objects.equals(this.serviceTypeName, other.serviceTypeName()) && Objects.equals(this.classAnnotations, other.classAnnotations()) && Objects.equals(this.elementInfo, other.elementInfo()) && Objects.equals(this.elementArgInfo, other.elementArgInfo()) && Objects.equals(this.interceptors, other.interceptors()) && Objects.equals(this.contextData, other.contextData());
            }

            public int hashCode() {
                return Objects.hash(this.serviceProvider, this.serviceTypeName, this.classAnnotations, this.elementInfo, this.elementArgInfo, this.interceptors, this.contextData);
            }
        }
    }
}

