/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.inject.api;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.common.types.TypeName;
import io.helidon.inject.api.Qualifier;
import io.helidon.inject.api.ServiceInfoBasicsBlueprint;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.processor.BlueprintProcessor", trigger="io.helidon.inject.api.ServiceInfoBasicsBlueprint")
public interface ServiceInfoBasics
extends ServiceInfoBasicsBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ServiceInfoBasics instance) {
        return (Builder)ServiceInfoBasics.builder().from(instance);
    }

    public static ServiceInfoBasics create() {
        return ServiceInfoBasics.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, ServiceInfoBasics>
    implements io.helidon.common.Builder<Builder, ServiceInfoBasics> {
        private Builder() {
        }

        public ServiceInfoBasics buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.ServiceInfoBasicsImpl(this);
        }

        public ServiceInfoBasics build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends ServiceInfoBasics>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private final Set<Qualifier> qualifiers = new LinkedHashSet<Qualifier>();
        private final Set<TypeName> contractsImplemented = new LinkedHashSet<TypeName>();
        private final Set<TypeName> scopeTypeNames = new LinkedHashSet<TypeName>();
        private Double declaredWeight;
        private Integer declaredRunLevel;
        private TypeName serviceTypeName;

        protected BuilderBase() {
        }

        public BUILDER from(ServiceInfoBasics prototype) {
            this.serviceTypeName(prototype.serviceTypeName());
            this.addScopeTypeNames(prototype.scopeTypeNames());
            this.addQualifiers(prototype.qualifiers());
            this.addContractsImplemented(prototype.contractsImplemented());
            this.declaredRunLevel(prototype.declaredRunLevel());
            this.declaredWeight(prototype.declaredWeight());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.serviceTypeName().ifPresent(this::serviceTypeName);
            this.addScopeTypeNames(builder.scopeTypeNames());
            this.addQualifiers(builder.qualifiers());
            this.addContractsImplemented(builder.contractsImplemented());
            builder.declaredRunLevel().ifPresent(this::declaredRunLevel);
            builder.declaredWeight().ifPresent(this::declaredWeight);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER serviceTypeName(Class<?> type) {
            ServiceInfoBasicsBlueprint.CustomMethods.serviceTypeName(this, type);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addContractImplemented(Class<?> type) {
            ServiceInfoBasicsBlueprint.CustomMethods.addContractImplemented(this, type);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER serviceTypeName(TypeName serviceTypeName) {
            Objects.requireNonNull(serviceTypeName);
            this.serviceTypeName = serviceTypeName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER serviceTypeName(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.serviceTypeName(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER serviceTypeName(Supplier<? extends TypeName> supplier) {
            Objects.requireNonNull(supplier);
            this.serviceTypeName(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER scopeTypeNames(Set<? extends TypeName> scopeTypeNames) {
            Objects.requireNonNull(scopeTypeNames);
            this.scopeTypeNames.clear();
            this.scopeTypeNames.addAll(scopeTypeNames);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addScopeTypeNames(Set<? extends TypeName> scopeTypeNames) {
            Objects.requireNonNull(scopeTypeNames);
            this.scopeTypeNames.addAll(scopeTypeNames);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addScopeTypeName(TypeName scopeTypeName) {
            Objects.requireNonNull(scopeTypeName);
            this.scopeTypeNames.add(scopeTypeName);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addScopeTypeName(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.scopeTypeNames.add(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER qualifiers(Set<? extends Qualifier> qualifiers) {
            Objects.requireNonNull(qualifiers);
            this.qualifiers.clear();
            this.qualifiers.addAll(qualifiers);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addQualifiers(Set<? extends Qualifier> qualifiers) {
            Objects.requireNonNull(qualifiers);
            this.qualifiers.addAll(qualifiers);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addQualifier(Qualifier qualifier) {
            Objects.requireNonNull(qualifier);
            this.qualifiers.add(qualifier);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addQualifier(Consumer<Qualifier.Builder> consumer) {
            Objects.requireNonNull(consumer);
            Qualifier.Builder builder = Qualifier.builder();
            consumer.accept(builder);
            this.qualifiers.add(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER contractsImplemented(Set<? extends TypeName> contractsImplemented) {
            Objects.requireNonNull(contractsImplemented);
            this.contractsImplemented.clear();
            this.contractsImplemented.addAll(contractsImplemented);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addContractsImplemented(Set<? extends TypeName> contractsImplemented) {
            Objects.requireNonNull(contractsImplemented);
            this.contractsImplemented.addAll(contractsImplemented);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addContractImplemented(TypeName contractImplemented) {
            Objects.requireNonNull(contractImplemented);
            this.contractsImplemented.add(contractImplemented);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addContractImplemented(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.contractsImplemented.add(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearDeclaredRunLevel() {
            this.declaredRunLevel = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER declaredRunLevel(int declaredRunLevel) {
            Objects.requireNonNull(declaredRunLevel);
            this.declaredRunLevel = declaredRunLevel;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearDeclaredWeight() {
            this.declaredWeight = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER declaredWeight(double declaredWeight) {
            Objects.requireNonNull(declaredWeight);
            this.declaredWeight = declaredWeight;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<TypeName> serviceTypeName() {
            return Optional.ofNullable(this.serviceTypeName);
        }

        public Set<TypeName> scopeTypeNames() {
            return this.scopeTypeNames;
        }

        public Set<Qualifier> qualifiers() {
            return this.qualifiers;
        }

        public Set<TypeName> contractsImplemented() {
            return this.contractsImplemented;
        }

        public Optional<Integer> declaredRunLevel() {
            return Optional.ofNullable(this.declaredRunLevel);
        }

        public Optional<Double> declaredWeight() {
            return Optional.ofNullable(this.declaredWeight);
        }

        public String toString() {
            return "ServiceInfoBasicsBuilder{serviceTypeName=" + String.valueOf(this.serviceTypeName) + ",scopeTypeNames=" + String.valueOf(this.scopeTypeNames) + ",qualifiers=" + String.valueOf(this.qualifiers) + ",contractsImplemented=" + String.valueOf(this.contractsImplemented) + ",declaredRunLevel=" + this.declaredRunLevel + ",declaredWeight=" + this.declaredWeight + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.serviceTypeName == null) {
                collector.fatal(this.getClass(), "Property \"serviceTypeName\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER declaredRunLevel(Optional<Integer> declaredRunLevel) {
            Objects.requireNonNull(declaredRunLevel);
            this.declaredRunLevel = declaredRunLevel.map(Integer.class::cast).orElse(this.declaredRunLevel);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER declaredWeight(Optional<Double> declaredWeight) {
            Objects.requireNonNull(declaredWeight);
            this.declaredWeight = declaredWeight.map(Double.class::cast).orElse(this.declaredWeight);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class ServiceInfoBasicsImpl
        implements ServiceInfoBasics {
            private final Optional<Double> declaredWeight;
            private final Optional<Integer> declaredRunLevel;
            private final Set<Qualifier> qualifiers;
            private final Set<TypeName> contractsImplemented;
            private final Set<TypeName> scopeTypeNames;
            private final TypeName serviceTypeName;

            protected ServiceInfoBasicsImpl(BuilderBase<?, ?> builder) {
                this.serviceTypeName = builder.serviceTypeName().get();
                this.scopeTypeNames = Collections.unmodifiableSet(new LinkedHashSet<TypeName>(builder.scopeTypeNames()));
                this.qualifiers = Collections.unmodifiableSet(new LinkedHashSet<Qualifier>(builder.qualifiers()));
                this.contractsImplemented = Collections.unmodifiableSet(new LinkedHashSet<TypeName>(builder.contractsImplemented()));
                this.declaredRunLevel = builder.declaredRunLevel();
                this.declaredWeight = builder.declaredWeight();
            }

            @Override
            public TypeName serviceTypeName() {
                return this.serviceTypeName;
            }

            @Override
            public Set<TypeName> scopeTypeNames() {
                return this.scopeTypeNames;
            }

            @Override
            public Set<Qualifier> qualifiers() {
                return this.qualifiers;
            }

            @Override
            public Set<TypeName> contractsImplemented() {
                return this.contractsImplemented;
            }

            @Override
            public Optional<Integer> declaredRunLevel() {
                return this.declaredRunLevel;
            }

            @Override
            public Optional<Double> declaredWeight() {
                return this.declaredWeight;
            }

            public String toString() {
                return "ServiceInfoBasics{serviceTypeName=" + String.valueOf(this.serviceTypeName) + ",scopeTypeNames=" + String.valueOf(this.scopeTypeNames) + ",qualifiers=" + String.valueOf(this.qualifiers) + ",contractsImplemented=" + String.valueOf(this.contractsImplemented) + ",declaredRunLevel=" + String.valueOf(this.declaredRunLevel) + ",declaredWeight=" + String.valueOf(this.declaredWeight) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ServiceInfoBasics)) {
                    return false;
                }
                ServiceInfoBasics other = (ServiceInfoBasics)o;
                return Objects.equals(this.serviceTypeName, other.serviceTypeName()) && Objects.equals(this.scopeTypeNames, other.scopeTypeNames()) && Objects.equals(this.qualifiers, other.qualifiers()) && Objects.equals(this.contractsImplemented, other.contractsImplemented()) && Objects.equals(this.declaredRunLevel, other.declaredRunLevel()) && Objects.equals(this.declaredWeight, other.declaredWeight());
            }

            public int hashCode() {
                return Objects.hash(this.serviceTypeName, this.scopeTypeNames, this.qualifiers, this.contractsImplemented, this.declaredRunLevel, this.declaredWeight);
            }
        }
    }
}

