/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.metrics;

import io.helidon.metrics.api.HistogramSnapshot;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.stream.StreamSupport;
import org.eclipse.microprofile.metrics.Snapshot;

class HelidonSnapshot
extends Snapshot {
    private final HistogramSnapshot delegate;

    public static HelidonSnapshot create(HistogramSnapshot histogramSnapshot) {
        return new HelidonSnapshot(histogramSnapshot);
    }

    private HelidonSnapshot(HistogramSnapshot histogramSnapshot) {
        this.delegate = histogramSnapshot;
    }

    public long size() {
        return this.delegate.count();
    }

    public double getMax() {
        return this.delegate.max();
    }

    public double getMean() {
        return this.delegate.mean();
    }

    public Snapshot.PercentileValue[] percentileValues() {
        return (Snapshot.PercentileValue[])StreamSupport.stream(this.delegate.percentileValues().spliterator(), false).map(pv -> new Snapshot.PercentileValue(pv.percentile(), pv.value())).toArray(Snapshot.PercentileValue[]::new);
    }

    public void dump(OutputStream output) {
        this.delegate.outputSummary(new PrintStream(output, false, Charset.defaultCharset()), 1.0);
    }
}

