/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.metrics;

import io.helidon.microprofile.metrics.InterceptionRunner;
import io.helidon.microprofile.metrics.InterceptionRunnerImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

class InterceptionTargetInfo<T> {
    private final InterceptionRunner runner;
    private final Map<Class<?>, Collection<T>> workItemsByAnnotationType = new HashMap();

    static <T> InterceptionTargetInfo<T> create(Executable executable) {
        return new InterceptionTargetInfo<T>(InterceptionRunnerImpl.create(executable));
    }

    private InterceptionTargetInfo(InterceptionRunner runner) {
        this.runner = runner;
    }

    InterceptionRunner runner() {
        return this.runner;
    }

    Iterable<T> workItems(Class<? extends Annotation> annotationType) {
        return this.workItemsByAnnotationType.get(annotationType);
    }

    void addWorkItem(Class<? extends Annotation> annotationType, T workItem) {
        Collection workItems = this.workItemsByAnnotationType.computeIfAbsent(annotationType, c -> new HashSet());
        workItems.add(workItem);
    }
}

