/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.metrics;

import io.helidon.microprofile.metrics.MetricAnnotationDiscovery;
import jakarta.enterprise.inject.spi.configurator.AnnotatedConstructorConfigurator;
import jakarta.enterprise.inject.spi.configurator.AnnotatedMethodConfigurator;
import jakarta.enterprise.inject.spi.configurator.AnnotatedTypeConfigurator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.util.StringJoiner;

abstract class MetricAnnotationDiscoveryBase
implements MetricAnnotationDiscovery {
    private final AnnotatedTypeConfigurator<?> annotatedTypeConfigurator;
    private final Annotation annotation;
    private boolean isActive = true;
    private boolean useDefaultInterceptor = true;

    private MetricAnnotationDiscoveryBase(AnnotatedTypeConfigurator<?> annotatedTypeConfigurator, Annotation annotation) {
        this.annotatedTypeConfigurator = annotatedTypeConfigurator;
        this.annotation = annotation;
    }

    static <C> MetricAnnotationDiscoveryBase create(AnnotatedTypeConfigurator<?> annotatedTypeConfigurator, C annotatedCallableConfigurator, Annotation annotation) {
        if (annotatedCallableConfigurator instanceof AnnotatedConstructorConfigurator) {
            return new OfConstructor(annotatedTypeConfigurator, (AnnotatedConstructorConfigurator)annotatedCallableConfigurator, annotation);
        }
        if (annotatedCallableConfigurator instanceof AnnotatedMethodConfigurator) {
            return new OfMethod(annotatedTypeConfigurator, (AnnotatedMethodConfigurator)annotatedCallableConfigurator, annotation);
        }
        throw new IllegalArgumentException(String.format("annotatedCallableConfigurator must be of type %s or %s", AnnotatedConstructorConfigurator.class.getName(), AnnotatedMethodConfigurator.class.getName()));
    }

    @Override
    public AnnotatedTypeConfigurator<?> annotatedTypeConfigurator() {
        return this.annotatedTypeConfigurator;
    }

    @Override
    public Annotation annotation() {
        return this.annotation;
    }

    @Override
    public void deactivate() {
        this.isActive = false;
        this.disableDefaultInterceptor();
    }

    @Override
    public void disableDefaultInterceptor() {
        this.useDefaultInterceptor = false;
    }

    public String toString() {
        return new StringJoiner(", ", this.getClass().getSimpleName() + "[", "]").add("annotatedConfigurator=" + String.valueOf(this.annotatedMember())).add("annotatedTypeConfigurator=" + this.annotatedTypeConfigurator.getAnnotated().getJavaClass().getName()).add("annotation=" + String.valueOf(this.annotation)).add("isActive=" + this.isActive).add("useDefaultInterceptor=" + this.useDefaultInterceptor).toString();
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    boolean shouldUseDefaultInterceptor() {
        return this.useDefaultInterceptor;
    }

    protected abstract Member annotatedMember();

    private static class OfConstructor
    extends MetricAnnotationDiscoveryBase
    implements MetricAnnotationDiscovery.OfConstructor {
        private final AnnotatedConstructorConfigurator<?> configurator;

        private OfConstructor(AnnotatedTypeConfigurator<?> annotatedTypeConfigurator, AnnotatedConstructorConfigurator<?> annotatedConstructorConfigurator, Annotation annotation) {
            super(annotatedTypeConfigurator, annotation);
            this.configurator = annotatedConstructorConfigurator;
        }

        @Override
        public AnnotatedConstructorConfigurator<?> configurator() {
            return this.configurator;
        }

        @Override
        protected Member annotatedMember() {
            return this.configurator.getAnnotated().getJavaMember();
        }
    }

    private static class OfMethod
    extends MetricAnnotationDiscoveryBase
    implements MetricAnnotationDiscovery.OfMethod {
        private final AnnotatedMethodConfigurator<?> configurator;

        private OfMethod(AnnotatedTypeConfigurator<?> annotatedTypeConfigurator, AnnotatedMethodConfigurator<?> annotatedMethodConfigurator, Annotation annotation) {
            super(annotatedTypeConfigurator, annotation);
            this.configurator = annotatedMethodConfigurator;
        }

        @Override
        public AnnotatedMethodConfigurator<?> configurator() {
            return this.configurator;
        }

        @Override
        protected Member annotatedMember() {
            return this.configurator.getAnnotated().getJavaMember();
        }
    }
}

