/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.metrics;

import io.helidon.microprofile.metrics.MetricUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetadataBuilder;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Timed;

class MetricAnnotationInfo<A extends Annotation, T extends Metric> {
    static final Map<Class<? extends Annotation>, Class<? extends Metric>> ANNOTATION_TYPE_TO_METRIC_TYPE = Map.of(Counted.class, Counter.class, Timed.class, Timer.class);
    static final Map<Class<? extends Annotation>, MetricAnnotationInfo<?, ?>> ANNOTATION_TYPE_TO_INFO = Map.of(Counted.class, new MetricAnnotationInfo<Counted, Counter>(Counted.class, Counted::name, Counted::absolute, Counted::description, Counted::unit, Counted::tags, Counted::scope, MetricRegistry::counter, Counter.class), Timed.class, new MetricAnnotationInfo<Timed, Timer>(Timed.class, Timed::name, Timed::absolute, Timed::description, Timed::unit, Timed::tags, Timed::scope, MetricRegistry::timer, Timer.class));
    private final Class<A> annotationClass;
    private final Function<A, String> annotationNameFunction;
    private final Function<A, Boolean> annotationAbsoluteFunction;
    private final Function<A, String> annotationDescriptorFunction;
    private final Function<A, String> annotationUnitsFunction;
    private final Function<A, String[]> annotationTagsFunction;
    private final Function<A, String> annotationScopeFunction;
    private final Registration<T> registerFunction;
    private final Class<? extends Metric> metricType;

    MetricAnnotationInfo(Class<A> annotationClass, Function<A, String> annotationNameFunction, Function<A, Boolean> annotationAbsoluteFunction, Function<A, String> annotationDescriptorFunction, Function<A, String> annotationUnitsFunction, Function<A, String[]> annotationTagsFunction, Function<A, String> annotationScopeFunction, Registration<T> registerFunction, Class<? extends Metric> metricType) {
        this.annotationClass = annotationClass;
        this.annotationNameFunction = annotationNameFunction;
        this.annotationAbsoluteFunction = annotationAbsoluteFunction;
        this.annotationDescriptorFunction = annotationDescriptorFunction;
        this.annotationUnitsFunction = annotationUnitsFunction;
        this.annotationTagsFunction = annotationTagsFunction;
        this.annotationScopeFunction = annotationScopeFunction;
        this.registerFunction = registerFunction;
        this.metricType = metricType;
    }

    static Tag[] tags(String[] tagStrings) {
        ArrayList<Tag> result = new ArrayList<Tag>();
        for (String tagString : tagStrings) {
            int eq = tagString.indexOf("=");
            if (eq <= 0) continue;
            String tagName = tagString.substring(0, eq);
            String tagValue = tagString.substring(eq + 1);
            result.add(new Tag(tagName, tagValue));
        }
        return result.toArray(new Tag[0]);
    }

    Class<A> annotationClass() {
        return this.annotationClass;
    }

    A annotationOnMethod(AnnotatedElement ae) {
        return ae.getAnnotation(this.annotationClass);
    }

    String name(Annotation a) {
        return this.annotationNameFunction.apply((Annotation)this.annotationClass.cast(a));
    }

    boolean absolute(Annotation a) {
        return this.annotationAbsoluteFunction.apply((Annotation)this.annotationClass.cast(a));
    }

    String description(Annotation a) {
        return this.annotationDescriptorFunction.apply((Annotation)this.annotationClass.cast(a));
    }

    String unit(Annotation a) {
        return this.annotationUnitsFunction.apply((Annotation)this.annotationClass.cast(a));
    }

    Tag[] tags(Annotation a) {
        return MetricAnnotationInfo.tags(this.annotationTagsFunction.apply((Annotation)this.annotationClass.cast(a)));
    }

    String scope(Annotation a) {
        return this.annotationScopeFunction.apply((Annotation)this.annotationClass.cast(a));
    }

    Class<? extends Metric> metricType() {
        return this.metricType;
    }

    @FunctionalInterface
    static interface Registration<T extends Metric> {
        public T register(MetricRegistry var1, Metadata var2, Tag ... var3);
    }

    static class RegistrationPrep {
        private final String metricName;
        private final Metadata metadata;
        private final Tag[] tags;
        private final Registration<?> registration;
        private final Executable executable;
        private final Class<? extends Annotation> annotationType;
        private final String scope;

        static <A extends Annotation, E extends Member & AnnotatedElement, T extends Metric> RegistrationPrep create(A annotation, E annotatedElement, Class<?> clazz, MetricUtil.MatchingType matchingType, Executable executable) {
            MetricAnnotationInfo<?, ?> info = ANNOTATION_TYPE_TO_INFO.get(annotation.annotationType());
            if (info == null || !info.annotationClass().isInstance(annotation)) {
                return null;
            }
            String metricName = MetricUtil.getMetricName(annotatedElement, clazz, matchingType, info.name(annotation), info.absolute(annotation));
            MetadataBuilder metadataBuilder = Metadata.builder().withName(metricName).withUnit(info.unit(annotation).trim());
            String candidateDescription = info.description(annotation);
            if (candidateDescription != null && !candidateDescription.trim().isEmpty()) {
                metadataBuilder.withDescription(candidateDescription.trim());
            }
            return new RegistrationPrep(metricName, metadataBuilder.build(), info.tags(annotation), info.registerFunction, executable, annotation.annotationType(), info.scope(annotation));
        }

        private RegistrationPrep(String metricName, Metadata metadata, Tag[] tags, Registration<?> registration, Executable executable, Class<? extends Annotation> annotationType, String scope) {
            this.metricName = metricName;
            this.metadata = metadata;
            this.tags = tags;
            this.registration = registration;
            this.executable = executable;
            this.annotationType = annotationType;
            this.scope = scope;
        }

        String metricName() {
            return this.metricName;
        }

        Tag[] tags() {
            return this.tags;
        }

        Executable executable() {
            return this.executable;
        }

        Class<? extends Annotation> annotationType() {
            return this.annotationType;
        }

        Metadata metadata() {
            return this.metadata;
        }

        String scope() {
            return this.scope;
        }

        Metric register(MetricRegistry registry) {
            this.validateMetadata(registry);
            return this.registration.register(registry, this.metadata, this.tags);
        }

        private void validateMetadata(MetricRegistry registry) {
            ArrayList<String> mismatches = new ArrayList<String>();
            Metadata existingMetadata = registry.getMetadata(this.metricName);
            if (existingMetadata == null) {
                return;
            }
            if (!Timed.class.isAssignableFrom(this.annotationType) && !RegistrationPrep.isConsistentWith(this.metadata.getUnit(), existingMetadata.getUnit())) {
                mismatches.add("unit");
            }
            if (!RegistrationPrep.isConsistentWith(this.metadata.getDescription(), existingMetadata.getDescription())) {
                mismatches.add("description");
            }
            if (!mismatches.isEmpty()) {
                throw new IllegalArgumentException(String.format("Attempt to look up or register a metric for annotation %s at %s failed; the metadata implied by the annotation %s does not match the pre-existing metadata %s for %s", this.annotationType.getName(), this.executable.toGenericString(), this.metadata, existingMetadata, mismatches));
            }
        }

        private static boolean isConsistentWith(String s1, String s2) {
            String normalizedS1 = s1 == null || s1.isBlank() || s1.equals("none") ? "" : s1;
            String normalizedS2 = s2 == null || s2.isBlank() || s2.endsWith("none") ? "" : s2;
            return normalizedS2.equals(normalizedS1);
        }
    }
}

