/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.metrics;

import io.helidon.microprofile.metrics.Registry;
import io.helidon.microprofile.metrics.RegistryFactory;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Metric;
import org.eclipse.microprofile.metrics.annotation.Timed;

@ApplicationScoped
class MetricProducer {
    MetricProducer() {
    }

    private static Metadata newMetadata(InjectionPoint ip, Metric metric, Class<? extends org.eclipse.microprofile.metrics.Metric> metricType) {
        return metric == null ? Metadata.builder().withName(MetricProducer.getName(ip)).withDescription("").withUnit(MetricProducer.chooseDefaultUnit(metricType)).build() : Metadata.builder().withName(MetricProducer.getName(metric, ip)).withDescription(metric.description()).withUnit(metric.unit()).build();
    }

    private static String chooseDefaultUnit(Class<? extends org.eclipse.microprofile.metrics.Metric> metricType) {
        return Timer.class.isAssignableFrom(metricType) ? "nanoseconds" : "none";
    }

    private static Tag[] tags(Metric metric) {
        if (metric == null || metric.tags() == null) {
            return null;
        }
        ArrayList<Tag> result = new ArrayList<Tag>();
        for (String tag : metric.tags()) {
            int eq;
            if (tag == null || (eq = tag.indexOf("=")) <= 0) continue;
            result.add(new Tag(tag.substring(0, eq), tag.substring(eq + 1)));
        }
        return result.toArray(new Tag[0]);
    }

    private static String getName(InjectionPoint ip) {
        StringBuilder fullName = new StringBuilder();
        fullName.append(ip.getMember().getDeclaringClass().getName());
        fullName.append('.');
        fullName.append(ip.getMember().getName());
        if (ip.getMember() instanceof Constructor) {
            fullName.append("new");
        }
        return fullName.toString();
    }

    private static String getName(Metric metric, InjectionPoint ip) {
        boolean isAbsolute = metric != null && metric.absolute();
        String prefix = isAbsolute ? "" : ip.getMember().getDeclaringClass().getName() + ".";
        String shortName = metric != null && !metric.name().isEmpty() ? metric.name() : ip.getMember().getName();
        String ctorSuffix = ip.getMember() instanceof Constructor ? ".new" : "";
        String fullName = prefix + shortName + ctorSuffix;
        return fullName;
    }

    @Produces
    private Counter produceCounter(InjectionPoint ip) {
        return this.produceMetric(ip, Counted.class, MetricRegistry::counter, Counter.class);
    }

    @Produces
    private Timer produceTimer(InjectionPoint ip) {
        return this.produceMetric(ip, Timed.class, MetricRegistry::timer, Timer.class);
    }

    @Produces
    private Histogram produceHistogram(InjectionPoint ip) {
        return this.produceMetric(ip, null, MetricRegistry::histogram, Histogram.class);
    }

    @Produces
    private <N extends Number> Gauge<N> produceGauge(InjectionPoint ip) {
        MetricLocator locator = MetricLocator.create(ip);
        Gauge result = locator.registry.getGauge(locator.metricId);
        if (result == null) {
            throw new IllegalArgumentException("Could not produce Gauge for injection point " + ip.toString());
        }
        return result;
    }

    private <T extends org.eclipse.microprofile.metrics.Metric, U extends Annotation> T produceMetric(InjectionPoint ip, Class<U> annotationClass, RegisterFunction<T> registerFn, Class<T> clazz) {
        MetricLocator locator = MetricLocator.create(ip);
        T result = locator.registry.getMetric(locator.metricId, clazz);
        if (result != null) {
            Annotation specificMetricAnno;
            Annotation annotation = specificMetricAnno = annotationClass == null ? null : ip.getAnnotated().getAnnotation(annotationClass);
            if (specificMetricAnno == null) {
                return result;
            }
        } else {
            Metadata newMetadata = MetricProducer.newMetadata(ip, locator.metricAnno, clazz);
            result = registerFn.apply(locator.registry, newMetadata, locator.metricId.getTagsAsArray());
        }
        return result;
    }

    private static Iterable<String> iterable(final String value) {
        return () -> new Iterator<String>(){
            private boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.hasNext = false;
                return value;
            }
        };
    }

    @FunctionalInterface
    private static interface RegisterFunction<T extends org.eclipse.microprofile.metrics.Metric> {
        public T apply(MetricRegistry var1, Metadata var2, Tag[] var3);
    }

    record MetricLocator(Metric metricAnno, Registry registry, MetricID metricId) {
        static MetricLocator create(InjectionPoint ip) {
            Metric metricAnno = (Metric)ip.getAnnotated().getAnnotation(Metric.class);
            Tag[] tags = MetricProducer.tags(metricAnno);
            String scope = metricAnno == null ? "application" : metricAnno.scope();
            Registry registry = RegistryFactory.getInstance().registry(scope);
            MetricID metricID = new MetricID(MetricProducer.getName(metricAnno, ip), tags);
            return new MetricLocator(metricAnno, registry, metricID);
        }
    }
}

