/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.metrics;

import io.helidon.common.Errors;
import io.helidon.metrics.api.Counter;
import io.helidon.metrics.api.DistributionSummary;
import io.helidon.metrics.api.FunctionalCounter;
import io.helidon.metrics.api.Gauge;
import io.helidon.metrics.api.Meter;
import io.helidon.metrics.api.MeterRegistry;
import io.helidon.metrics.api.SystemTagsManager;
import io.helidon.metrics.api.Tag;
import io.helidon.metrics.api.Timer;
import io.helidon.microprofile.metrics.HelidonCounter;
import io.helidon.microprofile.metrics.HelidonGauge;
import io.helidon.microprofile.metrics.HelidonHistogram;
import io.helidon.microprofile.metrics.HelidonMetric;
import io.helidon.microprofile.metrics.HelidonTimer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetadataBuilder;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricFilter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Timer;

class Registry
implements MetricRegistry {
    private static final System.Logger LOGGER = System.getLogger(Registry.class.getName());
    private static final org.eclipse.microprofile.metrics.Tag[] NO_TAGS = new org.eclipse.microprofile.metrics.Tag[0];
    private final MeterRegistry meterRegistry;
    private final String scope;
    private final ReentrantLock lock = new ReentrantLock();
    private final Map<MetricID, HelidonMetric<?>> metricsById = new HashMap();
    private final Map<Meter, HelidonMetric<?>> metricsByDelegate = new HashMap();
    private final Map<String, InfoPerName> infoByName = new HashMap<String, InfoPerName>();

    private Registry(String scope, MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
        this.scope = scope;
    }

    static Registry create(String scope, MeterRegistry meterRegistry) {
        return new Registry(scope, meterRegistry);
    }

    protected static String sanitizeUnit(String unit) {
        return unit != null && !unit.equals("none") ? unit : null;
    }

    protected static Iterable<Tag> validatedAllTags(String scope, org.eclipse.microprofile.metrics.Tag[] tags) {
        if (tags != null && tags.length > 0) {
            List<String> tagNames = Arrays.stream(tags).map(org.eclipse.microprofile.metrics.Tag::getTagName).toList();
            Collection reservedTagNamesUsed = SystemTagsManager.instance().reservedTagNamesUsed(tagNames);
            if (!reservedTagNamesUsed.isEmpty()) {
                throw new IllegalArgumentException("Illegal use of reserved tag name(s): " + String.valueOf(reservedTagNamesUsed));
            }
        }
        return Registry.toHelidonTags(SystemTagsManager.instance().withScopeTag(Registry.iterableEntries(tags), scope));
    }

    public org.eclipse.microprofile.metrics.Counter counter(String name) {
        return this.counter(name, NO_TAGS);
    }

    public org.eclipse.microprofile.metrics.Counter counter(String name, org.eclipse.microprofile.metrics.Tag ... tags) {
        return Objects.requireNonNullElseGet(this.getCounter(new MetricID(name, tags)), () -> this.createCounter(Registry.metadata(name), tags));
    }

    public org.eclipse.microprofile.metrics.Counter counter(MetricID metricID) {
        return Objects.requireNonNullElseGet(this.getCounter(metricID), () -> this.createCounter(Registry.metadata(metricID), metricID.getTagsAsArray()));
    }

    public org.eclipse.microprofile.metrics.Counter counter(Metadata metadata) {
        return this.counter(metadata, NO_TAGS);
    }

    public org.eclipse.microprofile.metrics.Counter counter(Metadata metadata, org.eclipse.microprofile.metrics.Tag ... tags) {
        return Objects.requireNonNullElseGet(this.getCounter(Registry.metricID(metadata, tags)), () -> this.createCounter(metadata, tags));
    }

    public <T, R extends Number> org.eclipse.microprofile.metrics.Gauge<R> gauge(String name, T object, Function<T, R> func, org.eclipse.microprofile.metrics.Tag ... tags) {
        return Objects.requireNonNullElseGet(this.getGauge(new MetricID(name, tags)), () -> this.createGauge(Registry.metadata(name), object, func, tags));
    }

    public <T, R extends Number> org.eclipse.microprofile.metrics.Gauge<R> gauge(MetricID metricID, T object, Function<T, R> func) {
        return Objects.requireNonNullElseGet(this.getGauge(metricID), () -> this.createGauge(Registry.metadata(metricID), object, func, metricID.getTagsAsArray()));
    }

    public <T, R extends Number> org.eclipse.microprofile.metrics.Gauge<R> gauge(Metadata metadata, T object, Function<T, R> func, org.eclipse.microprofile.metrics.Tag ... tags) {
        return Objects.requireNonNullElseGet(this.getGauge(Registry.metricID(metadata, tags)), () -> this.createGauge(metadata, object, func, tags));
    }

    public <T extends Number> org.eclipse.microprofile.metrics.Gauge<T> gauge(String name, Supplier<T> supplier, org.eclipse.microprofile.metrics.Tag ... tags) {
        return Objects.requireNonNullElseGet(this.getGauge(new MetricID(name, tags)), () -> this.createGauge(Registry.metadata(name), supplier, tags));
    }

    public <T extends Number> org.eclipse.microprofile.metrics.Gauge<T> gauge(MetricID metricID, Supplier<T> supplier) {
        return Objects.requireNonNullElseGet(this.getGauge(metricID), () -> this.createGauge(Registry.metadata(metricID), supplier, metricID.getTagsAsArray()));
    }

    public <T extends Number> org.eclipse.microprofile.metrics.Gauge<T> gauge(Metadata metadata, Supplier<T> supplier, org.eclipse.microprofile.metrics.Tag ... tags) {
        return Objects.requireNonNullElseGet(this.getGauge(Registry.metricID(metadata, tags)), () -> this.createGauge(metadata, supplier, tags));
    }

    public Histogram histogram(String name) {
        return this.histogram(Registry.metadata(name), NO_TAGS);
    }

    public Histogram histogram(String name, org.eclipse.microprofile.metrics.Tag ... tags) {
        return Objects.requireNonNullElseGet(this.getHistogram(new MetricID(name, tags)), () -> this.createHistogram(Registry.metadata(name), tags));
    }

    public Histogram histogram(MetricID metricID) {
        return Objects.requireNonNullElseGet(this.getHistogram(metricID), () -> this.createHistogram(Registry.metadata(metricID), metricID.getTagsAsArray()));
    }

    public Histogram histogram(Metadata metadata) {
        return this.histogram(metadata, NO_TAGS);
    }

    public Histogram histogram(Metadata metadata, org.eclipse.microprofile.metrics.Tag ... tags) {
        return Objects.requireNonNullElseGet(this.getHistogram(Registry.metricID(metadata, tags)), () -> this.createHistogram(metadata, tags));
    }

    public Timer timer(String name) {
        return Objects.requireNonNullElseGet(this.getTimer(new MetricID(name)), () -> this.createTimer(Registry.metadata(name), NO_TAGS));
    }

    public Timer timer(String name, org.eclipse.microprofile.metrics.Tag ... tags) {
        return Objects.requireNonNullElseGet(this.getTimer(new MetricID(name, tags)), () -> this.createTimer(Registry.metadata(name), tags));
    }

    public Timer timer(MetricID metricID) {
        return Objects.requireNonNullElseGet(this.getTimer(metricID), () -> this.createTimer(Registry.metadata(metricID), metricID.getTagsAsArray()));
    }

    public Timer timer(Metadata metadata) {
        return Objects.requireNonNullElseGet(this.getTimer(Registry.metricID(metadata, new org.eclipse.microprofile.metrics.Tag[0])), () -> this.createTimer(metadata, NO_TAGS));
    }

    public Timer timer(Metadata metadata, org.eclipse.microprofile.metrics.Tag ... tags) {
        return Objects.requireNonNullElseGet(this.getTimer(Registry.metricID(metadata, tags)), () -> this.createTimer(metadata, tags));
    }

    public Metric getMetric(MetricID metricID) {
        return this.metricsById.get(metricID);
    }

    public <T extends Metric> T getMetric(MetricID metricID, Class<T> asType) {
        return (T)((Metric)asType.cast(this.getMetric(metricID)));
    }

    public org.eclipse.microprofile.metrics.Counter getCounter(MetricID metricID) {
        return this.getMetric(metricID, org.eclipse.microprofile.metrics.Counter.class);
    }

    public org.eclipse.microprofile.metrics.Gauge getGauge(MetricID metricID) {
        return this.getMetric(metricID, org.eclipse.microprofile.metrics.Gauge.class);
    }

    public Histogram getHistogram(MetricID metricID) {
        return this.getMetric(metricID, Histogram.class);
    }

    public Timer getTimer(MetricID metricID) {
        return this.getMetric(metricID, Timer.class);
    }

    public Metadata getMetadata(String name) {
        InfoPerName info = this.infoByName.get(name);
        return info == null ? null : info.metadata;
    }

    public boolean remove(String name) {
        this.lock.lock();
        try {
            boolean bl = this.removeMatchingWithResult((id, metric) -> id.getName().equals(name));
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean remove(MetricID metricID) {
        this.lock.lock();
        try {
            boolean bl = this.removeViaDelegate(metricID);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeMatching(MetricFilter filter) {
        this.removeMatchingWithResult(filter);
    }

    public SortedSet<String> getNames() {
        return new TreeSet<String>(this.infoByName.keySet());
    }

    public SortedSet<MetricID> getMetricIDs() {
        return new TreeSet<MetricID>(this.metricsById.keySet());
    }

    public SortedMap<MetricID, org.eclipse.microprofile.metrics.Gauge> getGauges() {
        return this.getMetrics(org.eclipse.microprofile.metrics.Gauge.class, MetricFilter.ALL);
    }

    public SortedMap<MetricID, org.eclipse.microprofile.metrics.Gauge> getGauges(MetricFilter filter) {
        return this.getMetrics(org.eclipse.microprofile.metrics.Gauge.class, filter);
    }

    public SortedMap<MetricID, org.eclipse.microprofile.metrics.Counter> getCounters() {
        return this.getMetrics(org.eclipse.microprofile.metrics.Counter.class, MetricFilter.ALL);
    }

    public SortedMap<MetricID, org.eclipse.microprofile.metrics.Counter> getCounters(MetricFilter filter) {
        return this.getMetrics(org.eclipse.microprofile.metrics.Counter.class, filter);
    }

    public SortedMap<MetricID, Histogram> getHistograms() {
        return this.getMetrics(Histogram.class, MetricFilter.ALL);
    }

    public SortedMap<MetricID, Histogram> getHistograms(MetricFilter filter) {
        return this.getMetrics(Histogram.class, filter);
    }

    public SortedMap<MetricID, Timer> getTimers() {
        return this.getMetrics(Timer.class, MetricFilter.ALL);
    }

    public SortedMap<MetricID, Timer> getTimers(MetricFilter filter) {
        return this.getMetrics(Timer.class, filter);
    }

    public SortedMap<MetricID, Metric> getMetrics(MetricFilter filter) {
        this.lock.lock();
        try {
            SortedMap sortedMap = this.metricsById.entrySet().stream().filter(entry -> filter.matches((MetricID)entry.getKey(), (Metric)entry.getValue())).collect(TreeMap::new, (map, entry) -> map.put((MetricID)entry.getKey(), (Metric)entry.getValue()), TreeMap::putAll);
            return sortedMap;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Metric> SortedMap<MetricID, T> getMetrics(Class<T> ofType, MetricFilter filter) {
        this.lock.lock();
        try {
            SortedMap sortedMap = this.metricsById.entrySet().stream().filter(entry -> ofType.isInstance(entry.getValue())).filter(entry -> filter.matches((MetricID)entry.getKey(), (Metric)entry.getValue())).collect(TreeMap::new, (map, entry) -> map.put((MetricID)entry.getKey(), (Metric)entry.getValue()), TreeMap::putAll);
            return sortedMap;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Map<MetricID, Metric> getMetrics() {
        return this.access(() -> Map.copyOf(this.metricsById));
    }

    public Map<String, Metadata> getMetadata() {
        return this.access(() -> {
            HashMap result = new HashMap();
            this.infoByName.forEach((key, value) -> result.put(key, value.metadata()));
            return result;
        });
    }

    public String getScope() {
        return this.scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HelidonMetric<?> onMeterAdded(Meter meter) {
        String name = meter.id().name();
        Errors.Collector collector = Errors.collector();
        MetricID newMetricID = this.metricIDWithoutSystemTags(collector, meter.id());
        this.lock.lock();
        try {
            HelidonMetric<?> existingMetric;
            InfoPerName existingInfo = this.infoByName.get(name);
            if (existingInfo != null) {
                existingInfo.validate(collector, newMetricID, meter);
            }
            if ((existingMetric = this.metricsById.get(newMetricID)) != null) {
                collector.warn(String.format("unexpected attempted re-registration of metric %s by meter %s", newMetricID, meter));
                Registry.validateMetric(collector, newMetricID, existingMetric, meter);
            }
            if (collector.hasFatal()) {
                throw new IllegalArgumentException("Attempt to register a meter incompatible with previously-registered metrics: " + String.valueOf(collector.collect()));
            }
            Metadata newMetadata = existingInfo == null ? Registry.metadata(meter) : null;
            HelidonMetric<?> newMetric = this.metric(collector, existingInfo == null ? newMetadata : existingInfo.metadata, meter);
            InfoPerName info = this.infoByName.computeIfAbsent(newMetricID.getName(), n -> InfoPerName.create(newMetadata, newMetricID));
            info.add(newMetricID);
            this.metricsById.put(newMetricID, newMetric);
            this.metricsByDelegate.put(meter, newMetric);
            collector.collect().log(LOGGER);
            HelidonMetric<?> helidonMetric = newMetric;
            return helidonMetric;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onMeterRemoved(Meter meter) {
        Errors.Collector collector = Errors.collector();
        HelidonMetric<?> metric = this.metricsByDelegate.get(meter);
        if (metric == null) {
            collector.warn((Object)meter, "Unable to find corresponding metric to remove upon removal of meter");
        } else {
            this.lock.lock();
            try {
                metric.markAsDeleted();
                String metricName = meter.id().name();
                MetricID metricID = this.metricIDWithoutSystemTags(collector, meter.id());
                InfoPerName info = this.infoByName.get(metricName);
                if (info == null) {
                    collector.warn(String.format("Unable to locate info for name %s", metricName));
                } else {
                    info.remove(metricID);
                    if (info.metricIDs.isEmpty()) {
                        this.infoByName.remove(metricName);
                    }
                }
                if (this.metricsById.remove(metricID) == null) {
                    collector.warn("could not find metric by ID " + String.valueOf(metricID));
                }
                if (this.metricsByDelegate.remove(meter) == null) {
                    collector.warn("could not find metric by meter");
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    void onMeterBuilderProvided(Meter.Builder<?, ?> meterBuilder) {
        if (meterBuilder instanceof Counter.Builder) {
            Counter.Builder cBuilder = (Counter.Builder)meterBuilder;
            this.createCounter(cBuilder);
        } else if (meterBuilder instanceof DistributionSummary.Builder) {
            DistributionSummary.Builder sBuilder = (DistributionSummary.Builder)meterBuilder;
            this.createHistogram(sBuilder);
        } else if (meterBuilder instanceof FunctionalCounter.Builder) {
            FunctionalCounter.Builder fcBuilder = (FunctionalCounter.Builder)meterBuilder;
            this.createFunctionalCounter(fcBuilder);
        } else if (meterBuilder instanceof Gauge.Builder) {
            Gauge.Builder gBuilder = (Gauge.Builder)meterBuilder;
            this.createGauge(gBuilder);
        } else if (meterBuilder instanceof Timer.Builder) {
            Timer.Builder tBuilder = (Timer.Builder)meterBuilder;
            this.createTimer(tBuilder);
        } else {
            LOGGER.log(System.Logger.Level.WARNING, "Unrecognized builder type; ignoring " + meterBuilder.getClass().getName());
        }
    }

    void clear() {
        this.lock.lock();
        try {
            this.infoByName.clear();
            this.metricsByDelegate.clear();
            this.metricsById.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    private static Iterable<Tag> toHelidonTags(Iterable<Map.Entry<String, String>> entriesIterable) {
        ArrayList<Tag> result = new ArrayList<Tag>();
        entriesIterable.forEach(entry -> result.add(Tag.create((String)((String)entry.getKey()), (String)((String)entry.getValue()))));
        return result;
    }

    private static Iterable<Map.Entry<String, String>> iterableEntries(org.eclipse.microprofile.metrics.Tag ... tags) {
        if (tags == null) {
            return Set.of();
        }
        ArrayList<Map.Entry<String, String>> result = new ArrayList<Map.Entry<String, String>>();
        for (org.eclipse.microprofile.metrics.Tag tag : tags) {
            result.add(new AbstractMap.SimpleEntry<String, String>(tag.getTagName(), tag.getTagValue()));
        }
        return result;
    }

    private static MetricID metricID(Metadata metadata, org.eclipse.microprofile.metrics.Tag ... tags) {
        return new MetricID(metadata.getName(), tags);
    }

    private static Metadata metadata(String name) {
        return Metadata.builder().withName(name).build();
    }

    private static Metadata metadata(MetricID metricId) {
        return Registry.metadata(metricId.getName());
    }

    private static void validateMetric(Errors.Collector collector, MetricID metricID, HelidonMetric<?> existingMetric, Meter meter) {
        if (meter instanceof FunctionalCounter && Gauge.class.isAssignableFrom(existingMetric.delegateType())) {
            return;
        }
        if (!existingMetric.delegateType().isInstance(meter)) {
            collector.fatal(String.format("existing metric %s is compatible with type %s but new meter is %s", metricID, existingMetric.delegateType(), meter.getClass().getName()));
        }
    }

    private static Metadata metadata(Meter meter) {
        MetadataBuilder builder = Metadata.builder().withName(meter.id().name());
        meter.baseUnit().ifPresent(arg_0 -> ((MetadataBuilder)builder).withUnit(arg_0));
        meter.description().ifPresent(arg_0 -> ((MetadataBuilder)builder).withDescription(arg_0));
        return builder.build();
    }

    private static Map<String, String> tagsWithoutSystemOrScopeTags(Iterable<Tag> tags) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        SystemTagsManager.instance().withoutSystemOrScopeTags(tags).forEach(t -> result.put(t.key(), t.value()));
        return result;
    }

    private static org.eclipse.microprofile.metrics.Tag[] tags(Map<String, String> tags) {
        ArrayList result = new ArrayList();
        tags.forEach((key, value) -> result.add(new org.eclipse.microprofile.metrics.Tag(key, value)));
        return result.toArray(new org.eclipse.microprofile.metrics.Tag[0]);
    }

    private HelidonCounter createCounter(Metadata metadata, org.eclipse.microprofile.metrics.Tag ... tags) {
        return this.createCounter((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.builder((String)metadata.getName()).scope(this.scope)).description(metadata.getDescription())).baseUnit(Registry.sanitizeUnit(metadata.getUnit()))).tags(Registry.validatedAllTags(this.scope, tags)));
    }

    private HelidonCounter createCounter(Counter.Builder counterBuilder) {
        Counter delegate = (Counter)this.meterRegistry.getOrCreate((Meter.Builder)counterBuilder);
        HelidonCounter result = (HelidonCounter)this.metricsByDelegate.get(delegate);
        return result;
    }

    private <N extends Number, T> HelidonGauge<N> createGauge(Metadata metadata, T object, Function<T, N> func, org.eclipse.microprofile.metrics.Tag ... tags) {
        return this.createGauge((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.builder((String)metadata.getName(), () -> (Number)func.apply(object)).scope(this.scope)).description(metadata.getDescription())).tags(Registry.validatedAllTags(this.scope, tags))).baseUnit(Registry.sanitizeUnit(metadata.getUnit())));
    }

    private <N extends Number> HelidonGauge<N> createGauge(Metadata metadata, Supplier<N> supplier, org.eclipse.microprofile.metrics.Tag ... tags) {
        return this.createGauge((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.builder((String)metadata.getName(), supplier).scope(this.scope)).description(metadata.getDescription())).tags(Registry.validatedAllTags(this.scope, tags))).baseUnit(Registry.sanitizeUnit(metadata.getUnit())));
    }

    private <N extends Number> HelidonGauge<N> createGauge(Gauge.Builder<N> gBuilder) {
        Gauge delegate = (Gauge)this.meterRegistry.getOrCreate(gBuilder);
        return (HelidonGauge)this.metricsByDelegate.get(delegate);
    }

    private <T> HelidonGauge<Long> createFunctionalCounter(FunctionalCounter.Builder<T> fcBuilder) {
        Gauge delegate = (Gauge)this.meterRegistry.getOrCreate((Meter.Builder)Gauge.builder((String)fcBuilder.name(), () -> (Long)fcBuilder.fn().apply(fcBuilder.stateObject())));
        return (HelidonGauge)this.metricsByDelegate.get(delegate);
    }

    private HelidonHistogram createHistogram(Metadata metadata, org.eclipse.microprofile.metrics.Tag ... tags) {
        return this.createHistogram((DistributionSummary.Builder)((DistributionSummary.Builder)((DistributionSummary.Builder)((DistributionSummary.Builder)DistributionSummary.builder((String)metadata.getName()).scope(this.scope)).description(metadata.getDescription())).baseUnit(Registry.sanitizeUnit(metadata.getUnit()))).tags(Registry.validatedAllTags(this.scope, tags)));
    }

    private HelidonHistogram createHistogram(DistributionSummary.Builder sBuilder) {
        DistributionSummary delegate = (DistributionSummary)this.meterRegistry.getOrCreate((Meter.Builder)sBuilder);
        return (HelidonHistogram)this.metricsByDelegate.get(delegate);
    }

    private HelidonTimer createTimer(Metadata metadata, org.eclipse.microprofile.metrics.Tag ... tags) {
        return this.createTimer((Timer.Builder)((Timer.Builder)((Timer.Builder)((Timer.Builder)io.helidon.metrics.api.Timer.builder((String)metadata.getName()).scope(this.scope)).description(metadata.getDescription())).baseUnit(Registry.sanitizeUnit(metadata.getUnit()))).tags(Registry.validatedAllTags(this.scope, tags)));
    }

    private HelidonTimer createTimer(Timer.Builder tBuilder) {
        io.helidon.metrics.api.Timer delegate = (io.helidon.metrics.api.Timer)this.meterRegistry.getOrCreate((Meter.Builder)tBuilder);
        return (HelidonTimer)this.metricsByDelegate.get(delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeMatchingWithResult(MetricFilter filter) {
        boolean result = false;
        this.lock.lock();
        try {
            for (Map.Entry<MetricID, Metric> entry : this.getMetrics(filter).entrySet()) {
                result |= this.remove(entry.getKey());
            }
            boolean bl = result;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeViaDelegate(MetricID metricId) {
        this.lock.lock();
        try {
            HelidonMetric<?> helidonMetric = this.metricsById.get(metricId);
            boolean bl = helidonMetric != null && helidonMetric.removeViaDelegate(this.meterRegistry);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private HelidonMetric<?> metric(Errors.Collector collector, Metadata metadata, Meter meter) {
        if (meter instanceof Counter) {
            Counter counter = (Counter)meter;
            return HelidonCounter.create(this.scope, metadata, counter);
        }
        if (meter instanceof DistributionSummary) {
            DistributionSummary summary = (DistributionSummary)meter;
            return HelidonHistogram.create(this.scope, metadata, summary);
        }
        if (meter instanceof FunctionalCounter) {
            FunctionalCounter fCounter = (FunctionalCounter)meter;
            return HelidonGauge.create(this.scope, metadata, fCounter);
        }
        if (meter instanceof Gauge) {
            Gauge gauge = (Gauge)meter;
            return HelidonGauge.create(this.scope, metadata, gauge);
        }
        if (meter instanceof io.helidon.metrics.api.Timer) {
            io.helidon.metrics.api.Timer timer = (io.helidon.metrics.api.Timer)meter;
            return HelidonTimer.create(this.meterRegistry, this.scope, metadata, timer);
        }
        collector.warn(String.format("Unrecognized type for new meter %s; unable to create MP metric for it", meter));
        return null;
    }

    private MetricID metricIDWithoutSystemTags(Errors.Collector collector, Meter.Id meterId) {
        Map<String, String> tagsWithoutScope = Registry.tagsWithoutSystemOrScopeTags(meterId.tags());
        Collection reservedTagNamesUsed = SystemTagsManager.instance().reservedTagNamesUsed(tagsWithoutScope.keySet());
        if (!reservedTagNamesUsed.isEmpty()) {
            collector.fatal((Object)reservedTagNamesUsed, "illegal use of reserved tag names");
        }
        return new MetricID(meterId.name(), Registry.tags(tagsWithoutScope));
    }

    private <T> T access(Callable<T> callable) {
        this.lock.lock();
        try {
            T t = callable.call();
            return t;
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception during locked data access", ex);
        }
        finally {
            this.lock.unlock();
        }
    }

    static class InfoPerName {
        private final Metadata metadata;
        private final Set<MetricID> metricIDs = new HashSet<MetricID>();
        private final Set<String> tagNames = new HashSet<String>();

        private InfoPerName(Metadata metadata, MetricID metricID) {
            this.metadata = metadata;
            this.tagNames.addAll(metricID.getTags().keySet());
        }

        static InfoPerName create(Metadata metadata, MetricID metricID) {
            return new InfoPerName(metadata, metricID);
        }

        void add(MetricID metricID) {
            this.metricIDs.add(metricID);
        }

        boolean remove(MetricID metricID) {
            this.metricIDs.remove(metricID);
            return this.metricIDs.isEmpty();
        }

        Metadata metadata() {
            return this.metadata;
        }

        void validate(Errors.Collector collector, MetricID metricID, Meter meter) {
            this.validateMetadata(collector, this.metadata, meter);
            this.validateTagNames(collector, metricID);
        }

        private void validateMetadata(Errors.Collector collector, Metadata existingMetadata, Meter meter) {
            meter.description().filter(Predicate.not(String::isBlank)).filter(d -> !d.equals(existingMetadata.description().orElse(d))).ifPresent(d -> collector.fatal(String.format("metadata description: old='%s', proposed='%s'", existingMetadata.getDescription(), d)));
            meter.baseUnit().filter(Predicate.not(String::isBlank)).filter(u -> !u.equals(existingMetadata.unit().orElse(u))).ifPresent(u -> collector.fatal(String.format("metadataunit: old='%s', proposed='%s'", existingMetadata.getUnit(), u)));
        }

        private void validateTagNames(Errors.Collector collector, MetricID metricID) {
            Set newTagNames = metricID.getTags().keySet();
            if (!this.tagNames.equals(newTagNames)) {
                collector.fatal(String.format("new tag names %s are inconsistent with existing tag names %s", metricID.getTags().keySet(), this.tagNames));
            }
        }
    }
}

