/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.metrics;

import io.helidon.microprofile.metrics.RegistryFactory;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.InjectionPoint;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.annotation.RegistryScope;
import org.eclipse.microprofile.metrics.annotation.RegistryType;

@ApplicationScoped
final class RegistryProducer {
    private RegistryProducer() {
    }

    @Produces
    @Default
    public static MetricRegistry getScopedRegistry(InjectionPoint injectionPoint) {
        Annotated annotated = injectionPoint == null ? null : injectionPoint.getAnnotated();
        RegistryScope scope = annotated == null ? null : (RegistryScope)annotated.getAnnotation(RegistryScope.class);
        return scope == null ? RegistryProducer.getApplicationRegistry() : RegistryFactory.getInstance().getRegistry(scope.scope());
    }

    public static MetricRegistry getDefaultRegistry() {
        return RegistryProducer.getApplicationRegistry();
    }

    @Produces
    @RegistryType(type=MetricRegistry.Type.APPLICATION)
    public static MetricRegistry getApplicationRegistry() {
        return RegistryFactory.getInstance().getRegistry("application");
    }

    @Produces
    @RegistryType(type=MetricRegistry.Type.BASE)
    public static MetricRegistry getBaseRegistry() {
        return RegistryFactory.getInstance().getRegistry("base");
    }

    @Produces
    @RegistryType(type=MetricRegistry.Type.VENDOR)
    public static MetricRegistry getVendorRegistry() {
        return RegistryFactory.getInstance().getRegistry("vendor");
    }

    @Produces
    public static RegistryFactory getRegistryFactory() {
        return RegistryFactory.getInstance();
    }

    static void clearApplicationRegistry() {
        MetricRegistry applicationRegistry = RegistryProducer.getApplicationRegistry();
        applicationRegistry.getNames().forEach(arg_0 -> ((MetricRegistry)applicationRegistry).remove(arg_0));
    }
}

