/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.server;

import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.config.Config;
import io.helidon.config.metadata.Configured;
import io.helidon.config.metadata.ConfiguredOption;
import io.helidon.config.mp.MpConfigSources;
import io.helidon.microprofile.cdi.HelidonContainer;
import io.helidon.microprofile.server.JaxRsApplication;
import io.helidon.microprofile.server.JaxRsCdiExtension;
import io.helidon.microprofile.server.ServerCdiExtension;
import io.helidon.microprofile.server.ServerImpl;
import jakarta.enterprise.inject.se.SeContainer;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.ws.rs.core.Application;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.glassfish.jersey.server.ResourceConfig;

public interface Server {
    @SafeVarargs
    public static Server create(Application ... applications) {
        Builder builder = Server.builder();
        Arrays.stream(applications).forEach(builder::addApplication);
        return builder.build();
    }

    @SafeVarargs
    public static Server create(Class<? extends Application> ... applicationClasses) {
        Builder builder = Server.builder();
        Arrays.stream(applicationClasses).forEach(builder::addApplication);
        return builder.build();
    }

    public static Server create() {
        return Server.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Server start();

    public Server stop();

    public String host();

    public int port();

    @Configured(prefix="server", description="Configuration of Helidon Microprofile Server", root=true)
    public static final class Builder
    implements io.helidon.common.Builder<Builder, Server> {
        private static final System.Logger STARTUP_LOGGER = System.getLogger("io.helidon.microprofile.startup.builder");
        private final List<Class<?>> resourceClasses = new LinkedList();
        private final List<JaxRsApplication> applications = new LinkedList<JaxRsApplication>();
        private org.eclipse.microprofile.config.Config config;
        private String host;
        private String basePath;
        private int port = -1;
        private JaxRsCdiExtension jaxRs;
        private boolean retainDiscovered = false;

        private Builder() {
            ServerCdiExtension server = null;
            try {
                server = (ServerCdiExtension)CDI.current().getBeanManager().getExtension(ServerCdiExtension.class);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (null != server && server.started()) {
                throw new IllegalStateException("Server is already started. Maybe you have initialized CDI yourself? If you do so, then you cannot use Server.builder() to set up your server. Config is initialized with defaults or using meta-config.yaml; applications are discovered using CDI. To use custom configuration, you can use ConfigProviderResolver.instance().registerConfig(config, classLoader);");
            }
        }

        public Server build() {
            STARTUP_LOGGER.log(System.Logger.Level.TRACE, Builder.class.getName() + " build ENTRY");
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (null == this.config) {
                this.config = ConfigProviderResolver.instance().getConfig(classLoader);
            }
            ConfigProviderResolver.instance().registerConfig(this.config, classLoader);
            HelidonContainer instance = HelidonContainer.instance();
            try {
                return (Server)Contexts.runInContext((Context)instance.context(), this::doBuild);
            }
            catch (Exception e) {
                try {
                    ((SeContainer)CDI.current()).close();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                throw e;
            }
        }

        private Server doBuild() {
            ServerCdiExtension server = (ServerCdiExtension)CDI.current().getBeanManager().getExtension(ServerCdiExtension.class);
            if (null != this.basePath) {
                server.basePath(this.basePath);
            }
            STARTUP_LOGGER.log(System.Logger.Level.TRACE, "Configuration obtained");
            this.jaxRs = (JaxRsCdiExtension)CDI.current().getBeanManager().getExtension(JaxRsCdiExtension.class);
            if (!(this.applications.isEmpty() && this.resourceClasses.isEmpty() || this.retainDiscovered)) {
                this.jaxRs.removeApplications();
            }
            if (!this.resourceClasses.isEmpty()) {
                this.jaxRs.removeResourceClasses();
                this.jaxRs.addResourceClasses(this.resourceClasses);
            }
            this.jaxRs.addApplications(this.applications);
            if (!this.resourceClasses.isEmpty()) {
                this.jaxRs.addSyntheticApplication(this.resourceClasses);
            }
            STARTUP_LOGGER.log(System.Logger.Level.TRACE, "Jersey resource configuration");
            if (null == this.host) {
                this.host = this.config.getOptionalValue("server.host", String.class).orElse("0.0.0.0");
            }
            if (this.port == -1) {
                this.port = this.config.getOptionalValue("server.port", Integer.class).orElse(7001);
            }
            return new ServerImpl(this);
        }

        @ConfiguredOption
        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder basePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        @ConfiguredOption
        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder config(Config config) {
            this.config = ConfigProviderResolver.instance().getBuilder().withSources(new ConfigSource[]{MpConfigSources.create((Config)Objects.requireNonNull(config, "Config cannot be null"))}).build();
            return this;
        }

        public Builder config(org.eclipse.microprofile.config.Config config) {
            this.config = config;
            return this;
        }

        public Builder resourceConfig(ResourceConfig config) {
            Application application = config.getApplication();
            JaxRsApplication.Builder builder = JaxRsApplication.builder().appName(config.getApplicationName()).config(config);
            if (null != application) {
                builder.applicationClass(application.getClass());
            }
            this.applications.add(builder.build());
            return this;
        }

        public Builder addApplication(JaxRsApplication application) {
            this.applications.add(application);
            return this;
        }

        public Builder addApplication(Application application) {
            this.applications.add(JaxRsApplication.create(application));
            return this;
        }

        public Builder retainDiscoveredApplications(boolean retain) {
            this.retainDiscovered = retain;
            return this;
        }

        public Builder applications(Application ... applications) {
            this.applications.clear();
            for (Application application : applications) {
                this.addApplication(application);
            }
            return this;
        }

        public Builder addApplication(String contextRoot, Application application) {
            this.applications.add(JaxRsApplication.builder().application(application).contextRoot(contextRoot).build());
            return this;
        }

        public Builder addApplication(Class<? extends Application> applicationClass) {
            this.applications.add(JaxRsApplication.create(applicationClass));
            return this;
        }

        public Builder addApplication(String contextRoot, Class<? extends Application> applicationClass) {
            this.applications.add(JaxRsApplication.builder().application(applicationClass).contextRoot(contextRoot).build());
            return this;
        }

        public Builder addResourceClass(Class<?> resource) {
            this.resourceClasses.add(resource);
            return this;
        }

        String host() {
            return this.host;
        }

        int port() {
            return this.port;
        }
    }
}

