/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.webserver.spi.ProtocolConfig;
import java.util.List;
import java.util.Objects;

public class ProtocolConfigs {
    private final List<ProtocolConfig> protocolConfigs;

    private ProtocolConfigs(List<ProtocolConfig> protocolConfigs) {
        this.protocolConfigs = List.copyOf(protocolConfigs);
    }

    public static ProtocolConfigs create(List<ProtocolConfig> protocolConfigs) {
        Objects.requireNonNull(protocolConfigs);
        return new ProtocolConfigs(protocolConfigs);
    }

    public <T extends ProtocolConfig> List<T> config(String protocolType, Class<T> protocolConfigType) {
        Objects.requireNonNull(protocolType);
        Objects.requireNonNull(protocolConfigType);
        return this.protocolConfigs.stream().filter(it -> protocolType.equals(it.type())).filter(it -> protocolConfigType.isAssignableFrom(it.getClass())).map(protocolConfigType::cast).toList();
    }
}

