/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

public interface ProxyProtocolData {
    public Family family();

    public Protocol protocol();

    public String sourceAddress();

    public String destAddress();

    public int sourcePort();

    public int destPort();

    public static enum Protocol {
        UNKNOWN,
        TCP,
        UDP;


        static Protocol fromString(String s) {
            return switch (s) {
                case "TCP4", "TCP6" -> TCP;
                case "UDP" -> UDP;
                case "UNKNOWN" -> UNKNOWN;
                default -> throw new IllegalArgumentException("Unknown protocol " + s);
            };
        }
    }

    public static enum Family {
        UNKNOWN,
        IPv4,
        IPv6,
        UNIX;


        static Family fromString(String s) {
            return switch (s) {
                case "TCP4" -> IPv4;
                case "TCP6" -> IPv6;
                case "UNIX" -> UNIX;
                case "UNKNOWN" -> UNKNOWN;
                default -> throw new IllegalArgumentException("Unknown family " + s);
            };
        }
    }
}

