/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.Weighted;
import io.helidon.webserver.http.ErrorHandler;
import io.helidon.webserver.http.Filter;
import io.helidon.webserver.http.HttpFeature;
import io.helidon.webserver.http.HttpRoute;
import io.helidon.webserver.http.HttpRouting;
import io.helidon.webserver.http.HttpSecurity;
import io.helidon.webserver.http.HttpService;
import io.helidon.webserver.http.Registration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

class ServerToHttpFeatureBuilder
implements HttpRouting.Builder {
    private final List<Registration> registrations = new ArrayList<Registration>();
    private final double weight;
    private final HttpRouting.Builder delegate;

    ServerToHttpFeatureBuilder(double weight, HttpRouting.Builder delegate) {
        this.weight = weight;
        this.delegate = delegate;
    }

    @Override
    public HttpRouting.Builder register(HttpService ... services) {
        this.registrations.add(Registration.create(services));
        return this;
    }

    @Override
    public HttpRouting.Builder register(String path, HttpService ... services) {
        this.registrations.add(Registration.create(path, services));
        return this;
    }

    @Override
    public HttpRouting.Builder route(HttpRoute route) {
        this.registrations.add(Registration.create(route));
        return this;
    }

    @Override
    public HttpRouting.Builder addFilter(Filter filter) {
        this.registrations.add(Registration.create(filter));
        return this;
    }

    @Override
    public HttpRouting.Builder addFeature(Supplier<? extends HttpFeature> feature) {
        this.delegate.addFeature(feature);
        return this;
    }

    @Override
    public <T extends Throwable> HttpRouting.Builder error(Class<T> exceptionClass, ErrorHandler<? super T> handler) {
        this.registrations.add(Registration.create(exceptionClass, handler));
        return this;
    }

    @Override
    public HttpRouting.Builder maxReRouteCount(int maxReRouteCount) {
        this.registrations.add(Registration.createMaxRerouteCount(maxReRouteCount));
        return this;
    }

    @Override
    public HttpRouting.Builder security(HttpSecurity security) {
        this.registrations.add(Registration.create(security));
        return this;
    }

    @Override
    public HttpRouting.Builder copy() {
        ServerToHttpFeatureBuilder copy = new ServerToHttpFeatureBuilder(this.weight, this.delegate.copy());
        copy.registrations.addAll(this.registrations);
        return copy;
    }

    public HttpRouting build() {
        throw new UnsupportedOperationException("This method should never escape internal Helidon types");
    }

    HttpFeature toFeature() {
        return new HttpFeatureForServerFeature(this, this.weight);
    }

    private static class HttpFeatureForServerFeature
    implements HttpFeature,
    Weighted {
        private final ServerToHttpFeatureBuilder builder;
        private final double weight;

        private HttpFeatureForServerFeature(ServerToHttpFeatureBuilder builder, double weight) {
            this.builder = builder;
            this.weight = weight;
        }

        @Override
        public void setup(HttpRouting.Builder routing) {
            this.builder.registrations.forEach(it -> it.register(routing));
        }

        public double weight() {
            return this.weight;
        }
    }
}

