/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http1;

import io.helidon.common.ParserHelper;
import io.helidon.common.buffers.BufferData;
import io.helidon.common.buffers.DataListener;
import io.helidon.common.buffers.DataReader;
import io.helidon.common.buffers.DataWriter;
import io.helidon.common.mapper.MapperException;
import io.helidon.common.task.InterruptableTask;
import io.helidon.common.tls.TlsUtils;
import io.helidon.http.BadRequestException;
import io.helidon.http.DateTime;
import io.helidon.http.DirectHandler;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNames;
import io.helidon.http.HeaderValues;
import io.helidon.http.Headers;
import io.helidon.http.HttpPrologue;
import io.helidon.http.InternalServerException;
import io.helidon.http.RequestException;
import io.helidon.http.ServerRequestHeaders;
import io.helidon.http.ServerResponseHeaders;
import io.helidon.http.Status;
import io.helidon.http.WritableHeaders;
import io.helidon.http.encoding.ContentDecoder;
import io.helidon.http.encoding.ContentEncodingContext;
import io.helidon.webserver.CloseConnectionException;
import io.helidon.webserver.ConnectionContext;
import io.helidon.webserver.ProxyProtocolData;
import io.helidon.webserver.http.DirectTransportRequest;
import io.helidon.webserver.http.HttpRouting;
import io.helidon.webserver.http1.EntityStyle;
import io.helidon.webserver.http1.Http1Config;
import io.helidon.webserver.http1.Http1ConnectionListener;
import io.helidon.webserver.http1.Http1Headers;
import io.helidon.webserver.http1.Http1Prologue;
import io.helidon.webserver.http1.Http1ServerRequest;
import io.helidon.webserver.http1.Http1ServerResponse;
import io.helidon.webserver.http1.spi.Http1Upgrader;
import io.helidon.webserver.spi.ServerConnection;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.function.Supplier;

public class Http1Connection
implements ServerConnection,
InterruptableTask<Void> {
    private static final System.Logger LOGGER = System.getLogger(Http1Connection.class.getName());
    private static final Supplier<RequestException> INVALID_SIZE_EXCEPTION_SUPPLIER = () -> RequestException.builder().type(DirectHandler.EventType.BAD_REQUEST).message("Chunk size is invalid").build();
    static final byte[] CONTINUE_100 = "HTTP/1.1 100 Continue\r\n\r\n".getBytes(StandardCharsets.UTF_8);
    private final ConnectionContext ctx;
    private final Http1Config http1Config;
    private final DataWriter writer;
    private final DataReader reader;
    private final Map<String, Http1Upgrader> upgradeProviderMap;
    private final boolean canUpgrade;
    private final Http1Headers http1headers;
    private final Http1Prologue http1prologue;
    private final ContentEncodingContext contentEncodingContext;
    private final HttpRouting routing;
    private final long maxPayloadSize;
    private final Http1ConnectionListener recvListener;
    private final Http1ConnectionListener sendListener;
    private int requestId;
    private long currentEntitySize;
    private long currentEntitySizeRead;
    private volatile Thread myThread;
    private volatile boolean canRun = true;
    private volatile boolean currentlyReadingPrologue;
    private volatile ZonedDateTime lastRequestTimestamp;
    private volatile ServerConnection upgradeConnection;

    Http1Connection(ConnectionContext ctx, Http1Config http1Config, Map<String, Http1Upgrader> upgradeProviderMap) {
        this.ctx = ctx;
        this.writer = ctx.dataWriter();
        this.reader = ctx.dataReader();
        this.http1Config = http1Config;
        this.upgradeProviderMap = upgradeProviderMap;
        this.canUpgrade = !upgradeProviderMap.isEmpty();
        this.recvListener = http1Config.compositeReceiveListener();
        this.sendListener = http1Config.compositeSendListener();
        this.reader.listener((DataListener)this.recvListener, (Object)ctx);
        this.http1headers = new Http1Headers(this.reader, http1Config.maxHeadersSize(), http1Config.validateRequestHeaders());
        this.http1prologue = new Http1Prologue(this.reader, http1Config.maxPrologueLength(), http1Config.validatePath());
        this.contentEncodingContext = ctx.listenerContext().contentEncodingContext();
        this.routing = ctx.router().routing(HttpRouting.class, HttpRouting.empty());
        this.maxPayloadSize = ctx.listenerContext().config().maxPayloadSize();
        this.lastRequestTimestamp = DateTime.timestamp();
    }

    public boolean canInterrupt() {
        if (this.upgradeConnection == null) {
            return this.currentlyReadingPrologue;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(Semaphore requestSemaphore) throws InterruptedException {
        this.myThread = Thread.currentThread();
        try {
            ProxyProtocolData proxyProtocolData = this.ctx.proxyProtocolData().orElse(null);
            while (this.canRun) {
                ServerConnection upgradeConnection;
                Http1Upgrader upgrader;
                this.currentlyReadingPrologue = true;
                HttpPrologue prologue = this.http1prologue.readPrologue();
                this.currentlyReadingPrologue = false;
                this.lastRequestTimestamp = DateTime.timestamp();
                this.recvListener.prologue(this.ctx, prologue);
                this.currentEntitySize = 0L;
                this.currentEntitySizeRead = 0L;
                WritableHeaders<?> headers = this.http1headers.readHeaders(prologue);
                this.ctx.remotePeer().tlsCertificates().flatMap(TlsUtils::parseCn).ifPresent(name -> headers.set(HeaderNames.X_HELIDON_CN, new String[]{name}));
                this.recvListener.headers(this.ctx, (Headers)headers);
                if (proxyProtocolData != null) {
                    int sourcePort;
                    String sourceAddress = proxyProtocolData.sourceAddress();
                    if (!sourceAddress.isEmpty()) {
                        headers.add(HeaderNames.X_FORWARDED_FOR, new String[]{sourceAddress});
                    }
                    if ((sourcePort = proxyProtocolData.sourcePort()) != -1) {
                        headers.add(HeaderNames.X_FORWARDED_PORT, sourcePort);
                    }
                }
                if (this.canUpgrade && headers.contains(HeaderNames.UPGRADE) && (upgrader = this.upgradeProviderMap.get(headers.get(HeaderNames.UPGRADE).get())) != null && (upgradeConnection = upgrader.upgrade(this.ctx, prologue, headers)) != null) {
                    if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                        LOGGER.log(System.Logger.Level.TRACE, "Connection upgrade using " + String.valueOf(upgradeConnection));
                    }
                    this.upgradeConnection = upgradeConnection;
                    upgradeConnection.handle(requestSemaphore);
                    return;
                }
                if (requestSemaphore.tryAcquire()) {
                    try {
                        this.lastRequestTimestamp = DateTime.timestamp();
                        this.route(prologue, headers);
                        this.lastRequestTimestamp = DateTime.timestamp();
                        continue;
                    }
                    finally {
                        requestSemaphore.release();
                        continue;
                    }
                }
                this.ctx.log(LOGGER, System.Logger.Level.TRACE, "Too many concurrent requests, rejecting request and closing connection.", new Object[0]);
                throw RequestException.builder().setKeepAlive(false).status(Status.SERVICE_UNAVAILABLE_503).type(DirectHandler.EventType.OTHER).message("Too Many Concurrent Requests").build();
            }
        }
        catch (CloseConnectionException | UncheckedIOException e) {
            throw e;
        }
        catch (BadRequestException e) {
            this.handleRequestException(RequestException.builder().message(e.getMessage()).cause((Throwable)e).type(DirectHandler.EventType.BAD_REQUEST).status(e.status()).setKeepAlive(e.keepAlive()).build());
        }
        catch (RequestException e) {
            this.handleRequestException(e);
        }
        catch (Throwable e) {
            this.handleRequestException(RequestException.builder().message("Internal error").type(DirectHandler.EventType.INTERNAL_ERROR).cause(e).build());
        }
    }

    @Override
    public Duration idleTime() {
        if (this.upgradeConnection == null) {
            return Duration.between(this.lastRequestTimestamp, DateTime.timestamp());
        }
        return this.upgradeConnection.idleTime();
    }

    @Override
    public void close(boolean interrupt) {
        this.ctx.log(LOGGER, System.Logger.Level.TRACE, "Requested connection close, interrupt: %s", new Object[]{interrupt});
        this.canRun = false;
        if (this.upgradeConnection == null) {
            if (interrupt) {
                if (this.myThread != null) {
                    this.myThread.interrupt();
                }
            } else if (this.canInterrupt()) {
                this.myThread.interrupt();
            }
        } else {
            this.upgradeConnection.close(interrupt);
        }
    }

    private BufferData readEntityFromPipeline(HttpPrologue prologue, WritableHeaders<?> headers) {
        if (this.currentEntitySize == -1L) {
            return this.readNextChunk(prologue, headers);
        }
        return this.readLengthEntity();
    }

    private BufferData readNextChunk(HttpPrologue prologue, WritableHeaders<?> headers) {
        String hex = this.reader.readLine();
        int chunkLength = ParserHelper.parseNonNegative((String)hex, (int)16, INVALID_SIZE_EXCEPTION_SUPPLIER);
        this.currentEntitySizeRead += (long)chunkLength;
        if (this.maxPayloadSize != -1L && this.currentEntitySizeRead > this.maxPayloadSize) {
            throw RequestException.builder().type(DirectHandler.EventType.BAD_REQUEST).status(Status.REQUEST_ENTITY_TOO_LARGE_413).request(DirectTransportRequest.create(prologue, headers)).setKeepAlive(false).build();
        }
        if (chunkLength == 0) {
            String end = this.reader.readLine();
            if (!end.isEmpty()) {
                throw RequestException.builder().type(DirectHandler.EventType.BAD_REQUEST).message("Invalid terminating chunk").build();
            }
            return null;
        }
        BufferData nextChunkData = this.reader.readBuffer(chunkLength);
        this.reader.skip(2);
        return nextChunkData;
    }

    private BufferData readLengthEntity() {
        long stillNeed = this.currentEntitySize - this.currentEntitySizeRead;
        if (stillNeed == 0L) {
            return null;
        }
        this.reader.ensureAvailable();
        int toRead = (int)Math.min((long)this.reader.available(), stillNeed);
        BufferData buffer = this.reader.readBuffer(toRead);
        this.currentEntitySizeRead += (long)toRead;
        return buffer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void route(HttpPrologue prologue, WritableHeaders<?> headers) {
        ContentDecoder decoder;
        EntityStyle entity = EntityStyle.NONE;
        if (headers.contains(HeaderValues.TRANSFER_ENCODING_CHUNKED)) {
            entity = EntityStyle.CHUNKED;
            this.currentEntitySize = -1L;
        } else if (headers.contains(HeaderNames.CONTENT_LENGTH)) {
            try {
                this.currentEntitySize = (Long)headers.get(HeaderNames.CONTENT_LENGTH).get(Long.TYPE);
                if (this.maxPayloadSize != -1L && this.currentEntitySize > this.maxPayloadSize) {
                    throw RequestException.builder().type(DirectHandler.EventType.BAD_REQUEST).status(Status.REQUEST_ENTITY_TOO_LARGE_413).request(DirectTransportRequest.create(prologue, headers)).setKeepAlive(false).build();
                }
                entity = this.currentEntitySize == 0L ? EntityStyle.NONE : EntityStyle.LENGTH;
            }
            catch (MapperException e) {
                throw RequestException.builder().type(DirectHandler.EventType.BAD_REQUEST).request(DirectTransportRequest.create(prologue, headers)).message("Content length is not a number").cause((Throwable)e).build();
            }
        }
        ++this.requestId;
        if (entity == EntityStyle.NONE) {
            Http1ServerRequest request;
            Http1ServerResponse response = new Http1ServerResponse(this.ctx, this.sendListener, this.writer, request, !(request = Http1ServerRequest.create(this.ctx, this.routing.security(), prologue, headers, this.requestId)).headers().contains(HeaderValues.CONNECTION_CLOSE), this.http1Config.validateResponseHeaders());
            this.routing.route(this.ctx, request, response);
            return;
        }
        boolean expectContinue = false;
        if (headers.contains(HeaderValues.EXPECT_100)) {
            if (this.http1Config.continueImmediately()) {
                this.writer.writeNow(BufferData.create((byte[])CONTINUE_100));
            }
            expectContinue = true;
        }
        if (this.contentEncodingContext.contentDecodingEnabled()) {
            if (headers.contains(HeaderNames.CONTENT_ENCODING)) {
                String contentEncoding = (String)headers.get(HeaderNames.CONTENT_ENCODING).get();
                if (!this.contentEncodingContext.contentDecodingSupported(contentEncoding)) throw RequestException.builder().type(DirectHandler.EventType.BAD_REQUEST).request(DirectTransportRequest.create(prologue, headers)).message("Unsupported content encoding").build();
                decoder = this.contentEncodingContext.decoder(contentEncoding);
            } else {
                decoder = ContentDecoder.NO_OP;
            }
        } else {
            if (this.http1Config.validateRequestHeaders() && headers.contains(HeaderNames.CONTENT_ENCODING)) {
                throw RequestException.builder().type(DirectHandler.EventType.BAD_REQUEST).request(DirectTransportRequest.create(prologue, headers)).message("Content-Encoding header present when content encoding is disabled").build();
            }
            decoder = ContentDecoder.NO_OP;
        }
        CountDownLatch entityReadLatch = new CountDownLatch(1);
        Http1ServerRequest request = Http1ServerRequest.create(this.ctx, this, this.http1Config, this.routing.security(), prologue, ServerRequestHeaders.create(headers), decoder, this.requestId, expectContinue, entityReadLatch, () -> this.readEntityFromPipeline(prologue, headers));
        Http1ServerResponse response = new Http1ServerResponse(this.ctx, this.sendListener, this.writer, request, !request.headers().contains(HeaderValues.CONNECTION_CLOSE), this.http1Config.validateResponseHeaders());
        this.routing.route(this.ctx, request, response);
        this.consumeEntity(request, response, entityReadLatch);
        try {
            entityReadLatch.await();
            return;
        }
        catch (InterruptedException e) {
            throw RequestException.builder().type(DirectHandler.EventType.INTERNAL_ERROR).request(DirectTransportRequest.create(prologue, headers)).message("Failed to wait for pipeline").cause((Throwable)e).build();
        }
    }

    private void consumeEntity(Http1ServerRequest request, Http1ServerResponse response, CountDownLatch entityReadLatch) {
        if (response.headers().contains(HeaderValues.CONNECTION_CLOSE) || request.content().consumed()) {
            entityReadLatch.countDown();
            return;
        }
        try {
            request.content().consume();
        }
        catch (Exception e) {
            boolean keepAlive;
            boolean bl = keepAlive = request.content().consumed() && response.headers().contains(HeaderValues.CONNECTION_KEEP_ALIVE);
            if (!response.isSent()) {
                throw new InternalServerException(e.getMessage(), (Throwable)e, keepAlive);
            }
            throw new CloseConnectionException("Failed to consume request entity, must close", e);
        }
    }

    private void handleRequestException(RequestException e) {
        DirectHandler handler = this.ctx.listenerContext().directHandlers().handler(e.eventType());
        DirectHandler.TransportResponse response = handler.handle(e.request(), e.eventType(), e.status(), e.responseHeaders(), (Throwable)e, LOGGER);
        BufferData buffer = BufferData.growing((int)128);
        ServerResponseHeaders headers = response.headers();
        if (!e.keepAlive()) {
            headers.set(HeaderValues.CONNECTION_CLOSE);
        }
        byte[] message = response.entity().orElse(BufferData.EMPTY_BYTES);
        headers.set(HeaderValues.create((HeaderName)HeaderNames.CONTENT_LENGTH, (String)String.valueOf(message.length)));
        Http1ServerResponse.nonEntityBytes(headers, response.status(), buffer, response.keepAlive(), this.http1Config.validateResponseHeaders());
        if (message.length != 0) {
            buffer.write(message);
        }
        this.sendListener.status(this.ctx, response.status());
        this.sendListener.headers(this.ctx, (Headers)headers);
        this.sendListener.data(this.ctx, buffer);
        this.writer.write(buffer);
        if (response.status() == Status.INTERNAL_SERVER_ERROR_500) {
            LOGGER.log(System.Logger.Level.WARNING, "Internal server error", (Throwable)e);
        }
    }

    void reset() {
        this.currentEntitySize = 0L;
        this.currentEntitySizeRead = 0L;
    }
}

