/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.observe;

import io.helidon.http.HttpException;
import io.helidon.http.Status;
import io.helidon.webserver.http.Handler;
import io.helidon.webserver.http.HttpFeature;
import io.helidon.webserver.http.HttpRouting;

public class DisabledObserverFeature
implements HttpFeature {
    private final String observerName;
    private final String endpoint;

    private DisabledObserverFeature(String observerName, String endpoint) {
        this.observerName = observerName;
        this.endpoint = endpoint;
    }

    public static DisabledObserverFeature create(String observerName, String endpoint) {
        return new DisabledObserverFeature(observerName, endpoint);
    }

    public void setup(HttpRouting.Builder routing) {
        routing.any(this.endpoint, new Handler[]{(req, res) -> {
            throw new HttpException(this.observerName + " endpoint is disabled", Status.SERVICE_UNAVAILABLE_503, true);
        }});
    }
}

