/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.config.runtime;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClassMappingProvider {
    private static final Logger log = LoggerFactory.getLogger(ClassMappingProvider.class);

    ClassMappingProvider() {
    }

    static <T, V> Map<T, V> provide(String resourcePath, T key, V value) {
        HashMap result = new HashMap();
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> resourcesMetadataList = classLoader.getResources(resourcePath);
            Iterator<URL> it = resourcesMetadataList.asIterator();
            while (it.hasNext()) {
                URL url = it.next();
                List<String> classNamePairs = ClassMappingProvider.retrieveClassNamePairs(url);
                classNamePairs.forEach(clazzPair -> {
                    try {
                        String[] classNames = clazzPair.split(",");
                        if (classNames.length != 2) {
                            throw new IllegalStateException(String.format("%s is not valid Mapping metadata, defined in %s", clazzPair, url));
                        }
                        result.put(ClassUtils.getClass((String)classNames[0]), ClassUtils.getClass((String)classNames[1]));
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            log.debug("Loaded Controller to resource mappings {}", result);
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<String> retrieveClassNamePairs(URL url) throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));){
            List<String> list = br.lines().collect(Collectors.toList());
            return list;
        }
    }
}

