/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.config.runtime;

import com.squareup.javapoet.TypeName;
import io.fabric8.kubernetes.client.CustomResource;
import io.javaoperatorsdk.operator.api.reconciler.Reconciler;
import io.javaoperatorsdk.operator.config.runtime.AccumulativeMappingWriter;
import io.javaoperatorsdk.operator.config.runtime.TypeParameterResolver;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SupportedAnnotationTypes(value={"io.javaoperatorsdk.operator.api.reconciler.ControllerConfiguration"})
public class ControllerConfigurationAnnotationProcessor
extends AbstractProcessor {
    private static final Logger log = LoggerFactory.getLogger(ControllerConfigurationAnnotationProcessor.class);
    private AccumulativeMappingWriter controllersResourceWriter;
    private TypeParameterResolver typeParameterResolver;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.controllersResourceWriter = new AccumulativeMappingWriter("javaoperatorsdk/reconcilers", processingEnv).loadExistingMappings();
        this.typeParameterResolver = this.initializeResolver(processingEnv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            for (TypeElement typeElement : annotations) {
                Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(typeElement);
                annotatedElements.stream().filter(element -> element.getKind().equals((Object)ElementKind.CLASS)).map(e -> (TypeElement)e).forEach(this::recordCRType);
            }
        }
        finally {
            if (roundEnv.processingOver()) {
                this.controllersResourceWriter.flush();
            }
        }
        return true;
    }

    private TypeParameterResolver initializeResolver(ProcessingEnvironment processingEnv) {
        DeclaredType resourceControllerType = processingEnv.getTypeUtils().getDeclaredType(processingEnv.getElementUtils().getTypeElement(Reconciler.class.getCanonicalName()), processingEnv.getTypeUtils().getWildcardType(null, null));
        return new TypeParameterResolver(resourceControllerType, 0);
    }

    private void recordCRType(TypeElement controllerClassSymbol) {
        try {
            TypeMirror resourceType = this.findResourceType(controllerClassSymbol);
            if (resourceType == null) {
                this.controllersResourceWriter.add(controllerClassSymbol.getQualifiedName().toString(), CustomResource.class.getCanonicalName());
                System.out.println("No defined resource type for '" + controllerClassSymbol.getQualifiedName() + "': ignoring!");
                return;
            }
            TypeName customResourceType = TypeName.get((TypeMirror)resourceType);
            this.controllersResourceWriter.add(controllerClassSymbol.getQualifiedName().toString(), customResourceType.toString());
        }
        catch (Exception ioException) {
            log.error("Error", (Throwable)ioException);
        }
    }

    private TypeMirror findResourceType(TypeElement controllerClassSymbol) {
        try {
            return this.typeParameterResolver.resolve(this.processingEnv.getTypeUtils(), (DeclaredType)controllerClassSymbol.asType());
        }
        catch (Exception e) {
            log.error("Error", (Throwable)e);
            return null;
        }
    }
}

