/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.commons;

import io.jenkins.blueocean.commons.ErrorMessage;
import io.jenkins.blueocean.commons.JsonConverter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class ServiceException
extends RuntimeException
implements HttpResponse {
    public final int status;
    public final ErrorMessage errorMessage;
    public static final int BAD_REQUEST = 400;
    public static final int UNAUTHORIZED = 401;
    public static final int FORBIDDEN = 403;
    public static final int NOT_FOUND = 404;
    public static final int METHOD_NOT_ALLOWED = 405;
    public static final int UNSUPPORTED_MEDIA_TYPE = 415;
    public static final int CONFLICT = 409;
    public static final int UNPROCESSABLE_ENTITY = 422;
    public static final int PRECONDITION_REQUIRED = 428;
    public static final int TOO_MANY_REQUESTS = 429;
    public static final int INTERNAL_SERVER_ERROR = 500;
    public static final int NOT_IMPLEMENTED = 501;

    public ServiceException(int status, String message) {
        super(message);
        this.status = status;
        this.errorMessage = new ErrorMessage(status, message);
    }

    public ServiceException(int status, String message, Throwable cause) {
        super(message, cause);
        this.status = status;
        this.errorMessage = new ErrorMessage(status, message);
    }

    public ServiceException(int status, ErrorMessage errorMessage, Throwable cause) {
        super(errorMessage.message, cause);
        this.status = status;
        this.errorMessage = errorMessage;
    }

    public String toJson() {
        return JsonConverter.toJson(this.errorMessage);
    }

    public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
        rsp.setStatus(this.status);
        rsp.setContentType("application/json");
        PrintWriter w = rsp.getWriter();
        w.write(this.toJson());
        w.close();
    }

    public static class PreconditionRequired
    extends ServiceException {
        public PreconditionRequired(String message) {
            super(428, message);
        }

        public PreconditionRequired(String message, Throwable throwable) {
            super(428, message, throwable);
        }

        public PreconditionRequired(ErrorMessage errorMessage) {
            super(428, errorMessage, null);
        }

        public PreconditionRequired(ErrorMessage errorMessage, Throwable throwable) {
            super(428, errorMessage, throwable);
        }
    }

    public static class MethodNotAllowedException
    extends ServiceException {
        public MethodNotAllowedException(String message) {
            super(405, message);
        }

        public MethodNotAllowedException(String message, Throwable throwable) {
            super(405, message, throwable);
        }

        public MethodNotAllowedException(ErrorMessage errorMessage) {
            super(405, errorMessage, null);
        }

        public MethodNotAllowedException(ErrorMessage errorMessage, Throwable throwable) {
            super(405, errorMessage, throwable);
        }
    }

    public static class UnsupportedMediaTypeException
    extends ServiceException {
        public UnsupportedMediaTypeException(String message) {
            super(415, message);
        }

        public UnsupportedMediaTypeException(String message, Throwable throwable) {
            super(415, message, throwable);
        }

        public UnsupportedMediaTypeException(ErrorMessage errorMessage) {
            super(415, errorMessage, null);
        }

        public UnsupportedMediaTypeException(ErrorMessage errorMessage, Throwable throwable) {
            super(415, errorMessage, throwable);
        }
    }

    public static class NotImplementedException
    extends ServiceException {
        public NotImplementedException(String message) {
            super(501, message);
        }

        public NotImplementedException(String message, Throwable throwable) {
            super(501, message, throwable);
        }

        public NotImplementedException(ErrorMessage errorMessage) {
            super(501, errorMessage, null);
        }

        public NotImplementedException(ErrorMessage errorMessage, Throwable throwable) {
            super(501, errorMessage, throwable);
        }
    }

    public static class UnexpectedErrorException
    extends ServiceException {
        public UnexpectedErrorException(String message) {
            super(500, message);
        }

        public UnexpectedErrorException(String message, Throwable throwable) {
            super(500, message, throwable);
        }

        public UnexpectedErrorException(ErrorMessage errorMessage) {
            super(500, errorMessage, null);
        }

        public UnexpectedErrorException(ErrorMessage errorMessage, Throwable throwable) {
            super(500, errorMessage, throwable);
        }
    }

    public static class TooManyRequestsException
    extends ServiceException {
        public TooManyRequestsException(String message) {
            super(429, message);
        }

        public TooManyRequestsException(String message, Throwable throwable) {
            super(429, message, throwable);
        }

        public TooManyRequestsException(ErrorMessage errorMessage) {
            super(429, errorMessage, null);
        }

        public TooManyRequestsException(ErrorMessage errorMessage, Throwable throwable) {
            super(429, errorMessage, throwable);
        }
    }

    public static class ConflictException
    extends ServiceException {
        public ConflictException(String message) {
            super(409, message);
        }

        public ConflictException(String message, Throwable throwable) {
            super(409, message, throwable);
        }

        public ConflictException(ErrorMessage errorMessage) {
            super(409, errorMessage, null);
        }

        public ConflictException(ErrorMessage errorMessage, Throwable throwable) {
            super(409, errorMessage, throwable);
        }
    }

    public static class UnprocessableEntityException
    extends ServiceException {
        public UnprocessableEntityException(String message) {
            super(422, message);
        }

        public UnprocessableEntityException(String message, Throwable throwable) {
            super(422, message, throwable);
        }

        public UnprocessableEntityException(ErrorMessage errorMessage) {
            super(422, errorMessage, null);
        }

        public UnprocessableEntityException(ErrorMessage errorMessage, Throwable throwable) {
            super(422, errorMessage.message, throwable);
        }
    }

    public static class BadRequestException
    extends ServiceException {
        public BadRequestException(String message) {
            super(400, message);
        }

        public BadRequestException(String message, Throwable throwable) {
            super(400, message, throwable);
        }

        public BadRequestException(ErrorMessage errorMessage) {
            super(400, errorMessage, null);
        }

        public BadRequestException(ErrorMessage errorMessage, Throwable throwable) {
            super(400, errorMessage, throwable);
        }
    }

    public static class UnauthorizedException
    extends ServiceException {
        public UnauthorizedException(String message) {
            super(401, message);
        }

        public UnauthorizedException(String message, Throwable throwable) {
            super(401, message, throwable);
        }

        public UnauthorizedException(ErrorMessage errorMessage) {
            super(401, errorMessage, null);
        }

        public UnauthorizedException(ErrorMessage errorMessage, Throwable throwable) {
            super(401, errorMessage, throwable);
        }
    }

    public static class ForbiddenException
    extends ServiceException {
        public ForbiddenException(String message) {
            super(403, message);
        }

        public ForbiddenException(String message, Throwable throwable) {
            super(403, message, throwable);
        }

        public ForbiddenException(ErrorMessage errorMessage) {
            super(403, errorMessage, null);
        }

        public ForbiddenException(ErrorMessage errorMessage, Throwable throwable) {
            super(403, errorMessage, throwable);
        }
    }

    public static class NotFoundException
    extends ServiceException {
        public NotFoundException(String message) {
            super(404, message);
        }

        public NotFoundException(String message, Throwable throwable) {
            super(404, message, throwable);
        }

        public NotFoundException(ErrorMessage errorMessage) {
            super(404, errorMessage, null);
        }

        public NotFoundException(ErrorMessage errorMessage, Throwable throwable) {
            super(404, errorMessage, throwable);
        }
    }
}

