'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Security = undefined;

var _config = require('./config');

var _User = require('./User');

/**
 * Returns a key of permissions functions that each return boolean to indicate authorization.
 * Usage:
 *      permit(pipeline).create();
 *
 * @param subject
 * @returns {{read: (function()), create: (function()), start: (function()), stop: (function())}}
 */
/**
 * Created by cmeyers on 9/16/16.
 */

var permit = function permit(subject) {
    var checkPermissions = function checkPermissions(permissionName) {
        return subject && subject.permissions && !!subject.permissions[permissionName];
    };

    return {
        read: function read() {
            return checkPermissions('read');
        },
        configure: function configure() {
            return checkPermissions('configure');
        },
        create: function create() {
            return checkPermissions('create');
        },
        start: function start() {
            return checkPermissions('start');
        },
        stop: function stop() {
            return checkPermissions('stop');
        }
    };
};

function isSecurityEnabled() {
    return !!_config.AppConfig.getSecurityConfig().enabled;
}

function isAnonymousUser() {
    return _User.User.current().isAnonymous();
}

var Security = exports.Security = {
    permit: permit,
    isSecurityEnabled: isSecurityEnabled,
    isAnonymousUser: isAnonymousUser
};
//# sourceMappingURL=security.js.map
