'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.ToastService = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _desc, _value, _class, _descriptor; /**
                                         * Created by cmeyers on 8/18/16.
                                         */


var _mobx = require('mobx');

function _initDefineProp(target, property, descriptor, context) {
    if (!descriptor) return;
    Object.defineProperty(target, property, {
        enumerable: descriptor.enumerable,
        configurable: descriptor.configurable,
        writable: descriptor.writable,
        value: descriptor.initializer ? descriptor.initializer.call(context) : void 0
    });
}

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
    var desc = {};
    Object['ke' + 'ys'](descriptor).forEach(function (key) {
        desc[key] = descriptor[key];
    });
    desc.enumerable = !!desc.enumerable;
    desc.configurable = !!desc.configurable;

    if ('value' in desc || desc.initializer) {
        desc.writable = true;
    }

    desc = decorators.slice().reverse().reduce(function (desc, decorator) {
        return decorator(target, property, desc) || desc;
    }, desc);

    if (context && desc.initializer !== void 0) {
        desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
        desc.initializer = undefined;
    }

    if (desc.initializer === void 0) {
        Object['define' + 'Property'](target, property, desc);
        desc = null;
    }

    return desc;
}

function _initializerWarningHelper(descriptor, context) {
    throw new Error('Decorating class property failed. Please ensure that transform-class-properties is enabled.');
}

/**
 * Holds one or more toasts in state for display in UI.
 */
var ToastService = exports.ToastService = (_class = function () {
    function ToastService() {
        _classCallCheck(this, ToastService);

        _initDefineProp(this, 'toasts', _descriptor, this);
    }

    _createClass(ToastService, [{
        key: 'newToast',


        /**
         * Creates a new toast that is added to the list.
         *
         * @param toast object with the following shape:
         * {
         *  text: string, message text to display
         *  action: string, text for action link
         *  onActionClick: function, callback to invoke when action link is clicked
         *  onDismiss: function, callback to invoke when toast is dismissed (immediately, or after timeout)
         *  dismissDelay: number, duration in millis after which to auto-dismiss this Toast
         *  id: unique identifier (optional, will be autogenerated if omitted)
         * }
         * @returns {number} unique ID of toast
         */
        value: function newToast(toast) {
            // prevent duplicate toasts from appearing when multiple UI elements
            // are listening for an event that triggers creation of a toast
            if (this._hasDuplicate(toast)) {
                return null;
            }

            var newToast = toast;

            if (!newToast.id) {
                newToast.id = Math.random() * Math.pow(10, 16);
            }

            this.toasts.push(newToast);

            return newToast.id;
        }

        /**
         * Removes a toast with the matching value of toast.id.
         *
         * @param toast
         */

    }, {
        key: 'removeToast',
        value: function removeToast(toast) {
            this.toasts = this.toasts.filter(function (item) {
                return toast.id !== item.id;
            });
        }
    }, {
        key: '_hasDuplicate',


        /**
         * Returns true if a toast with the same 'text' and 'action' already exists
         * @param newToast
         * @returns {boolean}
         * @private
         */
        value: function _hasDuplicate(newToast) {
            var _iteratorNormalCompletion = true;
            var _didIteratorError = false;
            var _iteratorError = undefined;

            try {
                for (var _iterator = this.toasts[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
                    var toast = _step.value;

                    if (toast.text === newToast.text && toast.action === newToast.action) {
                        return true;
                    }
                }
            } catch (err) {
                _didIteratorError = true;
                _iteratorError = err;
            } finally {
                try {
                    if (!_iteratorNormalCompletion && _iterator.return) {
                        _iterator.return();
                    }
                } finally {
                    if (_didIteratorError) {
                        throw _iteratorError;
                    }
                }
            }

            return false;
        }
    }, {
        key: 'count',
        get: function get() {
            return this.toasts ? this.toasts.length : 0;
        }
    }]);

    return ToastService;
}(), (_descriptor = _applyDecoratedDescriptor(_class.prototype, 'toasts', [_mobx.observable], {
    enumerable: true,
    initializer: function initializer() {
        return [];
    }
}), _applyDecoratedDescriptor(_class.prototype, 'newToast', [_mobx.action], Object.getOwnPropertyDescriptor(_class.prototype, 'newToast'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'removeToast', [_mobx.action], Object.getOwnPropertyDescriptor(_class.prototype, 'removeToast'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'count', [_mobx.computed], Object.getOwnPropertyDescriptor(_class.prototype, 'count'), _class.prototype)), _class);
//# sourceMappingURL=ToastService.js.map
