'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * Created by cmeyers on 9/8/16.
 */

var addClass = function addClass(clazz, classMap) {
    var className = void 0;

    if (Array.isArray(clazz._class)) {
        // If it's an array of class names, just take the first.
        // TODO: Hmmm ... not sure if this is the right thing to do when we have an array of class names.
        // Not sure what the array is about tbh. What are the relationships?
        if (clazz._class.length > 0) {
            className = clazz._class[0];
        } else {
            return;
        }
    } else {
        className = clazz._class;
    }

    if (!classMap[className]) {
        // eslint-disable-next-line no-param-reassign
        classMap[className] = [];
    }

    classMap[className].push(clazz);
};

var canWalk = function canWalk(item) {
    return item && ((typeof item === 'undefined' ? 'undefined' : _typeof(item)) === 'object' || Array.isArray(item));
};

var DEFAULT_IGNORED_PROPS = ['_links'];

/**
 * Decorate an object graph with a '_capabilities' property for each object with a valid '_class'
 * Usage:
 *      import { capabilityAugmenter } from '@jenkins-cd/blueocean-core-js';
 *      const augmentCapability = capabilityAugmenter.augmentCapability;
 *
 *      fetch(url, fetchOptions)
 *          .then(data => augmentCapability(data));
 */

var CapabilityAugmenter = exports.CapabilityAugmenter = function () {
    function CapabilityAugmenter(capabilityStore) {
        _classCallCheck(this, CapabilityAugmenter);

        this._capabilityStore = capabilityStore;
        this._perfLoggingEnabled = false;
        this._warnLoggingEnabled = false;
    }

    /**
     * Add "_capabilities" data or all objects with a "_class" property.
     *
     * @param {object|Array} data
     * @returns {Promise}
     */


    _createClass(CapabilityAugmenter, [{
        key: 'augmentCapabilities',
        value: function augmentCapabilities(data) {
            var classMap = this._findClassesInTree(data);
            return this._resolveCapabilities(data, classMap);
        }
    }, {
        key: 'enablePerfLogging',
        value: function enablePerfLogging() {
            this._perfLoggingEnabled = true;
        }
    }, {
        key: 'enableWarningLogging',
        value: function enableWarningLogging() {
            this._warnLoggingEnabled = true;
        }

        /**
         * Find all of the distinct "_class" values in supplied object.
         *
         * @param {object|Array} data
         * @returns {object} key= "_class" name, value= array of all objects of that class.
         * @private
         */

    }, {
        key: '_findClassesInTree',
        value: function _findClassesInTree(data) {
            var classMap = {};
            var nodesToWalk = [data];
            var nodesAlreadyWalked = [];
            var ignoredProps = DEFAULT_IGNORED_PROPS.slice();

            var started = new Date().getTime();

            var node = nodesToWalk.shift();

            while (node) {
                nodesAlreadyWalked.push(node);

                // save a ref to the class so we can attach capabilities later
                if ((typeof node === 'undefined' ? 'undefined' : _typeof(node)) === 'object' && node._class) {
                    addClass(node, classMap);
                }

                var nodeKeys = Object.keys(node);

                var _iteratorNormalCompletion = true;
                var _didIteratorError = false;
                var _iteratorError = undefined;

                try {
                    for (var _iterator = nodeKeys[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
                        var key = _step.value;

                        var value = node[key];

                        // walk this node at a later iteration as long as
                        // - we didn't already walk it (cycles cause an infinite loop otherwise)
                        // - the property name isn't on the blacklist
                        if (canWalk(value) && nodesAlreadyWalked.indexOf(value) === -1 && ignoredProps.indexOf(key) === -1) {
                            nodesToWalk.push(value);
                        }
                    }
                } catch (err) {
                    _didIteratorError = true;
                    _iteratorError = err;
                } finally {
                    try {
                        if (!_iteratorNormalCompletion && _iterator.return) {
                            _iterator.return();
                        }
                    } finally {
                        if (_didIteratorError) {
                            throw _iteratorError;
                        }
                    }
                }

                node = nodesToWalk.shift();
            }

            if (this._perfLoggingEnabled) {
                console.debug('augmenter.parse: ' + (new Date().getTime() - started) + 'ms');
            }

            return classMap;
        }
    }, {
        key: '_resolveCapabilities',
        value: function _resolveCapabilities(data, classMap) {
            var _capabilityStore,
                _this = this;

            var classNames = Object.keys(classMap);

            return (_capabilityStore = this._capabilityStore).resolveCapabilities.apply(_capabilityStore, _toConsumableArray(classNames)).then(function (capabilitiesMap) {
                return _this._injectCapabilities(classMap, capabilitiesMap);
            }).then(function () {
                return data;
            });
        }

        /**
         * Add the capabilities to the "_capabilities" property of all objects in the class map.
         *
         * @param classMap
         * @param capabilitiesMap
         * @returns {object} classMap
         * @private
         */

    }, {
        key: '_injectCapabilities',
        value: function _injectCapabilities(classMap, capabilitiesMap) {
            var started = new Date().getTime();
            var unresolved = [];

            var _iteratorNormalCompletion2 = true;
            var _didIteratorError2 = false;
            var _iteratorError2 = undefined;

            try {
                for (var _iterator2 = Object.keys(classMap)[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
                    var _className = _step2.value;
                    var _iteratorNormalCompletion4 = true;
                    var _didIteratorError4 = false;
                    var _iteratorError4 = undefined;

                    try {
                        for (var _iterator4 = classMap[_className][Symbol.iterator](), _step4; !(_iteratorNormalCompletion4 = (_step4 = _iterator4.next()).done); _iteratorNormalCompletion4 = true) {
                            var target = _step4.value;

                            var capabilities = capabilitiesMap[_className];

                            if (!capabilities && unresolved.indexOf(_className) === -1) {
                                unresolved.push(_className);
                            }

                            target._capabilities = capabilities || [];
                        }
                    } catch (err) {
                        _didIteratorError4 = true;
                        _iteratorError4 = err;
                    } finally {
                        try {
                            if (!_iteratorNormalCompletion4 && _iterator4.return) {
                                _iterator4.return();
                            }
                        } finally {
                            if (_didIteratorError4) {
                                throw _iteratorError4;
                            }
                        }
                    }
                }
            } catch (err) {
                _didIteratorError2 = true;
                _iteratorError2 = err;
            } finally {
                try {
                    if (!_iteratorNormalCompletion2 && _iterator2.return) {
                        _iterator2.return();
                    }
                } finally {
                    if (_didIteratorError2) {
                        throw _iteratorError2;
                    }
                }
            }

            if (this._perfLoggingEnabled) {
                console.debug('augmenter.inject: ' + (new Date().getTime() - started) + 'ms');
            }

            if (this._warnLoggingEnabled) {
                var _iteratorNormalCompletion3 = true;
                var _didIteratorError3 = false;
                var _iteratorError3 = undefined;

                try {
                    for (var _iterator3 = unresolved[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
                        var className = _step3.value;

                        console.warn('could not resolve capabilities for ' + className + '; an error may have occurred during lookup');
                    }
                } catch (err) {
                    _didIteratorError3 = true;
                    _iteratorError3 = err;
                } finally {
                    try {
                        if (!_iteratorNormalCompletion3 && _iterator3.return) {
                            _iterator3.return();
                        }
                    } finally {
                        if (_didIteratorError3) {
                            throw _iteratorError3;
                        }
                    }
                }
            }

            return classMap;
        }
    }]);

    return CapabilityAugmenter;
}();
//# sourceMappingURL=CapabilityAugmenter.js.map
