'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BunkerService = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _desc, _value, _class, _descriptor;

var _mobx = require('mobx');

function _initDefineProp(target, property, descriptor, context) {
  if (!descriptor) return;
  Object.defineProperty(target, property, {
    enumerable: descriptor.enumerable,
    configurable: descriptor.configurable,
    writable: descriptor.writable,
    value: descriptor.initializer ? descriptor.initializer.call(context) : void 0
  });
}

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

function _initializerWarningHelper(descriptor, context) {
  throw new Error('Decorating class property failed. Please ensure that transform-class-properties is enabled.');
}

/**
 * Abstract class used by services that need to store data in a key/value store.
 *
 * It is designed to store json objects from a rest api.
 *
 * @export
 * @class BunkerService
 */
var BunkerService = exports.BunkerService = (_class = function () {

  /**
   * Creates an instance of BunkerService.
   *
   * @param {PagerService} pagerService
   */
  function BunkerService(pagerService) {
    _classCallCheck(this, BunkerService);

    _initDefineProp(this, '_data', _descriptor, this);

    this.pagerService = pagerService;
  }

  /**
   * Extracts the key to store the data under out of the object
   *
   * Default impl uses the self href link in BlueOcean objects.
   *
   * @param {object} data Data to be stored once it has been passed through
   *                      [@link bunkerMapper]
   * @returns {any} The key for the store.
   */


  _createClass(BunkerService, [{
    key: 'bunkerKey',
    value: function bunkerKey(data) {
      return data._links.self.href;
    }

    /**
     * Maps the data from the source into what needs to be stored.
     *
     * Default impl is identity.
     *
     * @param {object} data Raw data from external source.
     * @returns {object} Modified data object.
     */

  }, {
    key: 'bunkerMapper',
    value: function bunkerMapper(data) {
      return data;
    }

    /**
     * Helper function that will make all pagers using this bunker refetch the data
     * they are displaying. Useful if sorting changes (for example a new item is added).
     */

  }, {
    key: 'refreshPagers',
    value: function refreshPagers() {
      this.pagerService.refresh(this);
    }

    /**
     * Sets an item in the store.
     *
     * It uses the [@link bunkerKey] and [@link bunkerMapper] to generate the key/value
     * to be stored.
     *
     * @param {Object} item Raw data from external source.
     * @returns {Object} item mapped by [@link bunkerMapper]. It is also a mobx computed value.
     */

  }, {
    key: 'setItem',
    value: function setItem(item) {
      var mappedItem = (0, _mobx.observable)(this.bunkerMapper(item));
      var keyItem = this.bunkerKey(mappedItem);
      this._data.set(keyItem, mappedItem);
      return this.getItem(keyItem);
    }

    /**
     * Sets an array on item in the store. Calls [@link setItem] for even item in array.
     *
     * @param {Object[]} items Array of items to set.
     * @returns {Object[]} Array of mobx computed values from store.
     */

  }, {
    key: 'setItems',
    value: function setItems(items) {
      var _this = this;

      return items.map(function (item) {
        return _this.setItem(item);
      });
    }

    /**
     * Gets item from store.
     *
     * @param {any} key Key of item in store.
     * @returns {Object} Mobx computed value of value in store.
     */

  }, {
    key: 'getItem',
    value: function getItem(key) {
      var _this2 = this;

      return (0, _mobx.computed)(function () {
        return _this2._data.get(key);
      }).get();
    }

    /**
     * Removes item from store.
     *
     * @param {any} key Key of item in store.
     */

  }, {
    key: 'removeItem',
    value: function removeItem(key) {
      this._data.delete(key);
    }

    /**
     * Tests to see if item exists in store.
     *
     * @param {any} key Key of item in store.
     * @returns {boolean} true if item exists in store.
     */

  }, {
    key: 'hasItem',
    value: function hasItem(key) {
      return this._data.has(key);
    }
  }]);

  return BunkerService;
}(), (_descriptor = _applyDecoratedDescriptor(_class.prototype, '_data', [_mobx.observable], {
  enumerable: true,
  initializer: function initializer() {
    return (0, _mobx.asMap)();
  }
}), _applyDecoratedDescriptor(_class.prototype, 'setItem', [_mobx.action], Object.getOwnPropertyDescriptor(_class.prototype, 'setItem'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'removeItem', [_mobx.action], Object.getOwnPropertyDescriptor(_class.prototype, 'removeItem'), _class.prototype)), _class);
//# sourceMappingURL=BunkerService.js.map
