'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

exports.stopProp = stopProp;


/**
 * Trims duplicate forward slashes to a single slash and adds trailing slash if needed.
 * @param url
 * @returns {string}
 */
function cleanSlashes(url) {
    var baseUrl = '';
    var urlParams = '';

    if (url && url.indexOf('?') > -1) {
        baseUrl = url.split('?').slice(0, 1).join('');
        urlParams = url.split('?').slice(-1).join('');
    } else {
        baseUrl = url;
    }

    // replace any number of consecutive slashes with one slash
    baseUrl = baseUrl.replace(/\/\/+/g, '/');

    if (baseUrl.substr(-1) !== '/') {
        baseUrl = baseUrl + '/';
    }

    return !urlParams ? baseUrl : baseUrl + '?' + urlParams;
}

/**
 * Generate a "unique" ID with an optional prefix
 * @param prefix
 * @returns {string}
 */
function randomId() {
    var prefix = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'id';

    var integer = Math.round(Math.random() * Number.MAX_SAFE_INTEGER);
    return prefix + '-' + integer;
}

/**
 * Swallow an event, preventing it from reaching containing react components or default DOM behaviour
 * @param event
 */
function stopProp(event) {
    event.stopPropagation(); // Keeps event from containing elements' onClick handlers
    event.preventDefault(); // Keeps event from triggering DOM builtins such as <a> elements
}

var Utils = exports.Utils = {
    stopProp: stopProp,
    cleanSlashes: cleanSlashes,
    randomId: randomId,
    clone: function clone(obj) {
        if (!obj) return obj;
        return JSON.parse(JSON.stringify(obj));
    },
    windowOrGlobal: function windowOrGlobal() {
        return (typeof self === 'undefined' ? 'undefined' : _typeof(self)) === 'object' && self.self === self && self || (typeof global === 'undefined' ? 'undefined' : _typeof(global)) === 'object' && global.global === global && global || this;
    },
    refreshPage: function refreshPage() {
        if (this.windowOrGlobal().location.reload) {
            this.windowOrGlobal().location.reload(true);
        }
    }
};
//# sourceMappingURL=utils.js.map
