'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.ShowMoreButton = undefined;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _i18n = require('../i18n/i18n');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var translate = (0, _i18n.i18nTranslator)('blueocean-web');

var buttonText = function buttonText(pager) {
    if (pager.pending) {
        return translate('common.pager.loading', { defaultValue: 'Loading...' });
    }

    return translate('common.pager.more', { defaultValue: 'Show more' });
};

var ShowMoreButton = exports.ShowMoreButton = function ShowMoreButton(props) {
    var pager = props.pager;

    if (!pager || !pager.hasMore) {
        return null;
    }
    return _react2.default.createElement(
        'button',
        { className: 'btn-show-more btn-secondary', onClick: function onClick() {
                return pager.fetchNextPage();
            } },
        buttonText(pager)
    );
};

ShowMoreButton.propTypes = {
    pager: _react.PropTypes.object
};
//# sourceMappingURL=ShowMoreButton.js.map
