"use strict";
/**
 * Created by cmeyers on 8/18/16.
 */
Object.defineProperty(exports, "__esModule", { value: true });
var fetch_1 = require("./fetch");
var sse = require("@jenkins-cd/sse-gateway");
var RunApi_1 = require("./rest/RunApi");
var DisableJobApi_1 = require("./rest/DisableJobApi");
var SseBus_1 = require("./sse/SseBus");
var ToastService_1 = require("./ToastService");
var AnalyticsService_1 = require("./analytics/AnalyticsService");
// export i18n provider
var i18n_1 = require("./i18n/i18n");
exports.i18nTranslator = i18n_1.i18nTranslator;
exports.defaultLngDetector = i18n_1.defaultLngDetector;
var logging_1 = require("./logging");
exports.logging = logging_1.logging;
var LoadingIndicator_1 = require("./LoadingIndicator");
exports.loadingIndicator = LoadingIndicator_1.loadingIndicator;
var fetch_2 = require("./fetch");
exports.Fetch = fetch_2.Fetch;
exports.FetchFunctions = fetch_2.FetchFunctions;
var UrlBuilder = require("./UrlBuilder");
exports.UrlBuilder = UrlBuilder;
var urlconfig_1 = require("./urlconfig");
exports.UrlConfig = urlconfig_1.UrlConfig;
var jwt_1 = require("./jwt");
exports.JWT = jwt_1.JWT;
var testutils_1 = require("./testutils");
exports.TestUtils = testutils_1.TestUtils;
var ToastUtils_1 = require("./ToastUtils");
exports.ToastUtils = ToastUtils_1.ToastUtils;
var utils_1 = require("./utils");
exports.Utils = utils_1.Utils;
var User_1 = require("./User");
exports.User = User_1.User;
var config_1 = require("./config");
exports.AppConfig = config_1.AppConfig;
var security_1 = require("./security");
exports.Security = security_1.Security;
var index_1 = require("./paths/index");
exports.Paths = index_1.Paths;
var index_2 = require("./services/index");
exports.Pager = index_2.Pager;
exports.PagerService = index_2.PagerService;
exports.PipelineService = index_2.PipelineService;
exports.SSEService = index_2.SSEService;
exports.ActivityService = index_2.ActivityService;
var stringUtil = require("./stringUtil");
exports.StringUtil = stringUtil;
var Fullscreen_1 = require("./Fullscreen");
exports.Fullscreen = Fullscreen_1.Fullscreen;
var NotFound_1 = require("./NotFound");
exports.NotFound = NotFound_1.NotFound;
var ShowMoreButton_1 = require("./components/ShowMoreButton");
exports.ShowMoreButton = ShowMoreButton_1.ShowMoreButton;
var ReplayButton_1 = require("./components/ReplayButton");
exports.ReplayButton = ReplayButton_1.ReplayButton;
var LoginButton_1 = require("./components/LoginButton");
exports.LoginButton = LoginButton_1.LoginButton;
var RunButton_1 = require("./components/RunButton");
exports.RunButtonBase = RunButton_1.RunButton;
var parameter_1 = require("./parameter");
exports.RunButton = parameter_1.ParametersRunButton;
exports.ParameterService = parameter_1.ParameterService;
exports.ParameterApi = parameter_1.ParameterApi;
exports.Boolean = parameter_1.Boolean;
exports.Choice = parameter_1.Choice;
exports.String = parameter_1.String;
exports.Text = parameter_1.Text;
exports.Password = parameter_1.Password;
exports.supportedInputTypesMapping = parameter_1.supportedInputTypesMapping;
exports.ParametersRender = parameter_1.ParametersRender;
var DisablePipelineButton_1 = require("./components/DisablePipelineButton");
exports.DisablePipelineButton = DisablePipelineButton_1.DisablePipelineButton;
var BlueLogo_1 = require("./components/BlueLogo");
exports.BlueLogo = BlueLogo_1.BlueLogo;
var ContentPageHeader_1 = require("./components/ContentPageHeader");
exports.ContentPageHeader = ContentPageHeader_1.ContentPageHeader;
exports.SiteHeader = ContentPageHeader_1.SiteHeader;
var ResultPageHeader_1 = require("./components/ResultPageHeader");
exports.ResultPageHeader = ResultPageHeader_1.ResultPageHeader;
window.JenkinsBlueOceanCoreJSSSEConnected = false;
// Create and export the SSE connection that will be shared by other
// Blue Ocean components via this package.
exports.sseConnection = sse.connect('jenkins-blueocean-core-js', function () {
    // Declare SSE is fully loaded and ready for events.
    // Mostly used by our ATH to prevent actions from happening
    // too quickly
    window.JenkinsBlueOceanCoreJSSSEConnected = true;
});
// export services as a singleton so all plugins will use the same instance
// capabilities
var index_3 = require("./capability/index");
exports.capable = index_3.capable;
exports.capabilityStore = index_3.capabilityStore;
exports.capabilityAugmenter = index_3.capabilityAugmenter;
// limit to single instance so that duplicate REST calls aren't made as events come in
var sseBus = new SseBus_1.SseBus(exports.sseConnection, fetch_1.Fetch.fetchJSON);
exports.SseBus = sseBus;
// required so new toasts are routed to the instance used in blueocean-web
var toastService = new ToastService_1.ToastService();
exports.ToastService = toastService;
var runApi = new RunApi_1.RunApi();
exports.RunApi = runApi;
var disableJobApi = new DisableJobApi_1.DisableJobApi();
exports.DisableJobApi = disableJobApi;
var BunkerService_1 = require("./services/BunkerService");
exports.BunkerService = BunkerService_1.BunkerService;
exports.pagerService = new index_2.PagerService();
exports.sseService = new index_2.SSEService(exports.sseConnection);
exports.activityService = new index_2.ActivityService(exports.pagerService);
exports.pipelineService = new index_2.PipelineService(exports.pagerService, exports.activityService);
exports.locationService = new index_2.LocationService();
exports.analyticsService = new AnalyticsService_1.AnalyticsService();
var defaultSSEhandler = new index_2.DefaultSSEHandler(exports.pipelineService, exports.activityService, exports.pagerService);
exports.sseService.registerHandler(defaultSSEhandler.handleEvents);
// Export some debugging stuff client code may need
var i18n_2 = require("./i18n/i18n");
var bundle_startup_1 = require("./i18n/bundle-startup");
exports.i18nBundleStartup = bundle_startup_1.execute;
exports.DEBUG = {
    enableMocksForI18n: i18n_2.enableMocksForI18n,
    disableMocksForI18n: i18n_2.disableMocksForI18n,
};
var TimeManager_1 = require("./utils/TimeManager");
exports.TimeManager = TimeManager_1.TimeManager;
var TimeHarmonizer_1 = require("./components/TimeHarmonizer");
exports.TimeHarmonizer = TimeHarmonizer_1.TimeHarmonizer;
exports.TimeHarmonizerUtil = TimeHarmonizer_1.TimeHarmonizerUtil;
var LiveStatusIndicator_1 = require("./components/LiveStatusIndicator");
exports.LiveStatusIndicator = LiveStatusIndicator_1.LiveStatusIndicator;
var UrlUtils_1 = require("./utils/UrlUtils");
exports.UrlUtils = UrlUtils_1.UrlUtils;
var Model_1 = require("./Model");
exports.Model = Model_1.Model;
