'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.ParameterApi = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _ = require('../..');

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * Generic options needed for all requests
 * @type {{credentials: string, method: string, headers: {Content-Type: string}}}
 */
var fetchOptionsCommon = {
    credentials: 'include',
    method: 'POST',
    headers: {
        'Content-Type': 'application/json'
    }
};
/**
 * Helper method to clone and prepare the body if attached
 * @param body - JSON object that we want to sent to the server
 * @returns {*} fetchOptions
 */
function prepareOptions(body) {
    var fetchOptions = Object.assign({}, fetchOptionsCommon);
    if (body) {
        try {
            fetchOptions.body = JSON.stringify(body);
        } catch (e) {
            console.warn('The form body are not added. Could not extract data from the body element', body);
        }
    }
    return fetchOptions;
}

var ParameterApi = exports.ParameterApi = function () {
    function ParameterApi() {
        _classCallCheck(this, ParameterApi);
    }

    _createClass(ParameterApi, [{
        key: 'startRunWithParameters',

        /**
         * Start a run with parameters
         * @param href - the destination (ends normally with /runs/)
         * @param parameters - the parameters we want to submit
         * @returns {*} Promise
         */
        value: function startRunWithParameters(href, parameters) {
            var fetchOptions = prepareOptions({ parameters: parameters });
            return _.Fetch.fetchJSON(href, { fetchOptions: fetchOptions });
        }

        /**
         * Submit an InputStep form
         * @param href - the destination (the step href)
         * @param id - unique id of the input step we submit to
         * @param parameters - the parameters we want to submit
         * @returns {*} Promise
         */

    }, {
        key: 'submitInputParameter',
        value: function submitInputParameter(href, id, parameters) {
            var fetchOptions = prepareOptions({ id: id, parameters: parameters });
            return _.Fetch.fetchJSON(href, { fetchOptions: fetchOptions });
        }

        /**
         * Cancel an InputStep form
         * @param href - the destination (the step href)
         * @param id - unique id of the input step we want to cancel
         * @returns {*} Promise
         */

    }, {
        key: 'cancelInputParameter',
        value: function cancelInputParameter(href, id) {
            var fetchOptions = prepareOptions();
            fetchOptions.body = JSON.stringify({ id: id, abort: true });
            return _.Fetch.fetchJSON(href, { fetchOptions: fetchOptions });
        }
    }]);

    return ParameterApi;
}();
//# sourceMappingURL=ParameterApi.js.map
