'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Pager = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _desc, _value, _class, _descriptor, _descriptor2, _descriptor3, _descriptor4, _descriptor5;

exports.paginateUrl = paginateUrl;

var _mobx = require('mobx');

var _fetch = require('../fetch');

function _initDefineProp(target, property, descriptor, context) {
    if (!descriptor) return;
    Object.defineProperty(target, property, {
        enumerable: descriptor.enumerable,
        configurable: descriptor.configurable,
        writable: descriptor.writable,
        value: descriptor.initializer ? descriptor.initializer.call(context) : void 0
    });
}

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
    var desc = {};
    Object['ke' + 'ys'](descriptor).forEach(function (key) {
        desc[key] = descriptor[key];
    });
    desc.enumerable = !!desc.enumerable;
    desc.configurable = !!desc.configurable;

    if ('value' in desc || desc.initializer) {
        desc.writable = true;
    }

    desc = decorators.slice().reverse().reduce(function (desc, decorator) {
        return decorator(target, property, desc) || desc;
    }, desc);

    if (context && desc.initializer !== void 0) {
        desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
        desc.initializer = undefined;
    }

    if (desc.initializer === void 0) {
        Object['define' + 'Property'](target, property, desc);
        desc = null;
    }

    return desc;
}

function _initializerWarningHelper(descriptor, context) {
    throw new Error('Decorating class property failed. Please ensure that transform-class-properties is enabled.');
}

/**
 * Provide a pagination function for the generic
 * blueocean pagination
 *
 * @export
 * @param {string} url - Base url to paginate.
 * @returns {function} - Function that provides paginated urls.
 */
function paginateUrl(url) {
    var sep = url.indexOf('?') >= 0 ? '&' : '?';
    return function (start, limit) {
        return '' + url + sep + 'start=' + start + '&limit=' + limit;
    };
}

/**
 * The pager fetches pages of data from the BlueOcean api. It fetches pages of data, then
 * inserts them into the [@link BunkerService], and stores the href from the data.
 *
 * MobX computes a data field from the hrefs backed by the backend cache. This allows for SSE events
 * to be propagated to the pager.
 *
 * @export
 * @class Pager
 */
var Pager = exports.Pager = (_class = function () {
    _createClass(Pager, [{
        key: 'data',


        /**
         * Mobx computed value that creates an array of objects from the list of hrefs stored. If either the
         * bunker changes, or the hrefs change, this is recalculated and will trigger a react reaction.
         *
         * If item does not exist in bunker, then we just ignore it.
         * @readonly
         * @type {Array<Object>}
         */

        /**
         * The latest page the pager has fetched.
         */

        /**
         * pager is fetching data.
         */
        get: function get() {
            var _this = this;

            return this.hrefs.map(function (href) {
                return _this.bunker.getItem(href);
            }).filter(function (item) {
                return item !== undefined;
            });
        }
        /**
         * Creates an instance of Pager and fetches the first page.
         *
         * @param {string} url - Base url of collection to fetch
         * @param {number} pageSize - Page size to fetch during one load.
         * @param {BunkerService} bunker - Data store
         * @param {UrlProvider} [urlProvider=paginateUrl]
         */

        /**
         * More pages to fetch.
         */

        /**
         * Will be set in an error occurs.
         */

    }]);

    function Pager(url, pageSize, bunker) {
        var urlProvider = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : paginateUrl;

        _classCallCheck(this, Pager);

        _initDefineProp(this, 'hrefs', _descriptor, this);

        _initDefineProp(this, 'pending', _descriptor2, this);

        _initDefineProp(this, 'error', _descriptor3, this);

        _initDefineProp(this, 'currentPage', _descriptor4, this);

        _initDefineProp(this, 'hasMore', _descriptor5, this);

        this.pageSize = pageSize;
        this.url = url;
        this.urlProvider = urlProvider;
        this.pagedUrl = this.urlProvider(url);
        this.pageSize = pageSize;
        this.bunker = bunker;

        // Fetch the first page so that the user does not have to.
        this.fetchNextPage();
    }

    /**
     * Fetches the next page from the backend.
     *
     * @returns {Promise}
     */


    _createClass(Pager, [{
        key: 'fetchNextPage',
        value: function fetchNextPage() {
            var _this2 = this;

            // Get the next page's url.'
            var url = this.pagedUrl(this.currentPage * this.pageSize, this.pageSize + 1);

            this.pending = true;

            return _fetch.Fetch.fetchJSON(url).then((0, _mobx.action)('Process pager data', function (data) {
                // Store item in bunker.
                var saved = _this2.bunker.setItems(data);

                // 1 extra item is fetched because need to know if there are more packages. So
                // slice off the last item, then map all items to just be hrefs.
                var trimmedHrefs = saved.slice(0, _this2.pageSize).map(function (item) {
                    return item._links.self.href;
                });

                // Append the new Hrefs to the existing ones.
                _this2.hrefs = _this2.hrefs.concat(trimmedHrefs);

                // True if we fetch more items than the page size.
                _this2.hasMore = data.length > _this2.pageSize;
                _this2.currentPage = _this2.currentPage + 1;
                _this2.pending = false;
            })).catch(function (err) {
                console.error('Error fetching page', err);
                (0, _mobx.action)('set error', function () {
                    _this2.error = err;
                });
            });
        }

        /**
         * Refreshes the Hrefs for the pager. It also stores the latest data in the [@link BunkerService]
         *
         * This might be called if something like sorting of a list changes.
         *
         * @returns {Promise}
         */

    }, {
        key: 'refresh',
        value: function refresh() {
            var _this3 = this;

            var url = this.pagedUrl(0, this.currentPage * this.pageSize + 1);
            this.pending = true;
            return _fetch.Fetch.fetchJSON(url) // Fetch data
            .then((0, _mobx.action)('set data', function (data) {
                _this3.bunker.setItems(data);
                _this3.hrefs = data.slice(0, _this3.pageSize).map(function (x) {
                    return x._links.self.href;
                });
                _this3.hasMore = data.length > _this3.pageSize;
                _this3.currentPage = _this3.currentPage + 1;
                _this3.pending = false;
            })).catch(function (err) {
                console.error('Error fetching page', err);
                _this3.err = err;
            });
        }

        /**
         * Inserts an href into the list. This will cause a reaction render for the paged list of data.
         *
         * @param {string} href - href of item to display
         * @param {number} [pos=0] - Position to insert it. Default is first item.
         */

    }, {
        key: 'insert',
        value: function insert(href) {
            var pos = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;

            this.hrefs.splice(pos, 0, href);
        }

        /**
         * Removes an href into the list. This will cause a reaction render for the paged list of data.
         *
         * @param {string} href - href of item to remove
         */

    }, {
        key: 'remove',
        value: function remove(href) {
            var idx = this.hrefs.indexOf(href);
            this.hrefs.splice(idx, 1);
        }

        /**
         * Href exists in pager.
         *
         * @param {string} href
         * @returns {boolean} - True if this pager does have this href
         */

    }, {
        key: 'has',
        value: function has(href) {
            return this.hrefs.indexOf(href) > -1;
        }
    }]);

    return Pager;
}(), (_descriptor = _applyDecoratedDescriptor(_class.prototype, 'hrefs', [_mobx.observable], {
    enumerable: true,
    initializer: function initializer() {
        return [];
    }
}), _descriptor2 = _applyDecoratedDescriptor(_class.prototype, 'pending', [_mobx.observable], {
    enumerable: true,
    initializer: function initializer() {
        return false;
    }
}), _descriptor3 = _applyDecoratedDescriptor(_class.prototype, 'error', [_mobx.observable], {
    enumerable: true,
    initializer: function initializer() {
        return null;
    }
}), _descriptor4 = _applyDecoratedDescriptor(_class.prototype, 'currentPage', [_mobx.observable], {
    enumerable: true,
    initializer: function initializer() {
        return 0;
    }
}), _descriptor5 = _applyDecoratedDescriptor(_class.prototype, 'hasMore', [_mobx.observable], {
    enumerable: true,
    initializer: function initializer() {
        return true;
    }
}), _applyDecoratedDescriptor(_class.prototype, 'data', [_mobx.computed], Object.getOwnPropertyDescriptor(_class.prototype, 'data'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'fetchNextPage', [_mobx.action], Object.getOwnPropertyDescriptor(_class.prototype, 'fetchNextPage'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'refresh', [_mobx.action], Object.getOwnPropertyDescriptor(_class.prototype, 'refresh'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'insert', [_mobx.action], Object.getOwnPropertyDescriptor(_class.prototype, 'insert'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'remove', [_mobx.action], Object.getOwnPropertyDescriptor(_class.prototype, 'remove'), _class.prototype)), _class);
//# sourceMappingURL=Pager.js.map
