"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * This service manages the various instances of pagers that currently exist.
 *
 * TODO: Currently a new pager is created for any new list of items to be paged. Cleanup may be
 * required to stop memory leaks. However Pagers don't store more data so this may not be an issue.'
 *
 * @export
 * @class PagerService
 */
var PagerService = exports.PagerService = function () {
    function PagerService() {
        _classCallCheck(this, PagerService);

        this._pagerMap = new Map();
    }
    /**
     * MobX map to hold [@link Pager]'s'
     */


    _createClass(PagerService, [{
        key: "registerPager",


        /**
         * Registers a pager with the PagerService.
         *
         * Namespacing strings is prefered to stop collisions. E.g. Activity/$org-$pipeline.
         *
         * @param {any} key - Key to register the pager under.
         * @param {Pager} pager - pager to register.
         */
        value: function registerPager(key, pager) {
            if (this._pagerMap.has(key)) {
                throw new Error("Pager '" + key + "' already exits in PagerService");
            }
            this._pagerMap.set(key, pager);
        }

        /**
         * Removes pager from the cache.
         *
         * @param {any} key
         */

    }, {
        key: "removePager",
        value: function removePager(key) {
            if (this._pagerMap.has(key)) {
                this._pagerMap.delete(key);
            }
        }

        /**
         * Lazily creates a pager. Do this because pager fetches the first page when it is created.
         *
         * @callback lazyPager
         * @returns {Pager}
         */
        /**
         * Gets a pager from the cache.
         *
         * @param {Object} options
         * @param {any} options.key - Key to store pager under.
         * @param {lazyPager} options.lazyPager - function to lazily crete the pager.
         * @returns {Pager}
         */

    }, {
        key: "getPager",
        value: function getPager(_ref) {
            var key = _ref.key,
                lazyPager = _ref.lazyPager;

            if (this._pagerMap.has(key)) {
                return this._pagerMap.get(key);
            }
            if (lazyPager) {
                var pager = lazyPager();
                this.registerPager(key, pager);
                return pager;
            }

            return null;
        }

        /**
         * Refetches the list of items the pagers that use a specific [@link BunkerService] to display.
         * This is done in the case of reordering.
         *
         * TODO: Make this more targetted.
         *
         * @param {BunkerService} bunkerService A service that extends [@link BunkerService]
         */

    }, {
        key: "refresh",
        value: function refresh(bunkerService) {
            this._pagerMap.forEach(function (pager) {
                if (bunkerService === pager.bunker) {
                    pager.refresh();
                }
            });
        }

        /**
         * Gets all pagers for a [@link BunkerService]
         *
         * @param {BunkerService} bunker
         * @returns {Pager[]}
         */

    }, {
        key: "getPagers",
        value: function getPagers(bunker) {
            var ret = [];
            this._pagerMap.forEach(function (pager) {
                if (bunker === pager.bunker) {
                    ret.push(bunker);
                }
            });

            return ret;
        }
    }]);

    return PagerService;
}();
//# sourceMappingURL=PagerService.js.map
