'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.TimeManager = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _moment = require('moment');

var _moment2 = _interopRequireDefault(_moment);

require('moment-duration-format');

var _logging = require('../logging');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var logger = _logging.logging.logger('io.jenkins.blueocean.dashboard.harmonizeTimes');
/**
 * we need to make sure that we calculate with the correct time offset
 *
 * @param run
 * @param skewMillis
 * @returns {{ durationInMillis: diff, endTime: Date, startTime: Date}}
 */

var TimeManager = exports.TimeManager = function () {
    function TimeManager() {
        _classCallCheck(this, TimeManager);
    }

    _createClass(TimeManager, [{
        key: 'currentTime',
        value: function currentTime() {
            return (0, _moment2.default)();
        }
    }, {
        key: 'format',
        value: function format(millis, hintFormat) {
            return _moment2.default.duration(millis).format(hintFormat);
        }

        /**
         *
         * @param props
         * @param skewMillis
         * @returns {
                durationInMillis,
                endTime,
                startTime,
            }
         */

    }, {
        key: 'harmonizeTimes',
        value: function harmonizeTimes(props) {
            var skewMillis = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;

            logger.debug('skewMillis', skewMillis);
            var localStartTime = props.startTime;
            // What time is it now on the client

            var clientTime = this.currentTime();
            // what is the start time of the server
            var serverStartTime = (0, _moment2.default)(!localStartTime ? this.currentTime() : localStartTime);
            // sync server start date to local time via the skewMillis
            if (skewMillis < 0) {
                serverStartTime.add({ milliseconds: Math.abs(skewMillis) });
            } else {
                serverStartTime.subtract({ milliseconds: skewMillis });
            }
            // export the harmonized start time
            var startTime = serverStartTime.toJSON();
            // how long has passed from the start to now in milliseconds
            var timeElapsed = clientTime.diff(serverStartTime, 'milliseconds');
            // assume we do not have an end date
            var endTime = null;
            var durationInMillis = 0;
            if (props.endTime) {
                // sync server end date to local time via the skewMillis
                var serverEndTime = (0, _moment2.default)(props.endTime);
                if (skewMillis < 0) {
                    serverEndTime.add({ milliseconds: Math.abs(skewMillis) });
                } else {
                    serverEndTime.subtract({ milliseconds: skewMillis });
                }
                endTime = serverEndTime.toJSON();
            }
            if (props.endTime || !props.isRunning) {
                // sync server end date to local time via the skewMillis
                durationInMillis = props.durationInMillis;
            } else {
                logger.debug('running, using timeElapsed for duration');
                durationInMillis = Math.abs(timeElapsed);
            }
            logger.debug('durationInMillis:', durationInMillis);
            var harmonized = {
                durationInMillis: durationInMillis,
                endTime: endTime,
                startTime: startTime
            };
            logger.debug('returning', harmonized);
            return harmonized;
        }
    }]);

    return TimeManager;
}();
//# sourceMappingURL=TimeManager.js.map
