/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.auth.jwt.impl;

import hudson.Extension;
import hudson.init.Initializer;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.util.PluginServletFilter;
import io.jenkins.blueocean.auth.jwt.JwtTokenVerifier;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.Stapler;
import org.springframework.security.core.Authentication;

@Extension
public class JwtAuthenticationFilter
implements Filter {
    private static final String JWT_TOKEN_VALIDATED = JwtAuthenticationFilter.class.getName() + ".validated";
    private boolean isJwtEnabled;

    @Initializer(fatal=false)
    public static void init() throws ServletException {
        PluginServletFilter.addFilter((Filter)new JwtAuthenticationFilter());
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.isJwtEnabled = Boolean.getBoolean("BLUEOCEAN_FEATURE_JWT_AUTHENTICATION");
    }

    public void doFilter(ServletRequest req, ServletResponse rsp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        if (!this.shouldApply(request)) {
            chain.doFilter(req, rsp);
            return;
        }
        Authentication token = this.verifyToken(request);
        if (token == null) {
            chain.doFilter(req, rsp);
            return;
        }
        try (ACLContext ctx = ACL.as2((Authentication)token);){
            request.setAttribute(JWT_TOKEN_VALIDATED, (Object)true);
            chain.doFilter(req, rsp);
        }
    }

    private Authentication verifyToken(HttpServletRequest request) {
        for (JwtTokenVerifier verifier : JwtTokenVerifier.all()) {
            Authentication token = verifier.verify(request);
            if (token == null) continue;
            return token;
        }
        return null;
    }

    protected boolean shouldApply(HttpServletRequest req) {
        if (!this.isJwtEnabled) {
            return false;
        }
        String path = req.getRequestURI().substring(req.getContextPath().length());
        if (!StringUtils.isBlank((String)path)) {
            path = path.replaceAll("//+", "/");
        }
        return path.startsWith("/blue/") || path.startsWith("/sse-gateway/");
    }

    public void destroy() {
    }

    public static boolean didRequestHaveValidatedJwtToken() {
        return Boolean.TRUE.equals(Stapler.getCurrentRequest().getAttribute(JWT_TOKEN_VALIDATED));
    }
}

