/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean;

import hudson.util.PluginServletFilter;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public final class ResourceCacheControl
implements Filter {
    private static ResourceCacheControl INSTANCE;
    private final List<String> resourcePrefixes = new ArrayList<String>();

    ResourceCacheControl() {
    }

    String addPath(String path) {
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        this.resourcePrefixes.add((String)path);
        return path;
    }

    public static synchronized void install() {
        if (INSTANCE != null) {
            return;
        }
        INSTANCE = new ResourceCacheControl();
        if (!Boolean.getBoolean("hudson.hpi.run")) {
            try {
                INSTANCE.addPath(Jenkins.RESOURCE_PATH);
                INSTANCE.addPath(Jenkins.get().getAdjuncts((String)"").rootURL);
                PluginServletFilter.addFilter((Filter)INSTANCE);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unexpected Exception installing Blue Web Resource Adjunct cache control filter.", e);
            }
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && this.isCacheableResourceRequest((HttpServletRequest)request)) {
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
            httpServletResponse.setHeader("Cache-Control", "public, max-age=31536000");
            response = new HttpServletResponseWrapper(httpServletResponse){

                public void setHeader(String name, String value) {
                    if (!name.equalsIgnoreCase("Expires")) {
                        super.setHeader(name, value);
                    }
                }
            };
        }
        chain.doFilter(request, response);
    }

    boolean isCacheableResourceRequest(HttpServletRequest request) {
        String requestPath = request.getPathInfo();
        if (requestPath == null) {
            return false;
        }
        for (String resourcePrefix : this.resourcePrefixes) {
            if (!requestPath.startsWith(resourcePrefix)) continue;
            return true;
        }
        return false;
    }

    public void destroy() {
    }
}

