'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.PlaceholderTable = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

exports.PlaceholderText = PlaceholderText;
exports.PlaceholderIcon = PlaceholderIcon;
exports.PlaceholderTextCell = PlaceholderTextCell;
exports.PlaceholderIconCell = PlaceholderIconCell;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _JTable = require('./jtable/JTable');

var _TableRow = require('./jtable/TableRow');

var _TableCell = require('./jtable/TableCell');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var PlaceholderTable = exports.PlaceholderTable = function (_React$Component) {
    _inherits(PlaceholderTable, _React$Component);

    function PlaceholderTable() {
        _classCallCheck(this, PlaceholderTable);

        return _possibleConstructorReturn(this, (PlaceholderTable.__proto__ || Object.getPrototypeOf(PlaceholderTable)).apply(this, arguments));
    }

    _createClass(PlaceholderTable, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                className = _props.className,
                columns = _props.columns,
                rowCount = _props.rowCount,
                style = _props.style;


            var tableCols = columns.map(function (col) {
                return { width: col.width, isFlexible: col.isFlexible };
            });
            var heads = columns.map(function (col) {
                return col.head;
            });
            var cells = columns.map(function (col) {
                return col.cell;
            });

            var rowIterator = new Array(rowCount).fill('');
            var classString = 'PlaceholderTable ' + className;

            return _react2.default.createElement(
                'div',
                { className: classString, style: style },
                _react2.default.createElement(
                    _JTable.JTable,
                    { columns: tableCols },
                    _react2.default.createElement(
                        _TableRow.TableRow,
                        { columns: tableCols },
                        heads.map(function (item, index) {
                            return _react2.default.createElement(
                                _TableCell.TableCell,
                                { key: 'head-' + index },
                                createPlaceholderCell(item)
                            );
                        })
                    ),
                    rowIterator.map(function (item, index) {
                        return _react2.default.createElement(
                            _TableRow.TableRow,
                            { key: 'row-' + index, columns: tableCols },
                            cells.map(function (item, index) {
                                return _react2.default.createElement(
                                    _TableCell.TableCell,
                                    { key: 'cell-' + index },
                                    createPlaceholderCell(item)
                                );
                            })
                        );
                    })
                )
            );
        }
    }]);

    return PlaceholderTable;
}(_react2.default.Component);

PlaceholderTable.defaultProps = {
    className: '',
    style: {},
    columns: [],
    rowCount: 20
};


PlaceholderTable.propTypes = {
    className: _react.PropTypes.string,
    style: _react.PropTypes.object,
    columns: _react.PropTypes.array,
    rowCount: _react.PropTypes.number
};

function PlaceholderText(props) {
    return _react2.default.createElement('div', { className: 'Placeholder-text', style: _extends({}, props.style, { width: props.size }) });
}

PlaceholderText.propTypes = {
    size: _react.PropTypes.number,
    style: _react.PropTypes.object
};

function PlaceholderIcon(props) {
    var size = props.size,
        style = props.style;

    var rad = size / 2;

    return _react2.default.createElement(
        'svg',
        { className: 'Placeholder-icon', width: size, height: size, style: style },
        _react2.default.createElement('circle', { cx: rad, cy: rad, r: rad })
    );
}

PlaceholderIcon.propTypes = {
    size: _react.PropTypes.number,
    style: _react.PropTypes.object
};

function createPlaceholderCell(item) {
    if (item && item.text) {
        return _react2.default.createElement(PlaceholderText, { size: item.text });
    } else if (item && item.icon) {
        return _react2.default.createElement(PlaceholderIcon, { size: item.icon });
    }

    return null;
}

function PlaceholderTextCell(props) {
    return _react2.default.createElement(
        _TableCell.TableCell,
        { style: props.style },
        _react2.default.createElement(PlaceholderText, { size: props.size })
    );
}

PlaceholderTextCell.propTypes = {
    style: _react.PropTypes.object,
    size: _react.PropTypes.number
};

function PlaceholderIconCell(props) {
    return _react2.default.createElement(
        _TableCell.TableCell,
        { style: props.style },
        _react2.default.createElement(PlaceholderIcon, { size: props.size })
    );
}

PlaceholderIconCell.propTypes = {
    style: _react.PropTypes.object,
    size: _react.PropTypes.number
};
//# sourceMappingURL=Placeholder.js.map
