'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.FormElement = FormElement;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _ErrorMessage = require('../ErrorMessage');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function FormElement(props) {
    if (!props.title && !props.errorMessage && !props.children) {
        return null;
    }

    var extraClass = props.className || '';
    var errorClass = props.errorMessage ? 'u-error-state' : '';
    var dividerClass = props.showDivider ? 'u-show-divider' : '';
    var layoutClass = props.verticalLayout ? 'u-layout-vertical' : '';
    var childFreeClass = !props.children ? 'u-child-free' : '';

    return _react2.default.createElement(
        'div',
        { className: 'FormElement ' + extraClass + ' ' + errorClass + ' ' + dividerClass + ' ' + layoutClass + ' ' + childFreeClass },
        (props.title || props.errorMessage) && _react2.default.createElement(
            'div',
            { className: 'FormElement-heading' },
            props.title && _react2.default.createElement(
                'label',
                { className: 'FormElement-title' },
                props.title
            ),
            props.title && props.errorMessage && _react2.default.createElement(
                'span',
                null,
                '\xA0-\xA0'
            ),
            props.errorMessage && _react2.default.createElement(
                _ErrorMessage.ErrorMessage,
                null,
                props.errorMessage
            )
        ),
        props.children && _react2.default.createElement(
            'div',
            { className: 'FormElement-children' },
            props.children
        )
    );
}

FormElement.propTypes = {
    children: _react.PropTypes.node,
    className: _react.PropTypes.string,
    title: _react.PropTypes.string,
    errorMessage: _react.PropTypes.string,
    showDivider: _react.PropTypes.bool,
    verticalLayout: _react.PropTypes.bool
};
//# sourceMappingURL=FormElement.js.map
