'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _storybook = require('@kadira/storybook');

var _Icon = require('../components/Icon');

var _blueoceanMaterialIcons = require('@jenkins-cd/blueocean-material-icons');

var IconId = _interopRequireWildcard(_blueoceanMaterialIcons);

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* eslint-disable max-len, react/self-closing-comp */

(0, _storybook.storiesOf)('Icon', module).add('all icons', AllIcons).add('vertical positioning', VerticalPositioning).add('sizing', Sizing);

var style = {
    padding: 10
};

var iconStyle = {
    fill: "#4A90E2"
};

function AllIcons() {
    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
            'div',
            { style: style },
            _react2.default.createElement(
                'h1',
                null,
                'Material-UI-Icons'
            ),
            _react2.default.createElement(
                'div',
                { style: { display: 'flex', flexFlow: 'row wrap', marginTop: '20px' } },
                Object.keys(IconId).sort().map(function (shape) {
                    return _react2.default.createElement(
                        'div',
                        { key: shape, style: { marginTop: '20px', textAlign: 'center', width: '19%' } },
                        _react2.default.createElement(_Icon.Icon, { icon: shape, style: iconStyle }),
                        _react2.default.createElement(
                            'div',
                            null,
                            shape
                        )
                    );
                })
            )
        )
    );
}

function VerticalPositioning() {
    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
            'div',
            { style: style },
            _react2.default.createElement(
                'h1',
                null,
                'Material-UI-Icons'
            ),
            _react2.default.createElement(
                'p',
                { style: { margin: '60px 0 0', fontWeight: 'bold' } },
                'Vertical Align Middle'
            ),
            _react2.default.createElement(
                'div',
                { style: { display: 'flex', flexFlow: 'row wrap' } },
                Object.keys(IconId).slice(50, 75).sort().map(function (shape) {
                    return _react2.default.createElement(
                        'div',
                        { key: shape, style: { marginTop: '20px', width: '19%' } },
                        _react2.default.createElement(_Icon.Icon, { icon: shape, style: iconStyle }),
                        _react2.default.createElement(
                            'span',
                            null,
                            ' ',
                            shape
                        )
                    );
                })
            ),
            _react2.default.createElement(
                'p',
                { style: { margin: '60px 0 0', fontWeight: 'bold' } },
                'Vertical Align Bottom'
            ),
            _react2.default.createElement(
                'div',
                { style: { display: 'flex', flexFlow: 'row wrap' } },
                Object.keys(IconId).slice(50, 75).sort().map(function (shape) {
                    return _react2.default.createElement(
                        'div',
                        { key: shape, style: { marginTop: '20px', width: '19%' } },
                        _react2.default.createElement(_Icon.Icon, { icon: shape, style: { verticalAlign: 'bottom', fill: "#4A90E2" } }),
                        _react2.default.createElement(
                            'span',
                            null,
                            ' ',
                            shape
                        )
                    );
                })
            )
        )
    );
}

var buttonRow = {
    display: 'flex', justifyContent: 'space-between', alignItems: 'center', marginBottom: 10
};

function Sizing() {
    var cellStyle = _extends({}, buttonRow, { marginBottom: 0 });

    return _react2.default.createElement(
        'div',
        { style: style },
        Object.keys(IconId).slice(50, 60).sort().map(function (shape) {
            return _react2.default.createElement(
                'div',
                { key: shape, style: buttonRow },
                _react2.default.createElement(
                    'div',
                    { className: 'layout-small', style: cellStyle },
                    'Small \xA0',
                    _react2.default.createElement(_Icon.Icon, { icon: shape, style: iconStyle, label: 'Small' })
                ),
                _react2.default.createElement(
                    'div',
                    { style: cellStyle },
                    'Medium \xA0',
                    _react2.default.createElement(_Icon.Icon, { icon: shape, style: iconStyle, label: 'Medium' })
                ),
                _react2.default.createElement(
                    'div',
                    { className: 'layout-large', style: cellStyle },
                    'Large \xA0',
                    _react2.default.createElement(_Icon.Icon, { icon: shape, style: iconStyle, label: 'Large' })
                )
            );
        })
    );
}
//# sourceMappingURL=IconStories.js.map
