'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _storybook = require('@kadira/storybook');

var _TextArea = require('../components/forms/TextArea');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(0, _storybook.storiesOf)('TextArea', module).add('general', function () {
    return _react2.default.createElement(General, null);
}).add('callbacks', function () {
    return _react2.default.createElement(Callbacks, null);
}).add('sizes', function () {
    return _react2.default.createElement(Sizes, null);
});

var style = { padding: 10 };

function General() {
    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
            'div',
            { style: style },
            _react2.default.createElement(
                'p',
                null,
                'Default'
            ),
            _react2.default.createElement(_TextArea.TextArea, null)
        ),
        _react2.default.createElement(
            'div',
            { style: style },
            _react2.default.createElement(
                'p',
                null,
                'Disabled'
            ),
            _react2.default.createElement(_TextArea.TextArea, { disabled: true })
        ),
        _react2.default.createElement(
            'div',
            { style: style },
            _react2.default.createElement(
                'p',
                null,
                'Placeholder'
            ),
            _react2.default.createElement(_TextArea.TextArea, { placeholder: 'This is a placeholder.' })
        ),
        _react2.default.createElement(
            'div',
            { style: style },
            _react2.default.createElement(
                'p',
                null,
                'Placeholder'
            ),
            _react2.default.createElement(_TextArea.TextArea, { defaultValue: 'I have a default value.' })
        )
    );
}

function Callbacks() {
    return _react2.default.createElement(
        'div',
        { style: style },
        _react2.default.createElement(_TextArea.TextArea, {
            onChange: function onChange(val) {
                return console.log('onChange', val);
            },
            onBlur: function onBlur(val) {
                return console.log('onBlur', val);
            }
        })
    );
}

function Sizes() {
    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
            'div',
            { style: style },
            _react2.default.createElement(_TextArea.TextArea, { placeholder: 'Using no layout' })
        ),
        _react2.default.createElement(
            'div',
            { className: 'layout-small', style: style },
            _react2.default.createElement(_TextArea.TextArea, { placeholder: 'Using layout-small', value: 'five\\ntotal\\nlines' })
        ),
        _react2.default.createElement(
            'div',
            { className: 'layout-medium', style: style },
            _react2.default.createElement(_TextArea.TextArea, { placeholder: 'Using layout-medium' })
        ),
        _react2.default.createElement(
            'div',
            { className: 'layout-large', style: style },
            _react2.default.createElement(_TextArea.TextArea, { placeholder: 'Using layout-large' })
        )
    );
}
//# sourceMappingURL=TextAreaStories.js.map
