'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _storybook = require('@kadira/storybook');

var _TimeDuration = require('../components/TimeDuration');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var stringsEn = {
    "common.date.duration.display.format": "M[ month] d[ days] h[ hours] m[ minutes] s[ seconds]",
    "common.date.duration.format": "m[ minutes] s[ seconds]",
    "common.date.duration.hint.format": "M [month], d [days], h[h], m[m], s[s]"
};

var stringsDe = {
    "common.date.duration.display.format": "M [mos], d [Tage], h[Std.], m[m], s[s]",
    "common.date.duration.format": "m[ Minuten] s[ Sekunden]",
    "common.date.duration.hint.format": "M [Monate], d [Tage], h[Std.], m[m], s[s]"
};

var translationsEn = function translationsEn(key) {
    return stringsEn[key] || key;
};
var translationsDe = function translationsDe(key) {
    return stringsDe[key] || key;
};

(0, _storybook.storiesOf)('TimeDuration', module).add('<1s', lessThan1s).add('short duration', standard).add('short duration - locale de', standardDe).add('live update', liveUpdate).add('live update - locale de', liveUpdateDe).add('long duration, all date parts', complexHint).add('long duration, all date parts - locale de', complexHintDe).add('with custom hint', customHint);

function lessThan1s() {
    return _react2.default.createElement(_TimeDuration.TimeDuration, { millis: 999, t: translationsEn });
}

function standard() {
    return _react2.default.createElement(_TimeDuration.TimeDuration, { millis: 50000, t: translationsEn });
}

function standardDe() {
    return _react2.default.createElement(_TimeDuration.TimeDuration, {
        millis: 50000,
        locale: 'de',
        t: translationsDe
    });
}

function liveUpdate() {
    return _react2.default.createElement(_TimeDuration.TimeDuration, { millis: 50000, liveUpdate: true, t: translationsEn });
}

function liveUpdateDe() {
    return _react2.default.createElement(_TimeDuration.TimeDuration, {
        liveUpdate: true,
        updatePeriod: 1000,
        millis: 50000,
        locale: 'de',
        t: translationsDe
    });
}

function complexHint() {
    return _react2.default.createElement(_TimeDuration.TimeDuration, { millis: 1000 * 60 * 60 * 24 * 7 * 4 * 6 + 1001 * 60 * 60 * 4.75, t: translationsEn });
}

function complexHintDe() {
    return _react2.default.createElement(_TimeDuration.TimeDuration, {
        updatePeriod: 3000,
        millis: 3.5 * 1000 * 60 * 60 * 24 * 7 * 4 * 6 + 1001 * 60 * 60 * 4.75,
        locale: 'de',
        t: translationsDe
    });
}

function customHint() {
    return _react2.default.createElement(_TimeDuration.TimeDuration, { millis: 50000, hint: 'Custom hint.', t: translationsEn });
}
//# sourceMappingURL=timeduration.js.map
