'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _storybook = require('@kadira/storybook');

var _ReadableDate = require('../components/ReadableDate');

var _moment = require('moment');

var _moment2 = _interopRequireDefault(_moment);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(0, _storybook.storiesOf)('ReadableDate', module).add('Mixed', scenario2).add('standard, distant', scenario1).add('bad data', scenario3);

function scenario1() {
    return _react2.default.createElement(_ReadableDate.ReadableDate, { date: '2015-05-24T08:57:06.406+0000' });
}

function scenario2() {
    var aMoment = (0, _moment2.default)();
    var date1 = aMoment.toISOString();

    aMoment = (0, _moment2.default)(aMoment).subtract(10, 'ms');
    var date2 = aMoment.toISOString();

    aMoment = (0, _moment2.default)(aMoment).subtract(20, 's');
    var date3 = aMoment.toISOString();

    aMoment = (0, _moment2.default)(aMoment).subtract(5, 'm');
    var date4 = aMoment.toISOString();

    aMoment = (0, _moment2.default)(aMoment).subtract(2, 'h');
    var date5 = aMoment.toISOString();

    aMoment = (0, _moment2.default)(aMoment).subtract(2, 'd');
    var date6 = aMoment.toISOString();

    return _react2.default.createElement(
        'table',
        null,
        _react2.default.createElement(
            'thead',
            null,
            _react2.default.createElement(
                'tr',
                null,
                _react2.default.createElement(
                    'th',
                    null,
                    'Description'
                ),
                _react2.default.createElement(
                    'th',
                    null,
                    'ISO'
                ),
                _react2.default.createElement(
                    'th',
                    null,
                    'ReadableDate'
                ),
                _react2.default.createElement(
                    'th',
                    null,
                    'ReadableDate (liveUpdate)'
                )
            )
        ),
        _react2.default.createElement(
            'tbody',
            null,
            _react2.default.createElement(
                'tr',
                null,
                _react2.default.createElement(
                    'th',
                    null,
                    'Now()'
                ),
                _react2.default.createElement(
                    'td',
                    null,
                    date1
                ),
                _react2.default.createElement(
                    'td',
                    null,
                    _react2.default.createElement(_ReadableDate.ReadableDate, { date: date1 })
                ),
                _react2.default.createElement(
                    'td',
                    null,
                    _react2.default.createElement(_ReadableDate.ReadableDate, { date: date1, liveUpdate: true })
                )
            ),
            _react2.default.createElement(
                'tr',
                null,
                _react2.default.createElement(
                    'th',
                    null,
                    '+10 ms'
                ),
                _react2.default.createElement(
                    'td',
                    null,
                    date2
                ),
                _react2.default.createElement(
                    'td',
                    null,
                    _react2.default.createElement(_ReadableDate.ReadableDate, { date: date2 })
                ),
                _react2.default.createElement(
                    'td',
                    null,
                    _react2.default.createElement(_ReadableDate.ReadableDate, { date: date2, liveUpdate: true })
                )
            ),
            _react2.default.createElement(
                'tr',
                null,
                _react2.default.createElement(
                    'th',
                    null,
                    '+20 s'
                ),
                _react2.default.createElement(
                    'td',
                    null,
                    date3
                ),
                _react2.default.createElement(
                    'td',
                    null,
                    _react2.default.createElement(_ReadableDate.ReadableDate, { date: date3 })
                ),
                _react2.default.createElement(
                    'td',
                    null,
                    _react2.default.createElement(_ReadableDate.ReadableDate, { date: date3, liveUpdate: true })
                )
            ),
            _react2.default.createElement(
                'tr',
                null,
                _react2.default.createElement(
                    'th',
                    null,
                    '+5 m'
                ),
                _react2.default.createElement(
                    'td',
                    null,
                    date4
                ),
                _react2.default.createElement(
                    'td',
                    null,
                    _react2.default.createElement(_ReadableDate.ReadableDate, { date: date4 })
                ),
                _react2.default.createElement(
                    'td',
                    null,
                    _react2.default.createElement(_ReadableDate.ReadableDate, { date: date4, liveUpdate: true })
                )
            ),
            _react2.default.createElement(
                'tr',
                null,
                _react2.default.createElement(
                    'th',
                    null,
                    '+2 h'
                ),
                _react2.default.createElement(
                    'td',
                    null,
                    date5
                ),
                _react2.default.createElement(
                    'td',
                    null,
                    _react2.default.createElement(_ReadableDate.ReadableDate, { date: date5 })
                ),
                _react2.default.createElement(
                    'td',
                    null,
                    _react2.default.createElement(_ReadableDate.ReadableDate, { date: date5, liveUpdate: true })
                )
            ),
            _react2.default.createElement(
                'tr',
                null,
                _react2.default.createElement(
                    'th',
                    null,
                    '+2 d'
                ),
                _react2.default.createElement(
                    'td',
                    null,
                    date6
                ),
                _react2.default.createElement(
                    'td',
                    null,
                    _react2.default.createElement(_ReadableDate.ReadableDate, { date: date6 })
                ),
                _react2.default.createElement(
                    'td',
                    null,
                    _react2.default.createElement(_ReadableDate.ReadableDate, { date: date6, liveUpdate: true })
                )
            )
        )
    );
}

function scenario3() {
    return _react2.default.createElement(_ReadableDate.ReadableDate, { date: 'bad date' });
}
//# sourceMappingURL=readabledate.js.map
