'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.CommitId = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var GIT_HASH_REGEX = /\b[0-9a-f]{5,40}\b/;

/**
 * Displays a commit hash in the proper style.
 */

var CommitId = exports.CommitId = function (_Component) {
    _inherits(CommitId, _Component);

    function CommitId() {
        _classCallCheck(this, CommitId);

        return _possibleConstructorReturn(this, (CommitId.__proto__ || Object.getPrototypeOf(CommitId)).apply(this, arguments));
    }

    _createClass(CommitId, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                className = _props.className,
                commitId = _props.commitId,
                url = _props.url,
                title = _props.title;

            var displayValue = void 0;
            var classNames = ['hash'];

            if (className) {
                classNames.push(className);
            }

            if (GIT_HASH_REGEX.test(commitId)) {
                displayValue = commitId.substring(0, 7);
            } else if (commitId) {
                displayValue = commitId;
            } else {
                displayValue = '—';
            }

            if (url) {
                return _react2.default.createElement(
                    'a',
                    { href: url, target: '_blank', title: title ? title : 'Opens commit in a new window' },
                    _react2.default.createElement(
                        'code',
                        { className: classNames.join(' ') },
                        displayValue
                    )
                );
            }

            return _react2.default.createElement(
                'code',
                { className: classNames.join(' ') },
                displayValue
            );
        }
    }]);

    return CommitId;
}(_react.Component);

CommitId.propTypes = {
    className: _react.PropTypes.string,
    commitId: _react.PropTypes.string,
    url: _react.PropTypes.string,
    title: _react.PropTypes.string
};
//# sourceMappingURL=CommitId.js.map
