'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Dropdown = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _lodash = require('lodash.debounce');

var _lodash2 = _interopRequireDefault(_lodash);

var _Icon = require('../Icon');

var _FloatingElement = require('../FloatingElement');

var _KeyCodes = require('../../KeyCodes');

var _KeyCodes2 = _interopRequireDefault(_KeyCodes);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var POSITION = {
    FIRST: 'first',
    PREV: 'prev',
    NEXT: 'next',
    LAST: 'last',

    values: function values() {
        return [POSITION.FIRST, POSITION.PREV, POSITION.NEXT, POSITION.LAST];
    }
};

var Dropdown = exports.Dropdown = function (_React$Component) {
    _inherits(Dropdown, _React$Component);

    function Dropdown(props) {
        _classCallCheck(this, Dropdown);

        var _this = _possibleConstructorReturn(this, (Dropdown.__proto__ || Object.getPrototypeOf(Dropdown)).call(this, props));

        _this._onDropdownMouseEvent = function (event) {
            // console.log('_onDropdownMouseEvent');
            // prevent navigation if anchor was clicked
            event.preventDefault();
            /*
             * Some browser will fire a click event when you set focus on this element while in an another
             * event loop if those browser fire this event it will be from 0 0 hence not a real click.
             *
             * Another workaround could have been to create a timeout and set the focus after a certain time,
             * however that has the problem that the timeout can vary, leaving the whole component in a focus limbo
             */
            var clientX = event.clientX,
                clientY = event.clientY;

            if (clientY !== 0 && clientX !== 0) {
                _this._toggleDropdownMenu();
            }
        };

        _this._handleKeyEvent = function (event) {
            // console.log('_handleKeyEvent', this.state.menuOpen);
            if (!_this.state.menuOpen) {
                return;
            }

            var keyCode = event.keyCode;


            switch (keyCode) {
                case _KeyCodes2.default.TAB:
                    // tabbing while open will advance to the next element after this Dropdown
                    _this._closeDropdownMenu();
                    break;
                case _KeyCodes2.default.ESC:
                    _this._closeDropdownMenu();
                    break;
                // don't let arrow keys scroll the content; focus change will do that for us
                case _KeyCodes2.default.ARROW_DOWN:
                    event.preventDefault();
                    _this._changeFocusPosition(POSITION.NEXT);
                    break;
                case _KeyCodes2.default.ARROW_UP:
                    event.preventDefault();
                    _this._changeFocusPosition(POSITION.PREV);
                    break;
                // page/up down scrolls as normal but applies focus
                case _KeyCodes2.default.PAGE_DOWN:
                case _KeyCodes2.default.PAGE_UP:
                    _this._syncFocusAfterScroll();
                    break;
                case _KeyCodes2.default.HOME:
                    _this._changeFocusPosition(POSITION.FIRST);
                    break;
                case _KeyCodes2.default.END:
                    _this._changeFocusPosition(POSITION.LAST);
                    break;
                case _KeyCodes2.default.SPACEBAR:
                case _KeyCodes2.default.ENTER:
                    event.preventDefault();
                    _this._selectFocusedItem();
                    break;
                default:
                    break;
            }
        };

        _this._keyEvent = function (event) {
            var keyCode = event.keyCode;


            switch (keyCode) {
                case _KeyCodes2.default.SPACEBAR:
                case _KeyCodes2.default.ENTER:
                    event.preventDefault();
                    _this._toggleDropdownMenu();
                    break;
                default:
                    break;
            }
        };

        _this._handleMouseEvent = function (event) {
            // console.log("_handleMouseEvent");
            var clientX = event.clientX,
                clientY = event.clientY;


            if (_this.state.menuOpen) {
                var element = document.elementFromPoint(clientX, clientY);

                // close the dropdown only if the user clicked "outside" of it
                // (only if the button, thumb and menu was not clicked)
                // clicking those elements will actually close the it via different means
                var clickedOutsideDropdown = !_this.buttonRef.contains(element) && !_this.thumbRef.contains(element) && !_this.wrapperRef.contains(element) && !_this.menuRef.contains(element);

                if (clickedOutsideDropdown) {
                    _this._closeDropdownMenu();
                }
            }
        };

        _this._onMenuScrollEvent = function () {
            _this._syncFocusAfterScroll();
        };

        _this._syncFocusAfterScroll = (0, _lodash2.default)(function () {
            if (_this.menuRef.scrollTop === _this.lastScrollTop) {
                return;
            }

            var scrollDown = _this.menuRef.scrollTop > _this.lastScrollTop;
            _this.lastScrollTop = _this.menuRef.scrollTop;
            var rect = _this.menuRef.getBoundingClientRect();
            var nextFocusItem = scrollDown ? document.elementFromPoint(rect.left + 1, rect.top + rect.height - 2) : document.elementFromPoint(rect.left + 1, rect.top + 1);

            _this._focusListItem(nextFocusItem.parentNode);
        }, 200);


        _this.buttonRef = null;
        _this.thumbRef = null;
        _this.menuRef = null;
        _this.lastScrollTop = 0;

        _this.state = {
            menuOpen: false,
            selectedOption: null
        };
        return _this;
    }

    _createClass(Dropdown, [{
        key: 'componentWillMount',
        value: function componentWillMount() {
            this._defaultSelection(this.props);
        }
    }, {
        key: 'componentDidMount',
        value: function componentDidMount() {
            document.addEventListener('keydown', this._handleKeyEvent);
            document.addEventListener('mousedown', this._handleMouseEvent);
        }
    }, {
        key: 'componentDidUpdate',
        value: function componentDidUpdate(prevProps, prevState) {
            if (this.state.menuOpen && !prevState.menuOpen) {
                this._setInitialFocus();
            }
        }
    }, {
        key: 'componentWillUnmount',
        value: function componentWillUnmount() {
            document.removeEventListener('keydown', this._handleKeyEvent);
            document.removeEventListener('mousedown', this._handleMouseEvent);
        }
    }, {
        key: '_defaultSelection',
        value: function _defaultSelection(props) {
            if (!this.state.selectedOption && props.defaultOption) {
                this.setState({
                    selectedOption: props.defaultOption
                });
            }
        }
    }, {
        key: '_toggleDropdownMenu',
        value: function _toggleDropdownMenu() {
            if (this.state.menuOpen) {
                this._closeDropdownMenu();
            } else {
                this._openDropdownMenu();
            }
        }
    }, {
        key: '_openDropdownMenu',
        value: function _openDropdownMenu() {
            this.setState({
                menuOpen: true
            });
        }
    }, {
        key: '_closeDropdownMenu',
        value: function _closeDropdownMenu() {
            this.setState({
                menuOpen: false
            });
        }

        // (note: also triggered via spacebar press when button has focus)

    }, {
        key: '_setInitialFocus',
        value: function _setInitialFocus() {
            // console.log('_setInitialFocus');
            if (this.state.selectedOption) {
                var selectedIndex = this.props.options.indexOf(this.state.selectedOption);
                var selectedListItem = this.menuRef.children[selectedIndex];
                this._focusListItem(selectedListItem);
            } else {
                this._changeFocusPosition(POSITION.FIRST);
            }
        }
    }, {
        key: '_changeFocusPosition',
        value: function _changeFocusPosition(position) {
            if (POSITION.values().indexOf(position) === -1) {
                return;
            }

            if (position === POSITION.FIRST || !this.menuRef.contains(document.activeElement)) {
                var listItem = this.menuRef.children[0];
                this._focusListItem(listItem);
                return;
            }

            var allListItems = [].slice.call(this.menuRef.children);

            if (position === POSITION.NEXT || position === POSITION.PREV) {
                var focusedListItem = document.activeElement.parentNode;
                var focusedIndex = allListItems.indexOf(focusedListItem);
                var nextFocusIndex = focusedIndex + (position === POSITION.NEXT ? 1 : -1);

                if (0 <= nextFocusIndex && nextFocusIndex <= allListItems.length - 1) {
                    var nextListItem = allListItems[nextFocusIndex];
                    this._focusListItem(nextListItem);
                }
            } else if (position === POSITION.LAST) {
                this._focusListItem(allListItems[allListItems.length - 1]);
            }
        }
    }, {
        key: '_focusListItem',
        value: function _focusListItem(listItemNode) {
            var _this2 = this;

            // console.log('_focusListItem', listItemNode);
            if (this.menuRef.contains(listItemNode)) {
                // need to delay ~1 frame for the focus and scroll to be reliable
                setTimeout(function () {
                    listItemNode.children[0].focus();

                    var listItemRect = listItemNode.getBoundingClientRect();
                    var menuRect = _this2.menuRef.getBoundingClientRect();

                    // make the focused item "stick" to top or bottom edge
                    if (listItemRect.top < menuRect.top) {
                        _this2.menuRef.scrollTop = listItemNode.offsetTop;
                    } else if (listItemRect.bottom > menuRect.bottom) {
                        _this2.menuRef.scrollTop += listItemRect.bottom - menuRect.bottom;
                    }
                }, 1000 / 60);
            }
        }

        /**
         * Updates the dropdown's state such that its selectedOption corresponds to the item which currently has focus.
         * @private
         */

    }, {
        key: '_selectFocusedItem',
        value: function _selectFocusedItem() {
            if (this.menuRef.contains(document.activeElement)) {
                var allListItems = [].slice.call(this.menuRef.children);
                var focusedListItem = document.activeElement.parentNode;
                var focusedIndex = allListItems.indexOf(focusedListItem);
                var selectedOption = this.props.options[focusedIndex];
                this._applySelection(selectedOption, focusedIndex);
            }
        }
    }, {
        key: '_onMenuItemClick',
        value: function _onMenuItemClick(event, option, index) {
            // prevent any navigation resulting from click
            event.preventDefault();
            this._applySelection(option, index);
        }
    }, {
        key: '_applySelection',
        value: function _applySelection(option, index) {
            this.setState({
                selectedOption: option,
                menuOpen: false
            });

            if (this.props.onChange) {
                this.props.onChange(option, index);
            }

            //restore the focus on the button element
            if (this.buttonRef && this.buttonRef.focus) {
                this.buttonRef.focus();
            }
        }
    }, {
        key: '_optionToLabel',
        value: function _optionToLabel(option) {
            if (!option) {
                return '';
            }

            if (this.props.labelField) {
                return option[this.props.labelField];
            } else if (this.props.labelFunction) {
                return this.props.labelFunction(option);
            } else {
                return option.toString();
            }
        }
    }, {
        key: 'render',
        value: function render() {
            var _this3 = this;

            // console.log('render', this.state.menuOpen);
            var _props = this.props,
                disabled = _props.disabled,
                options = _props.options,
                style = _props.style,
                title = _props.title,
                _props$footer = _props.footer,
                footer = _props$footer === undefined ? undefined : _props$footer;

            var extraClass = this.props.className || '';
            var openClass = this.state.menuOpen ? 'Dropdown-menu-open' : 'Dropdown-menu-closed';
            var promptClass = !this.state.selectedOption ? 'Dropdown-placeholder' : '';

            var noOptions = !options || !options.length;
            var buttonDisabled = disabled || noOptions;
            var buttonLabel = this._optionToLabel(this.state.selectedOption) || this.props.placeholder;
            var buttonTitle = title || buttonLabel;
            var menuWidth = this.buttonRef && this.buttonRef.offsetWidth || 0;

            return _react2.default.createElement(
                'div',
                { className: 'Dropdown ' + openClass + ' ' + extraClass, style: style },
                _react2.default.createElement(
                    'button',
                    {
                        ref: function ref(button) {
                            _this3.buttonRef = button;
                        },
                        className: 'Dropdown-button ' + promptClass,
                        disabled: buttonDisabled,
                        title: buttonTitle,
                        onClick: this._onDropdownMouseEvent,
                        onKeyDown: this._keyEvent
                    },
                    buttonLabel
                ),
                _react2.default.createElement(
                    'a',
                    {
                        ref: function ref(thumb) {
                            _this3.thumbRef = thumb;
                        },
                        className: 'Dropdown-thumb',
                        onClick: this._onDropdownMouseEvent
                    },
                    _react2.default.createElement(_Icon.Icon, { icon: 'HardwareKeyboardArrowDown', size: 16 })
                ),
                this.state.menuOpen && _react2.default.createElement(
                    _FloatingElement.FloatingElement,
                    { targetElement: this.buttonRef, positionFunction: positionMenu, style: { width: menuWidth } },
                    _react2.default.createElement(
                        'div',
                        { ref: function ref(wrapper) {
                                return _this3.wrapperRef = wrapper;
                            } },
                        _react2.default.createElement(
                            'ul',
                            {
                                ref: function ref(list) {
                                    _this3.menuRef = list;
                                },
                                className: 'Dropdown-menu',
                                onWheel: this._onMenuScrollEvent
                            },
                            options && options.map(function (option, index) {
                                var selectedClass = _this3.state.selectedOption === option ? 'Dropdown-menu-item-selected' : '';
                                var optionLabel = _this3._optionToLabel(option);

                                return _react2.default.createElement(
                                    'li',
                                    { key: index, 'data-position': index, className: '' + selectedClass },
                                    _react2.default.createElement(
                                        'a',
                                        {
                                            className: 'Dropdown-menu-item ' + selectedClass,
                                            href: '#',
                                            onClick: function onClick(event) {
                                                return _this3._onMenuItemClick(event, option, index);
                                            }
                                        },
                                        optionLabel
                                    )
                                );
                            })
                        ),
                        footer
                    )
                )
            );
        }
    }, {
        key: 'selectedOption',
        get: function get() {
            return this.state.selectedOption;
        }
    }]);

    return Dropdown;
}(_react2.default.Component);

var BORDER_OFFSET = 2;

// eslint-disable-next-line max-len, no-unused-vars
function positionMenu(selfWidth, selfHeight, targetWidth, targetHeight, targetLeft, targetTop, viewportWidth, viewportHeight) {
    var newTop = targetTop + targetHeight + BORDER_OFFSET;
    if (selfHeight + BORDER_OFFSET > viewportHeight) {
        newTop = 0;
    } else if (newTop + selfHeight + BORDER_OFFSET > viewportHeight) {
        newTop = viewportHeight - (selfHeight + BORDER_OFFSET);
    }
    return {
        newLeft: targetLeft,
        newTop: newTop
    };
}

Dropdown.propTypes = {
    className: _react.PropTypes.string,
    style: _react.PropTypes.object,
    placeholder: _react.PropTypes.string,
    options: _react.PropTypes.array,
    defaultOption: _react.PropTypes.oneOfType([_react.PropTypes.node, _react.PropTypes.object]),
    title: _react.PropTypes.string,
    labelField: _react.PropTypes.string,
    labelFunction: _react.PropTypes.func,
    disabled: _react.PropTypes.bool,
    onChange: _react.PropTypes.func,
    footer: _react.PropTypes.element
};

Dropdown.defaultProps = {
    placeholder: 'Select an option'
};
//# sourceMappingURL=Dropdown.js.map
