'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _storybook = require('@kadira/storybook');

var _components = require('../components');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

(0, _storybook.storiesOf)('Dialog', module).add('Easy', renderEasy).add('Easy - No Title', renderEasyNoTitle).add('Easy - No Buttons', renderEasyNoButtons).add('Input', function () {
    return renderWithClassName('Dialog--input');
}).add('Error', function () {
    return renderWithClassName('Dialog--error');
}).add('Success', function () {
    return renderWithClassName('Dialog--success');
}).add('Warning', function () {
    return renderWithClassName('Dialog--warning');
}).add('Barebones', renderBarebones).add('Artisanal', renderArtisanal);

//--------------------------------------
//  Stories
//--------------------------------------

// Render with a dialog class name
function renderWithClassName(className) {

    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
            'p',
            null,
            'Background page.'
        ),
        _react2.default.createElement(
            _components.Dialog,
            { onDismiss: function onDismiss() {
                    return console.log('User dismiss');
                },
                title: 'ClassName ' + className,
                className: className },
            _react2.default.createElement(
                'p',
                null,
                'Voltage and magnetism form a pair of twins; they are two halves of a duality.'
            )
        )
    );
}

// Easy-to-use (least flexible) dialog component example
function renderEasy() {

    var buttons = [_react2.default.createElement(
        'button',
        null,
        'C\'est ne Pas'
    ), _react2.default.createElement(
        'button',
        null,
        'Une Button'
    )];

    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
            'p',
            null,
            'Background page.'
        ),
        _react2.default.createElement(
            _components.Dialog,
            { onDismiss: function onDismiss() {
                    return console.log('User dismiss');
                },
                title: 'Easy to Use Dialog',
                buttons: buttons },
            _react2.default.createElement(
                'p',
                null,
                'Designed for the common case, to make life easy.'
            ),
            _react2.default.createElement(ToggleWide, null),
            _react2.default.createElement(ToggleTall, null)
        )
    );
}

// Easy-to-use (least flexible) dialog component example - no title set
function renderEasyNoTitle() {

    var buttons = _react2.default.createElement(
        'button',
        null,
        'Do Stuff'
    );

    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
            'p',
            null,
            'Background page.'
        ),
        _react2.default.createElement(
            _components.Dialog,
            { onDismiss: function onDismiss() {
                    return console.log('User dismiss');
                },
                buttons: buttons },
            _react2.default.createElement(
                'p',
                null,
                'This dialog was not given a title.'
            ),
            _react2.default.createElement(ToggleWide, null),
            _react2.default.createElement(ToggleTall, null)
        )
    );
}

// Easy-to-use (least flexible) dialog component example - no buttons provided
function renderEasyNoButtons() {

    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
            'p',
            null,
            'Background page.'
        ),
        _react2.default.createElement(
            _components.Dialog,
            { onDismiss: function onDismiss() {
                    return console.log('User dismiss');
                },
                title: 'Default Button Bar' },
            _react2.default.createElement(
                'p',
                null,
                'Demonstrates default close button when no buttons specified.'
            )
        )
    );
}

// Basic "shell" of a dialog
function renderBarebones() {
    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
            'p',
            null,
            'Background page.'
        ),
        _react2.default.createElement(
            _components.BasicDialog,
            { onDismiss: function onDismiss() {
                    return console.log('User dismiss');
                } },
            _react2.default.createElement(
                'h3',
                null,
                'This is a barebones dialog'
            ),
            _react2.default.createElement(
                'p',
                null,
                'It doesn\'t do a lot for you, but you can put whatever you like in it.'
            ),
            _react2.default.createElement(ToggleWide, null),
            _react2.default.createElement(ToggleTall, null)
        )
    );
}

// Regular old dialog, only hand-crafted with love and moonbeams
function renderArtisanal() {
    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
            'p',
            null,
            'Background page.'
        ),
        _react2.default.createElement(
            _components.BasicDialog,
            { onDismiss: function onDismiss() {
                    return console.log('User dismiss');
                } },
            _react2.default.createElement(
                _components.DialogHeader,
                null,
                'Bespoke Artisanal Dialog'
            ),
            _react2.default.createElement(
                _components.DialogContent,
                null,
                _react2.default.createElement(
                    'p',
                    null,
                    'You can also manually construct a dialog out of all the various helper components. Exciting.'
                ),
                _react2.default.createElement(ToggleWide, null),
                _react2.default.createElement(ToggleTall, null)
            ),
            _react2.default.createElement(
                _components.DialogButtonBar,
                null,
                _react2.default.createElement(
                    'button',
                    null,
                    'Button'
                ),
                _react2.default.createElement(
                    'button',
                    null,
                    'Bar'
                ),
                _react2.default.createElement(
                    'button',
                    null,
                    'Buttons'
                )
            )
        )
    );
}

//--------------------------------------
//  Helpers
//--------------------------------------

var ToggleWide = function (_Component) {
    _inherits(ToggleWide, _Component);

    function ToggleWide() {
        _classCallCheck(this, ToggleWide);

        return _possibleConstructorReturn(this, (ToggleWide.__proto__ || Object.getPrototypeOf(ToggleWide)).apply(this, arguments));
    }

    _createClass(ToggleWide, [{
        key: 'render',
        value: function render() {
            var _this2 = this;

            var _ref = this.state || {},
                _ref$active = _ref.active,
                active = _ref$active === undefined ? false : _ref$active;

            var expando = active && _react2.default.createElement(
                'p',
                null,
                'Lorem ipsum dolor sit amet, consectetur adipisicing elit. Atque autem consequatur delectus dolorum eaque eius illo, ipsa itaque nam nesciunt odio, officiis provident, tempore unde veniam vitae voluptatibus. Architecto, ea?'
            );

            return _react2.default.createElement(
                'div',
                { style: { margin: '0.5em 0' } },
                _react2.default.createElement(
                    'button',
                    { onClick: function onClick() {
                            return _this2.setState({ active: !active });
                        } },
                    'Toggle Wide'
                ),
                expando
            );
        }
    }]);

    return ToggleWide;
}(_react.Component);

var ToggleTall = function (_Component2) {
    _inherits(ToggleTall, _Component2);

    function ToggleTall() {
        _classCallCheck(this, ToggleTall);

        return _possibleConstructorReturn(this, (ToggleTall.__proto__ || Object.getPrototypeOf(ToggleTall)).apply(this, arguments));
    }

    _createClass(ToggleTall, [{
        key: 'render',
        value: function render() {
            var _this4 = this;

            var tallStyle = {
                padding: '1rem',
                height: '80rem',
                border: 'dashed 2px #ddd'
            };

            var _ref2 = this.state || {},
                _ref2$active = _ref2.active,
                active = _ref2$active === undefined ? false : _ref2$active;

            var expando = active && _react2.default.createElement(
                'p',
                { style: tallStyle },
                'Tall'
            );

            return _react2.default.createElement(
                'div',
                { style: { margin: '0.5em 0' } },
                _react2.default.createElement(
                    'button',
                    { onClick: function onClick() {
                            return _this4.setState({ active: !active });
                        } },
                    'Toggle Tall'
                ),
                expando
            );
        }
    }]);

    return ToggleTall;
}(_react.Component);
//# sourceMappingURL=DialogStories.js.map
