'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _storybook = require('@kadira/storybook');

var _components = require('../components');

var _Utils = require('./Utils');

var _Utils2 = _interopRequireDefault(_Utils);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(0, _storybook.storiesOf)('Dropdown', module).add('general', function () {
    return _react2.default.createElement(General, null);
}).add('footer', function () {
    return _react2.default.createElement(Footer, null);
}).add('In Dialog', function () {
    return _react2.default.createElement(InDialog, null);
}).add('labeling', function () {
    return _react2.default.createElement(LabelOptions, null);
}).add('keyboard & focus', function () {
    return _react2.default.createElement(KeyboardFocus, null);
}).add('callbacks', function () {
    return _react2.default.createElement(Callbacks, null);
});

var style = {
    padding: 10,
    width: 200
};

var a2z = 'ABCDEFGHIJKLM NOPQRSTUVWXYZ';

function createOptions() {
    var text = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'Option';
    var asObject = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

    var options = [];

    for (var index = 0; index < 200; index++) {
        var label = text + ' ' + (options.length + 1);
        options.push(!asObject ? label : { label: label });
    }
    return options;
}

function InDialog() {
    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
            'p',
            null,
            'Background page.'
        ),
        _react2.default.createElement(
            _components.Dialog,
            { title: 'Not testing the Dialog' },
            _react2.default.createElement(
                'div',
                { style: { maxWidth: '40em' } },
                _react2.default.createElement(
                    'p',
                    null,
                    'Class condimentum augue sapien sed a fermentum purus mi a fusce ridiculus ultricies vel vivamus vestibulum nullam consequat et suspendisse montes consectetur enim nam phasellus id faucibus elementum malesuada. Elit aenean dolor adipiscing duis.'
                ),
                _react2.default.createElement(General, null)
            )
        )
    );
}

function General() {
    _Utils2.default.createCssRule('.Dropdown-Default .Dropdown-placeholder', 'font-style: italic', 'text-transform: uppercase');

    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
            'div',
            { style: style },
            _react2.default.createElement(
                'p',
                null,
                'Default'
            ),
            _react2.default.createElement(_components.Dropdown, {
                options: createOptions()
            })
        ),
        _react2.default.createElement(
            'div',
            { style: style },
            _react2.default.createElement(
                'p',
                null,
                'Disabled'
            ),
            _react2.default.createElement(_components.Dropdown, {
                options: createOptions(),
                disabled: true
            })
        ),
        _react2.default.createElement(
            'div',
            { style: style },
            _react2.default.createElement(
                'p',
                null,
                'Default Value'
            ),
            _react2.default.createElement(_components.Dropdown, {
                options: createOptions(),
                defaultOption: 'Option 3'
            })
        ),
        _react2.default.createElement(
            'div',
            { className: 'Dropdown-Default', style: style },
            _react2.default.createElement(
                'p',
                null,
                'Placeholder Styling'
            ),
            _react2.default.createElement(_components.Dropdown, {
                options: createOptions()
            })
        ),
        _react2.default.createElement(
            'div',
            { style: _extends({}, style, { maxWidth: 150 }) },
            _react2.default.createElement(
                'p',
                null,
                'Truncation'
            ),
            _react2.default.createElement(_components.Dropdown, {
                placeholder: 'Truncated because the text is too long',
                options: createOptions(a2z)
            })
        )
    );
}
function Footer() {
    _Utils2.default.createCssRule('.Dropdown-Default .Dropdown-placeholder', 'font-style: italic', 'text-transform: uppercase');
    var footerStyle = {
        padding: '5px',
        borderBottom: '1px solid rgba(73, 73, 73, 0.5)',
        borderLeft: '1px solid rgba(73, 73, 73, 0.5)',
        borderRight: '1px solid rgba(73, 73, 73, 0.5)',
        borderColor: '#4A90E2'
    };

    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
            'div',
            { style: style },
            _react2.default.createElement(
                'p',
                null,
                'With footer'
            ),
            _react2.default.createElement(_components.Dropdown, {
                defaultOption: 'Option 3',
                footer: _react2.default.createElement(
                    'div',
                    { style: footerStyle },
                    'This is a custom footer'
                ),
                options: createOptions()
            })
        )
    );
}

function LabelOptions() {
    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
            'div',
            { style: style },
            _react2.default.createElement(
                'p',
                null,
                'Using labelField=label'
            ),
            _react2.default.createElement(_components.Dropdown, {
                labelField: 'label',
                options: createOptions('Option', true)
            })
        ),
        _react2.default.createElement(
            'div',
            { style: style },
            _react2.default.createElement(
                'p',
                null,
                'Using labeFunction'
            ),
            _react2.default.createElement(_components.Dropdown, {
                labelFunction: function labelFunction(val) {
                    return '\\m/ ' + val.label + ' \\m/';
                },
                options: createOptions('Option', true)
            })
        )
    );
}

function KeyboardFocus() {
    var style = {
        display: 'flex',
        flexDirection: 'column',
        justifyContent: 'space-between',
        alignItems: 'flex-start',
        padding: 10,
        width: 300,
        height: 400
    };

    var options = createOptions();
    options.unshift(a2z);

    return _react2.default.createElement(
        'div',
        { style: style },
        _react2.default.createElement(
            'p',
            null,
            'This Layout is useful for demonstrating keyboard accessibility and focus behavior, especially as compared to a standard select box.'
        ),
        _react2.default.createElement(
            'button',
            null,
            'Test 1'
        ),
        _react2.default.createElement(
            'select',
            null,
            _react2.default.createElement(
                'option',
                { disabled: true, selected: true },
                '- Select -'
            ),
            options.map(function (opt, index) {
                return _react2.default.createElement(
                    'option',
                    { key: index },
                    opt
                );
            })
        ),
        _react2.default.createElement(
            'button',
            null,
            'Test 2'
        ),
        _react2.default.createElement(_components.Dropdown, {
            options: options
        }),
        _react2.default.createElement(
            'button',
            null,
            'Test 3'
        )
    );
}

function Callbacks() {
    var options = createOptions();

    var style = {
        padding: 10
    };

    var refs = {
        dropdown: null
    };

    function changeHandler(val, index) {
        console.log('onChange val=' + val + ', index=' + index);
    }

    function selectedHandler() {
        console.log('selectedOption=', refs.dropdown.selectedOption);
    }

    return _react2.default.createElement(
        'div',
        { style: style },
        _react2.default.createElement(_components.Dropdown, {
            ref: function ref(dropdown) {
                return refs.dropdown = dropdown;
            },
            style: { width: 200, marginRight: 10 },
            options: options,
            onChange: changeHandler
        }),
        _react2.default.createElement(
            'button',
            { onClick: selectedHandler },
            'Log Selected'
        )
    );
}
//# sourceMappingURL=DropdownStories.js.map
