'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _storybook = require('@kadira/storybook');

var _components = require('../components');

var _TimeDuration = require('../components/TimeDuration');

var _lipsum = require('./lipsum');

var _lipsum2 = _interopRequireDefault(_lipsum);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(0, _storybook.storiesOf)('ResultItem').add('Basic', basicStory).add('URLs', urlStory);

var wrapperStyle = {
    padding: '1em'
};

var __ctr = 1;

var strings = {
    "common.date.duration.display.format": "M [mos], d [Tage], h[Std.], m[m], s[s]",
    "common.date.duration.format": "m[ Minuten] s[ Sekunden]",
    "common.date.duration.hint.format": "M [Monate], d [Tage], h[Std.], m[m], s[s]"
};

var t = function t(key) {
    return strings[key] || key;
};

function moLipsum() {

    var l = _lipsum2.default.length;

    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
            'p',
            null,
            _lipsum2.default[++__ctr % l]
        ),
        _react2.default.createElement(
            'p',
            null,
            _lipsum2.default[++__ctr % l]
        )
    );
}

function onExpand(data) {
    // eslint-disable-next-line
    console.log('Expanding', data);
}

function onCollapse(data) {
    // eslint-disable-next-line
    console.log('Collapsing', data);
}

function standardDe() {
    return _react2.default.createElement(_TimeDuration.TimeDuration, {
        millis: 5000000,
        locale: 'de',
        t: t
    });
}

function liveUpdateDe() {
    return _react2.default.createElement(_TimeDuration.TimeDuration, {
        liveUpdate: true,
        updatePeriod: 3000,
        millis: 50000,
        locale: 'de',
        t: t
    });
}

function basicStory() {

    return _react2.default.createElement(
        'div',
        { style: wrapperStyle },
        _react2.default.createElement(
            _components.ResultItem,
            { result: 'success', label: 'Successful Step custom object', extraInfo: standardDe(), onExpand: onExpand,
                onCollapse: onCollapse, data: 'bravo' },
            moLipsum()
        ),
        _react2.default.createElement(
            _components.ResultItem,
            { result: 'success', label: 'Successful Step custom objectLive', extraInfo: liveUpdateDe(), onExpand: onExpand,
                onCollapse: onCollapse, data: 'bravo' },
            moLipsum()
        ),
        _react2.default.createElement(
            _components.ResultItem,
            { result: 'success', label: 'Successful Step', extraInfo: '11 sec', onExpand: onExpand,
                onCollapse: onCollapse, data: 'bravo' },
            moLipsum()
        ),
        _react2.default.createElement(
            _components.ResultItem,
            { result: 'failure', label: 'Failed Step', extraInfo: '29 sec', onExpand: onExpand,
                onCollapse: onCollapse, data: 'charlie' },
            moLipsum()
        ),
        _react2.default.createElement(
            _components.ResultItem,
            { result: 'queued', label: 'Pending Step', extraInfo: '1 millis', onExpand: onExpand,
                onCollapse: onCollapse, data: 'delta' },
            moLipsum()
        ),
        _react2.default.createElement(
            _components.ResultItem,
            { result: 'aborted', label: 'Aborted Step', extraInfo: '1 min, 12 sec', onExpand: onExpand,
                onCollapse: onCollapse, data: 'echo' },
            moLipsum()
        ),
        _react2.default.createElement(
            _components.ResultItem,
            { result: 'paused', label: 'Paused Step', extraInfo: '1 min, 12 sec', onExpand: onExpand,
                onCollapse: onCollapse, data: 'echo' },
            moLipsum()
        ),
        _react2.default.createElement(
            _components.ResultItem,
            { result: 'aborted', label: 'Aborted Step', extraInfo: '1 min, 12 sec', onExpand: onExpand,
                onCollapse: onCollapse, data: 'echo' },
            moLipsum()
        ),
        _react2.default.createElement(
            _components.ResultItem,
            { result: 'success', label: 'Expanded by default step', extraInfo: '13 sec', onExpand: onExpand,
                onCollapse: onCollapse, data: 'foxtrot', expanded: 'true' },
            moLipsum()
        ),
        _react2.default.createElement(
            'h2',
            null,
            'Separator'
        ),
        _react2.default.createElement(
            _components.ResultItem,
            { result: 'running', label: 'Running Step, with taller child', extraInfo: 'a few seconds',
                onExpand: onExpand, onCollapse: onCollapse, data: 'foxtrot' },
            _react2.default.createElement(
                'p',
                null,
                'Lorem ipsum dolor sit amet, consectetur adipisicing elit. Consequuntur deserunt dicta impedit nam quaerat quasi sapiente sint ullam veniam.'
            ),
            _react2.default.createElement(
                'p',
                null,
                '\xA0'
            ),
            _react2.default.createElement(
                'p',
                null,
                '\xA0'
            ),
            _react2.default.createElement(
                'p',
                null,
                '\xA0'
            ),
            _react2.default.createElement(
                'p',
                null,
                '\xA0'
            ),
            _react2.default.createElement(
                'p',
                null,
                '\xA0'
            ),
            _react2.default.createElement(
                'p',
                null,
                '\xA0'
            ),
            _react2.default.createElement(
                'p',
                { style: { textAlign: 'center' } },
                _react2.default.createElement(
                    'i',
                    null,
                    'This space intentionally left blank'
                )
            ),
            _react2.default.createElement(
                'p',
                null,
                '\xA0'
            ),
            _react2.default.createElement(
                'p',
                null,
                '\xA0'
            ),
            _react2.default.createElement(
                'p',
                null,
                '\xA0'
            ),
            _react2.default.createElement(
                'p',
                null,
                '\xA0'
            ),
            _react2.default.createElement(
                'p',
                null,
                '\xA0'
            ),
            _react2.default.createElement(
                'p',
                null,
                '\xA0'
            ),
            _react2.default.createElement(
                'p',
                null,
                'Eius enim magnam obcaecati perferendis quam?'
            )
        ),
        _react2.default.createElement(
            'h2',
            null,
            'Separator'
        ),
        _react2.default.createElement(
            _components.ResultItem,
            { result: 'unstable', label: 'Unstable Step', extraInfo: '55 sec', onExpand: onExpand,
                onCollapse: onCollapse, data: 'golf' },
            moLipsum()
        ),
        _react2.default.createElement(_components.ResultItem, { result: 'not_built', label: 'Not Built Step - no details' }),
        _react2.default.createElement(
            _components.ResultItem,
            { result: 'unknown', label: 'Unknown Step', extraInfo: '5 minutes', onExpand: onExpand,
                onCollapse: onCollapse, data: 'indigo' },
            moLipsum()
        )
    );
}

function urlStory() {

    var longAssTitle = 'This https://en.wikipedia.org/wiki/Label is long. You just won\'t believe how vastly ' + 'hugely mindbogglingly long it is. I mean you may think it\'s a long way down the road to the chemist\'s, ' + 'but that\'s just peanuts to this title. Also, lipsum. ' + _lipsum2.default[0];

    return _react2.default.createElement(
        'div',
        { style: wrapperStyle },
        _react2.default.createElement(
            _components.ResultItem,
            { result: 'success',
                label: 'Put a https://en.wikipedia.org/wiki/URL all up in yo https://en.wikipedia.org/wiki/Label',
                onExpand: onExpand,
                onCollapse: onCollapse,
                data: 'bravo' },
            moLipsum()
        ),
        _react2.default.createElement('br', null),
        _react2.default.createElement(
            _components.ResultItem,
            { result: 'success',
                label: 'However, ceci.nest.pas.une.url.com nor is foo.com.bar',
                onExpand: onExpand,
                onCollapse: onCollapse,
                data: 'pipey-mcpipeface' },
            moLipsum()
        ),
        _react2.default.createElement('br', null),
        _react2.default.createElement(
            _components.ResultItem,
            { result: 'running',
                label: longAssTitle,
                onExpand: onExpand,
                onCollapse: onCollapse,
                extraInfo: 'XXXX',
                data: 'bravo' },
            moLipsum()
        )
    );
}
//# sourceMappingURL=resultItemStories.js.map
