'use strict';

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _storybook = require('@kadira/storybook');

var _components = require('../components');

var _SvgStatus = require('../components/status/SvgStatus');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var resultValues = [['Running 0%', 'running', 0], ['Running 33%', 'running', 33], ['Running 50%', 'running', 50], ['Running 99%', 'running', 99], ['Running 100%', 'running', 100], ['Running 120%', 'running', 120], ['Success', 'success'], ['Failure', 'failure'], ['Queued', 'queued'], ['Unstable', 'unstable'], ['Aborted', 'aborted'], ['Not Built', 'not_built', 77], ['Skipped', 'skipped'], ['Unknown', 'unknown'], ['Paused', 'paused'], ['(invalid)', 'invalid_state'], ['(with space)', 'blah blah'], ['(null)', null], ['(gibberish)', 'hjgf%^\'"']];

var glyphResultValues = resultValues.slice(5); // Just skip all the repeats of "running"

(0, _storybook.storiesOf)('StatusIndicator', module).add('all', statusIndicatorStories).add('status glyphs', glyphStories).add('no bg, large', noBgLargeStories);

function statusIndicatorStories() {
    return _react2.default.createElement(
        'table',
        null,
        _react2.default.createElement(
            'thead',
            null,
            _react2.default.createElement(
                'tr',
                null,
                _react2.default.createElement(
                    'th',
                    null,
                    'Description'
                ),
                _react2.default.createElement(
                    'th',
                    null,
                    'Value'
                ),
                _react2.default.createElement(
                    'th',
                    null,
                    'StatusIndicator'
                )
            )
        ),
        _react2.default.createElement(
            'tbody',
            null,
            resultValues.map(function (testValue, i) {
                var _testValue = _slicedToArray(testValue, 3),
                    label = _testValue[0],
                    value = _testValue[1],
                    _testValue$ = _testValue[2],
                    percentage = _testValue$ === undefined ? 0 : _testValue$;

                return _react2.default.createElement(
                    'tr',
                    { key: i },
                    _react2.default.createElement(
                        'td',
                        null,
                        label
                    ),
                    _react2.default.createElement(
                        'td',
                        null,
                        value
                    ),
                    _react2.default.createElement(
                        'td',
                        null,
                        _react2.default.createElement(_components.StatusIndicator, { result: value, percentage: percentage })
                    )
                );
            })
        )
    );
}

function glyphStories() {
    return _react2.default.createElement(
        'table',
        null,
        _react2.default.createElement(
            'thead',
            null,
            _react2.default.createElement(
                'tr',
                null,
                _react2.default.createElement(
                    'th',
                    null,
                    'Description'
                ),
                _react2.default.createElement(
                    'th',
                    null,
                    'Value'
                ),
                _react2.default.createElement(
                    'th',
                    null,
                    'Glyph'
                )
            )
        ),
        _react2.default.createElement(
            'tbody',
            null,
            glyphResultValues.map(function (testValue, i) {
                var _testValue2 = _slicedToArray(testValue, 2),
                    label = _testValue2[0],
                    value = _testValue2[1];

                var glyph = (0, _SvgStatus.getGlyphFor)(value);
                return _react2.default.createElement(
                    'tr',
                    { key: i },
                    _react2.default.createElement(
                        'td',
                        null,
                        label
                    ),
                    _react2.default.createElement(
                        'td',
                        null,
                        value
                    ),
                    _react2.default.createElement(
                        'td',
                        null,
                        _react2.default.createElement(
                            'svg',
                            { width: '24', height: '24' },
                            _react2.default.createElement('rect', { x: '0', y: '0', height: '6', width: '6', fill: '#eee' }),
                            _react2.default.createElement('rect', { x: '12', y: '0', height: '6', width: '6', fill: '#eee' }),
                            _react2.default.createElement('rect', { x: '6', y: '6', height: '6', width: '6', fill: '#eee' }),
                            _react2.default.createElement('rect', { x: '18', y: '6', height: '6', width: '6', fill: '#eee' }),
                            _react2.default.createElement('rect', { x: '0', y: '12', height: '6', width: '6', fill: '#eee' }),
                            _react2.default.createElement('rect', { x: '12', y: '12', height: '6', width: '6', fill: '#eee' }),
                            _react2.default.createElement('rect', { x: '6', y: '18', height: '6', width: '6', fill: '#eee' }),
                            _react2.default.createElement('rect', { x: '18', y: '18', height: '6', width: '6', fill: '#eee' }),
                            _react2.default.createElement(
                                'g',
                                { transform: 'translate(12 12)' },
                                glyph
                            )
                        )
                    )
                );
            })
        )
    );
}

function noBgLargeStories() {
    var styleCell = {
        display: 'flex'
    };
    var styleIndicator = {
        backgroundColor: '#eee',
        border: '1px solid black'
    };
    return _react2.default.createElement(
        'table',
        null,
        _react2.default.createElement(
            'thead',
            null,
            _react2.default.createElement(
                'tr',
                null,
                _react2.default.createElement(
                    'th',
                    null,
                    'Description'
                ),
                _react2.default.createElement(
                    'th',
                    null,
                    'Value'
                ),
                _react2.default.createElement(
                    'th',
                    null,
                    'StatusIndicator'
                )
            )
        ),
        _react2.default.createElement(
            'tbody',
            null,
            resultValues.map(function (testValue, i) {
                var _testValue3 = _slicedToArray(testValue, 3),
                    label = _testValue3[0],
                    value = _testValue3[1],
                    _testValue3$ = _testValue3[2],
                    percentage = _testValue3$ === undefined ? 0 : _testValue3$;

                return _react2.default.createElement(
                    'tr',
                    { key: i },
                    _react2.default.createElement(
                        'td',
                        null,
                        label
                    ),
                    _react2.default.createElement(
                        'td',
                        null,
                        value
                    ),
                    _react2.default.createElement(
                        'td',
                        { style: styleCell },
                        _react2.default.createElement(
                            'span',
                            { style: styleIndicator },
                            _react2.default.createElement(_components.StatusIndicator, { noBackground: true, width: '100px', height: '100px',
                                result: value, percentage: percentage
                            })
                        )
                    )
                );
            })
        )
    );
}
//# sourceMappingURL=statusIndicatorStories.js.map
