'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Linkify = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _react3 = require('linkifyjs/react');

var _react4 = _interopRequireDefault(_react3);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// Makes sure we only linkify explicit URLs with expected protocols
function validateURL(value) {
    var explicitURL = /^(http|https|file|ftp|mailto):/i;
    return explicitURL.test(value);
}

// FIXME: How do we import the type of OriginalLinkify:props?

/**
 * Thin wrapper around http://soapbox.github.io/linkifyjs/ react component that (by default) only linkifies prefixed
 * URLs. Also allows us to expose this via JDL so the rest of BO doesn't need to install it.
 *
 * NB: This is currently tested by ResultItem-spec
 *
 * @param props
 */
var Linkify = exports.Linkify = function Linkify(props) {
    var childOptions = _extends({
        validate: validateURL
    }, props.options || {});

    var childProps = _extends({}, props, {
        options: childOptions
    });

    return _react2.default.createElement(_react4.default, childProps);
};

Linkify.propTypes = _extends({}, _react4.default.propTypes, {
    options: _react.PropTypes.object
});
Linkify.defaultProps = _react4.default.defaultProps;
//# sourceMappingURL=Linkify.js.map
