'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.ResultItem = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactAddonsCssTransitionGroup = require('react-addons-css-transition-group');

var _reactAddonsCssTransitionGroup2 = _interopRequireDefault(_reactAddonsCssTransitionGroup);

var _StatusIndicator = require('./status/StatusIndicator');

var _SvgStatus = require('./status/SvgStatus');

var _ = require('.');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var ResultItem = exports.ResultItem = function (_Component) {
    _inherits(ResultItem, _Component);

    function ResultItem(props) {
        _classCallCheck(this, ResultItem);

        var _this = _possibleConstructorReturn(this, (ResultItem.__proto__ || Object.getPrototypeOf(ResultItem)).call(this, props));

        _this.infiniteLoadingTimer = function () {
            _this.infiniteRotateDegrees += 1.5;

            if (_this.infiniteRotateDegrees >= 360) {
                _this.infiniteRotateDegrees = 0;
            }

            _this.animatedElement.setAttribute('transform', 'rotate(' + _this.infiniteRotateDegrees + ')');
            _this.requestAnimationFrameId = requestAnimationFrame(_this.infiniteLoadingTimer);
        };

        _this.toggleExpanded = function (e) {
            var selection = window.getSelection ? window.getSelection() : false;
            var selected = selection && selection.toString();
            if (_this.props.children && !selected) {
                var _expanded = !_this.state.expanded;

                _this.setState({ expanded: _expanded }, function () {
                    var _this$props = _this.props,
                        data = _this$props.data,
                        onExpand = _this$props.onExpand,
                        onCollapse = _this$props.onCollapse;
                    // Data is arbitrary, set by parent

                    if (onExpand && _expanded) {
                        onExpand(data, e);
                    }

                    if (onCollapse && !_expanded) {
                        onCollapse(data, e);
                    }
                });
            }
        };

        _this.urlClicked = function (e) {
            e.stopPropagation();
        };

        _this.state = {
            resultClean: _StatusIndicator.StatusIndicator.validResultValues.unknown,
            statusGlyph: null,
            expanded: props.expanded || false
        };
        return _this;
    }

    _createClass(ResultItem, [{
        key: 'componentWillMount',
        value: function componentWillMount() {
            this.handleProps(this.props, this.props);

            this.infiniteRotationRunning = false;
            this.infiniteRotateDegrees = 0;
            this.isEdgeOrIE = !!window.MSInputMethodContext && !!document.documentMode || window.navigator.userAgent.indexOf('Edge') > -1;
        }
    }, {
        key: 'componentWillReceiveProps',
        value: function componentWillReceiveProps(nextProps) {
            this.handleProps(nextProps, this.props);
        }
    }, {
        key: 'handleProps',
        value: function handleProps(props, oldProps) {
            var resultClean = (0, _StatusIndicator.decodeResultValue)(props.result);
            if (resultClean !== this.state.resultClean) {
                var _statusGlyph = (0, _SvgStatus.getGlyphFor)(resultClean);
                this.setState({ resultClean: resultClean, statusGlyph: _statusGlyph });
            }

            var newExpanded = !!props.expanded;
            if (newExpanded !== !!oldProps.expanded) {
                // check whether we want to change the state or whether we already are in the correct state
                if (newExpanded !== this.state.expanded) {
                    this.toggleExpanded();
                }
            }
        }
    }, {
        key: 'componentWillUnmount',
        value: function componentWillUnmount() {
            cancelAnimationFrame(this.requestAnimationFrameId);
        }
    }, {
        key: 'render',
        value: function render() {
            var _this2 = this;

            var _props = this.props,
                label = _props.label,
                extraInfo = _props.extraInfo;
            var _state = this.state,
                resultClean = _state.resultClean,
                statusGlyph = _state.statusGlyph;


            var hasChildren = !!this.props.children;
            var expanded = this.state.expanded && hasChildren;

            var classes = ['result-item', resultClean];

            if (expanded) {
                classes.push('expanded');
            }

            var outerClassName = classes.join(' ');
            var iconClassName = 'result-item-icon result-bg ' + resultClean;
            var isIconSpinning = resultClean === 'running' && !this.infiniteRotationRunning ? 'spinAnimation' : '';

            var linkifyOptions = {
                attributes: {
                    onClick: this.urlClicked
                }
            };

            if (resultClean === 'running' && !this.infiniteRotationRunning && this.isEdgeOrIE) {
                requestAnimationFrame(this.infiniteLoadingTimer);
                this.infiniteRotationRunning = true;
            }

            return _react2.default.createElement(
                'div',
                { className: outerClassName },
                _react2.default.createElement(
                    'div',
                    { className: 'result-item-head', onClick: this.toggleExpanded },
                    _react2.default.createElement(
                        'span',
                        { className: iconClassName },
                        _react2.default.createElement(
                            'svg',
                            { width: '28', height: '34' },
                            _react2.default.createElement(
                                'g',
                                { transform: 'translate(14 18)', className: 'result-status-glyph' },
                                _react2.default.createElement(
                                    'g',
                                    { className: isIconSpinning, ref: function ref(c) {
                                            return _this2.animatedElement = c;
                                        } },
                                    statusGlyph
                                )
                            )
                        )
                    ),
                    _react2.default.createElement(
                        'span',
                        { className: 'result-item-title' },
                        _react2.default.createElement(Expando, { expanded: expanded, disabled: !hasChildren }),
                        _react2.default.createElement(
                            _.Linkify,
                            { className: 'result-item-label', options: linkifyOptions },
                            label
                        ),
                        _react2.default.createElement(
                            'span',
                            { className: 'result-item-extra-info' },
                            extraInfo
                        )
                    )
                ),
                _react2.default.createElement(
                    _reactAddonsCssTransitionGroup2.default,
                    {
                        transitionName: 'slide-down',
                        transitionAppear: true,
                        transitionAppearTimeout: 300,
                        transitionEnterTimeout: 300,
                        transitionLeaveTimeout: 300
                    },
                    expanded ? _react2.default.createElement(
                        'div',
                        { className: 'result-item-children', key: 'k' },
                        this.props.children
                    ) : null
                )
            );
        }
    }]);

    return ResultItem;
}(_react.Component);

ResultItem.propTypes = {
    result: _react.PropTypes.oneOf(Object.keys(_StatusIndicator.StatusIndicator.validResultValues)),
    label: _react.PropTypes.string,
    extraInfo: _react.PropTypes.oneOfType([_react.PropTypes.string, _react.PropTypes.object]),
    data: _react.PropTypes.any, // Whatever you want, will be sent back to listeners
    onExpand: _react.PropTypes.func, // f(data:*, originalEvent:?event)
    onCollapse: _react.PropTypes.func, // f(data:*, originalEvent:?event)
    children: _react.PropTypes.node
};

// We can extract this into an exported component if we need it elsewhere

var Expando = function (_Component2) {
    _inherits(Expando, _Component2);

    function Expando() {
        _classCallCheck(this, Expando);

        return _possibleConstructorReturn(this, (Expando.__proto__ || Object.getPrototypeOf(Expando)).apply(this, arguments));
    }

    _createClass(Expando, [{
        key: 'render',
        value: function render() {
            var classes = ['result-item-expando'];

            if (this.props.expanded) {
                classes.push('expanded');
            }

            if (this.props.disabled) {
                classes.push('disabled');
            }

            var outerClassName = classes.join(' ');
            return _react2.default.createElement(
                'svg',
                { width: '28', height: '24', className: outerClassName },
                _react2.default.createElement(
                    'g',
                    { transform: 'translate(14 12)' },
                    _react2.default.createElement(
                        'g',
                        { className: 'expando-glyph' },
                        _react2.default.createElement('polygon', { points: '-1.7,-5 3.3,0 -1.7,5 -2.9,3.8 1,0 -2.9,-3.8' })
                    )
                )
            );
        }
    }]);

    return Expando;
}(_react.Component);

Expando.propTypes = {
    expanded: _react.PropTypes.bool,
    disabled: _react.PropTypes.bool
};
//# sourceMappingURL=ResultItem.js.map
