'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.BasicHeader = undefined;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function classNameForStatusColor(statusColor) {
    switch (statusColor) {
        case null:
        case undefined:
        case '':
            return 'BasicHeader--default';
        case 'success':
            return 'BasicHeader--success';
        case 'failure':
            return 'BasicHeader--failure';
        case 'running':
            return 'BasicHeader--running';
        case 'queued':
        case 'not_built':
            return 'BasicHeader--notBuilt';
        case 'unstable':
            return 'BasicHeader--unstable';
        case 'aborted':
            return 'BasicHeader--aborted';
        case 'paused':
            return 'BasicHeader--paused';
    }

    return 'BasicHeader--unknown';
}

var BasicHeader = exports.BasicHeader = function BasicHeader(props) {
    var classNames = ['BasicHeader', classNameForStatusColor(props.statusColor)];

    if (props.className) {
        classNames.push(props.className);
    }

    return _react2.default.createElement(
        'section',
        { className: classNames.join(' ') },
        props.children
    );
};

BasicHeader.propTypes = {
    children: _react.PropTypes.node,
    statusColor: _react.PropTypes.string
};
//# sourceMappingURL=BasicHeader.js.map
